/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.YesNo;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.texture.CableBusTextures;
import appeng.core.settings.TickRates;
import appeng.core.sync.packets.PacketTransitionEffect;
import appeng.hooks.TickHandler;
import appeng.me.GridAccessException;
import appeng.parts.PartBasicState;
import appeng.server.ServerHelper;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

public class PartAnnihilationPlane
extends PartBasicState
implements IGridTickable,
IWorldCallable<TickRateModulation> {
    private static final IIcon SIDE_ICON = CableBusTextures.PartPlaneSides.getIcon();
    private static final IIcon BACK_ICON = CableBusTextures.PartTransitionPlaneBack.getIcon();
    private static final IIcon STATUS_ICON = CableBusTextures.PartMonitorSidesStatus.getIcon();
    private static final IIcon ACTIVE_ICON = CableBusTextures.BlockAnnihilationPlaneOn.getIcon();
    private static final int MAX_CACHE_TIME = 60;
    private final BaseActionSource mySrc = new MachineSource(this);
    private EntityPlayer owner = null;
    private boolean isAccepting = true;
    private boolean breaking = false;
    private YesNo permissionCache = YesNo.UNDECIDED;
    private int cacheTime = 0;

    public PartAnnihilationPlane(ItemStack is) {
        super(is);
    }

    @Override
    public void onPlacement(EntityPlayer player, ItemStack held, ForgeDirection side) {
        super.onPlacement(player, held, side);
        this.owner = player;
    }

    @Override
    public TickRateModulation call(World world) throws Exception {
        this.breaking = false;
        return this.breakBlock(true);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        boolean minX = true;
        boolean minY = true;
        int maxX = 15;
        int maxY = 15;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            int x = te.xCoord;
            int y = te.yCoord;
            int z = te.zCoord;
            ForgeDirection e = bch.getWorldX();
            ForgeDirection u = bch.getWorldY();
            if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x - e.offsetX, y - e.offsetY, z - e.offsetZ), this.getSide())) {
                minX = false;
            }
            if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x + e.offsetX, y + e.offsetY, z + e.offsetZ), this.getSide())) {
                maxX = 16;
            }
            if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x - u.offsetX, y - u.offsetY, z - u.offsetZ), this.getSide())) {
                minY = false;
            }
            if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x + u.offsetX, y + u.offsetY, z + u.offsetZ), this.getSide())) {
                maxY = 16;
            }
        }
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox((double)minX, (double)minY, 15.0, maxX, maxY, bch.isBBCollision() ? 15.0 : 16.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(SIDE_ICON, SIDE_ICON, BACK_ICON, this.getItemStack().getIconIndex(), SIDE_ICON, SIDE_ICON);
        rh.setBounds(1.0f, 1.0f, 15.0f, 15.0f, 15.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.renderStaticWithIcon(x, y, z, rh, renderer, ACTIVE_ICON);
    }

    protected void renderStaticWithIcon(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer, IIcon activeIcon) {
        boolean minX = true;
        ForgeDirection e = rh.getWorldX();
        ForgeDirection u = rh.getWorldY();
        TileEntity te = this.getHost().getTile();
        if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x - e.offsetX, y - e.offsetY, z - e.offsetZ), this.getSide())) {
            minX = false;
        }
        int maxX = 15;
        if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x + e.offsetX, y + e.offsetY, z + e.offsetZ), this.getSide())) {
            maxX = 16;
        }
        boolean minY = true;
        if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x - u.offsetX, y - u.offsetY, z - u.offsetZ), this.getSide())) {
            minY = false;
        }
        int maxY = 15;
        if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x + u.offsetX, y + u.offsetY, z + u.offsetZ), this.getSide())) {
            maxY = 16;
        }
        boolean isActive = (this.getClientFlags() & 3) == 3;
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, this, this.getRenderCache()));
        rh.setTexture(SIDE_ICON, SIDE_ICON, BACK_ICON, isActive ? activeIcon : this.getItemStack().getIconIndex(), SIDE_ICON, SIDE_ICON);
        rh.setBounds((float)minX, (float)minY, 15.0f, maxX, maxY, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(STATUS_ICON, STATUS_ICON, BACK_ICON, isActive ? activeIcon : this.getItemStack().getIconIndex(), STATUS_ICON, STATUS_ICON);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }

    @Override
    public void onNeighborChanged() {
        this.isAccepting = true;
        try {
            this.getProxy().getTick().alertDevice(this.getProxy().getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (this.isAccepting && entity instanceof EntityItem && !entity.isDead && Platform.isServer() && this.getProxy().isActive()) {
            boolean changed;
            boolean capture = false;
            switch (this.getSide()) {
                case DOWN: 
                case UP: {
                    if (!(entity.posX > (double)this.getTile().xCoord) || !(entity.posX < (double)(this.getTile().xCoord + 1)) || !(entity.posZ > (double)this.getTile().zCoord) || !(entity.posZ < (double)(this.getTile().zCoord + 1)) || !(entity.posY > (double)this.getTile().yCoord + 0.9 && this.getSide() == ForgeDirection.UP) && (!(entity.posY < (double)this.getTile().yCoord + 0.1) || this.getSide() != ForgeDirection.DOWN)) break;
                    capture = true;
                    break;
                }
                case SOUTH: 
                case NORTH: {
                    if (!(entity.posX > (double)this.getTile().xCoord) || !(entity.posX < (double)(this.getTile().xCoord + 1)) || !(entity.posY > (double)this.getTile().yCoord) || !(entity.posY < (double)(this.getTile().yCoord + 1)) || !(entity.posZ > (double)this.getTile().zCoord + 0.9 && this.getSide() == ForgeDirection.SOUTH) && (!(entity.posZ < (double)this.getTile().zCoord + 0.1) || this.getSide() != ForgeDirection.NORTH)) break;
                    capture = true;
                    break;
                }
                case EAST: 
                case WEST: {
                    if (!(entity.posZ > (double)this.getTile().zCoord) || !(entity.posZ < (double)(this.getTile().zCoord + 1)) || !(entity.posY > (double)this.getTile().yCoord) || !(entity.posY < (double)(this.getTile().yCoord + 1)) || !(entity.posX > (double)this.getTile().xCoord + 0.9 && this.getSide() == ForgeDirection.EAST) && (!(entity.posX < (double)this.getTile().xCoord + 0.1) || this.getSide() != ForgeDirection.WEST)) break;
                    capture = true;
                    break;
                }
            }
            if (capture && (changed = this.storeEntityItem((EntityItem)entity))) {
                ServerHelper.proxy.sendToAllNearExcept(null, this.getTile().xCoord, this.getTile().yCoord, this.getTile().zCoord, 64.0, this.getTile().getWorldObj(), new PacketTransitionEffect(entity.posX, entity.posY, entity.posZ, this.getSide(), false));
            }
        }
    }

    @Override
    public int cableConnectionRenderTo() {
        return 1;
    }

    private boolean storeEntityItem(EntityItem entityItem) {
        if (!entityItem.isDead) {
            IAEItemStack overflow = this.storeItemStack(entityItem.getEntityItem());
            return this.handleOverflow(entityItem, overflow);
        }
        return false;
    }

    private IAEItemStack storeItemStack(ItemStack item) {
        AEItemStack itemToStore = AEItemStack.create(item);
        try {
            IStorageGrid storage = this.getProxy().getStorage();
            IEnergyGrid energy = this.getProxy().getEnergy();
            IAEItemStack overflow = Platform.poweredInsert(energy, storage.getItemInventory(), itemToStore, this.mySrc);
            this.isAccepting = overflow == null;
            return overflow;
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    private boolean handleOverflow(EntityItem entityItem, IAEItemStack overflow) {
        if (overflow == null || overflow.getStackSize() == 0L) {
            entityItem.setDead();
            return true;
        }
        int oldStackSize = entityItem.getEntityItem().stackSize;
        int newStackSize = (int)overflow.getStackSize();
        boolean changed = oldStackSize != newStackSize;
        entityItem.getEntityItem().stackSize = newStackSize;
        return changed;
    }

    private void spawnOverflow(IAEItemStack overflow) {
        if (overflow == null) {
            return;
        }
        TileEntity te = this.getTile();
        WorldServer w = (WorldServer)te.getWorldObj();
        double x = (double)(te.xCoord + this.getSide().offsetX) + 0.5;
        double y = (double)(te.yCoord + this.getSide().offsetY) + 0.5;
        double z = (double)(te.zCoord + this.getSide().offsetZ) + 0.5;
        EntityItem overflowEntity = new EntityItem((World)w, x, y, z, overflow.getItemStack());
        overflowEntity.motionX = 0.0;
        overflowEntity.motionY = 0.0;
        overflowEntity.motionZ = 0.0;
        w.spawnEntityInWorld((Entity)overflowEntity);
    }

    protected boolean isAnnihilationPlane(TileEntity blockTileEntity, ForgeDirection side) {
        if (blockTileEntity instanceof IPartHost) {
            IPart p = ((IPartHost)blockTileEntity).getPart(side);
            return p != null && p.getClass() == this.getClass();
        }
        return false;
    }

    @Override
    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.onNeighborChanged();
        this.getHost().markForUpdate();
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.onNeighborChanged();
        this.getHost().markForUpdate();
    }

    private TickRateModulation breakBlock(boolean modulate) {
        if (this.isAccepting && this.getProxy().isActive()) {
            try {
                TileEntity te = this.getTile();
                WorldServer w = (WorldServer)te.getWorldObj();
                int x = te.xCoord + this.getSide().offsetX;
                int y = te.yCoord + this.getSide().offsetY;
                int z = te.zCoord + this.getSide().offsetZ;
                IEnergyGrid energy = this.getProxy().getEnergy();
                if (this.canHandleBlock(w, x, y, z)) {
                    List<ItemStack> items = this.obtainBlockDrops(w, x, y, z);
                    float requiredPower = this.calculateEnergyUsage(w, x, y, z, items);
                    boolean hasPower = energy.extractAEPower((double)requiredPower, Actionable.SIMULATE, PowerMultiplier.CONFIG) > (double)requiredPower - 0.1;
                    boolean canStore = this.canStoreItemStacks(items);
                    if (hasPower && canStore) {
                        if (modulate) {
                            energy.extractAEPower((double)requiredPower, Actionable.MODULATE, PowerMultiplier.CONFIG);
                            this.breakBlockAndStoreItems(w, x, y, z, items);
                            ServerHelper.proxy.sendToAllNearExcept(null, x, y, z, 64.0, (World)w, new PacketTransitionEffect(x, y, z, this.getSide(), true));
                        } else {
                            this.breaking = true;
                            TickHandler.INSTANCE.addCallable(this.getTile().getWorldObj(), this);
                        }
                        return TickRateModulation.URGENT;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return TickRateModulation.IDLE;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.AnnihilationPlane.getMin(), TickRates.AnnihilationPlane.getMax(), false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.breaking) {
            return TickRateModulation.URGENT;
        }
        if (ticksSinceLastCall == 120 || this.cacheTime >= 60) {
            this.cacheTime = 0;
            this.permissionCache = YesNo.UNDECIDED;
        }
        this.cacheTime += ticksSinceLastCall - 120;
        this.isAccepting = true;
        return this.breakBlock(false);
    }

    private boolean canHandleBlock(WorldServer w, int x, int y, int z) {
        EntityPlayer player;
        Block block = w.getBlock(x, y, z);
        Material material = block.getMaterial();
        float hardness = block.getBlockHardness((World)w, x, y, z);
        boolean ignoreMaterials = material == Material.air || material == Material.lava || material == Material.water || material.isLiquid();
        boolean ignoreBlocks = block == Blocks.bedrock || block == Blocks.end_portal || block == Blocks.end_portal_frame || block == Blocks.command_block;
        EntityPlayer entityPlayer = player = this.owner == null ? Platform.getPlayer(w) : this.owner;
        if (this.permissionCache == YesNo.UNDECIDED) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(x, y, z, (World)w, block, w.getBlockMetadata(x, y, z), player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.permissionCache = event.isCanceled() ? YesNo.NO : YesNo.YES;
        }
        return this.permissionCache == YesNo.YES && !ignoreMaterials && !ignoreBlocks && !w.isAirBlock(x, y, z) && w.blockExists(x, y, z) && w.canMineBlock(player, x, y, z) && hardness >= 0.0f;
    }

    protected List<ItemStack> obtainBlockDrops(WorldServer w, int x, int y, int z) {
        Object[] out = Platform.getBlockDrops((World)w, x, y, z);
        return Lists.newArrayList((Object[])out);
    }

    protected float calculateEnergyUsage(WorldServer w, int x, int y, int z, List<ItemStack> items) {
        Block block = w.getBlock(x, y, z);
        float hardness = block.getBlockHardness((World)w, x, y, z);
        float requiredEnergy = 1.0f + hardness;
        for (ItemStack is : items) {
            requiredEnergy += (float)is.stackSize;
        }
        return requiredEnergy;
    }

    private boolean canStoreItemStacks(List<ItemStack> itemStacks) {
        boolean canStore = itemStacks.isEmpty();
        try {
            IStorageGrid storage = this.getProxy().getStorage();
            for (ItemStack itemStack : itemStacks) {
                AEItemStack itemToTest = AEItemStack.create(itemStack);
                IAEItemStack overflow = storage.getItemInventory().injectItems(itemToTest, Actionable.SIMULATE, this.mySrc);
                if (overflow != null && itemToTest.getStackSize() <= overflow.getStackSize()) continue;
                canStore = true;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.isAccepting = canStore;
        return canStore;
    }

    private void breakBlockAndStoreItems(WorldServer w, int x, int y, int z, List<ItemStack> items) {
        w.setBlock(x, y, z, Platform.AIR_BLOCK, 0, 3);
        AxisAlignedBB box = AxisAlignedBB.getBoundingBox((double)((double)x - 0.2), (double)((double)y - 0.2), (double)((double)z - 0.2), (double)((double)x + 1.2), (double)((double)y + 1.2), (double)((double)z + 1.2));
        for (Object ei : w.getEntitiesWithinAABB(EntityItem.class, box)) {
            if (!(ei instanceof EntityItem)) continue;
            EntityItem entityItem = (EntityItem)ei;
            this.storeEntityItem(entityItem);
        }
        for (ItemStack snaggedItem : items) {
            IAEItemStack overflow = this.storeItemStack(snaggedItem);
            this.spawnOverflow(overflow);
        }
    }
}

