/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.AEApi;
import appeng.api.IAppEngApi;
import appeng.api.config.TunnelType;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IItemDefinition;
import appeng.api.features.IP2PTunnelRegistry;
import appeng.api.parts.IFacadePart;
import appeng.facade.FacadePart;
import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationHelper;
import appeng.integration.abstraction.IBuildCraftTransport;
import appeng.integration.modules.BCHelpers.BCPipeHandler;
import buildcraft.api.facades.IFacadeItem;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.PipeIconProvider;
import cpw.mods.fml.common.event.FMLInterModComms;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class BuildCraftTransport
implements IBuildCraftTransport,
IIntegrationModule {
    public static BuildCraftTransport instance;

    public BuildCraftTransport() {
        IntegrationHelper.testClassExistence(this, buildcraft.BuildCraftTransport.class);
        IntegrationHelper.testClassExistence(this, IFacadeItem.class);
        IntegrationHelper.testClassExistence(this, IInjectable.class);
        IntegrationHelper.testClassExistence(this, IPipeConnection.class);
        IntegrationHelper.testClassExistence(this, IPipeTile.class);
        IntegrationHelper.testClassExistence(this, IPipeTile.PipeType.class);
        IntegrationHelper.testClassExistence(this, ItemFacade.class);
        IntegrationHelper.testClassExistence(this, PipeIconProvider.class);
    }

    @Override
    public boolean isFacade(ItemStack is) {
        if (is == null) {
            return false;
        }
        return is.getItem() instanceof IFacadeItem;
    }

    @Override
    @Nullable
    public IFacadePart createFacadePart(Block blk, int meta, @Nonnull ForgeDirection side) {
        try {
            ItemFacade.FacadeState state = ItemFacade.FacadeState.create((Block)blk, (int)meta);
            ItemStack facade = ItemFacade.getFacade((ItemFacade.FacadeState[])new ItemFacade.FacadeState[]{state});
            return new FacadePart(facade, side);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public IFacadePart createFacadePart(@Nonnull ItemStack fs, @Nonnull ForgeDirection side) {
        return new FacadePart(fs, side);
    }

    @Override
    @Nullable
    public ItemStack getTextureForFacade(@Nonnull ItemStack facade) {
        Item maybeFacadeItem = facade.getItem();
        if (maybeFacadeItem instanceof IFacadeItem) {
            IFacadeItem facadeItem = (IFacadeItem)maybeFacadeItem;
            Block[] blocks = facadeItem.getBlocksForFacade(facade);
            int[] metas = facadeItem.getMetaValuesForFacade(facade);
            if (blocks.length > 0 && metas.length > 0) {
                return new ItemStack(blocks[0], 1, metas[0]);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IIcon getCobbleStructurePipeTexture() {
        try {
            return buildcraft.BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean isPipe(TileEntity te, @Nonnull ForgeDirection dir) {
        if (te instanceof IPipeTile) {
            IPipeTile pipeTile = (IPipeTile)te;
            return !pipeTile.hasPipePluggable(dir.getOpposite());
        }
        return false;
    }

    @Override
    public boolean canAddItemsToPipe(TileEntity te, ItemStack is, ForgeDirection dir) {
        int amt;
        IInjectable pt;
        return is != null && te != null && te instanceof IInjectable && (pt = (IInjectable)te).canInjectItems(dir) && (amt = pt.injectItem(is, false, dir, null)) == is.stackSize;
    }

    @Override
    public boolean addItemsToPipe(@Nullable TileEntity te, @Nullable ItemStack is, @Nonnull ForgeDirection dir) {
        int amt;
        IInjectable pt;
        if (is != null && te != null && te instanceof IInjectable && (pt = (IInjectable)te).canInjectItems(dir) && (amt = pt.injectItem(is, false, dir, null)) == is.stackSize) {
            pt.injectItem(is, true, dir, null);
            return true;
        }
        return false;
    }

    private void addFacade(ItemStack item) {
        if (item != null) {
            FMLInterModComms.sendMessage((String)"BuildCraft|Transport", (String)"add-facade", (ItemStack)item);
        }
    }

    private void registerPowerP2P() {
        IP2PTunnelRegistry registry = AEApi.instance().registries().p2pTunnel();
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipePowerCobblestone), TunnelType.RF_POWER);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipePowerDiamond), TunnelType.RF_POWER);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipePowerGold), TunnelType.RF_POWER);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipePowerQuartz), TunnelType.RF_POWER);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipePowerStone), TunnelType.RF_POWER);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipePowerWood), TunnelType.RF_POWER);
    }

    private void registerItemP2P() {
        IP2PTunnelRegistry registry = AEApi.instance().registries().p2pTunnel();
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeItemsWood), TunnelType.ITEM);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeItemsVoid), TunnelType.ITEM);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeItemsSandstone), TunnelType.ITEM);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeItemsQuartz), TunnelType.ITEM);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeItemsObsidian), TunnelType.ITEM);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeItemsIron), TunnelType.ITEM);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeItemsGold), TunnelType.ITEM);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeItemsEmerald), TunnelType.ITEM);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeItemsDiamond), TunnelType.ITEM);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeItemsStone), TunnelType.ITEM);
        registry.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeItemsCobblestone), TunnelType.ITEM);
    }

    private void registerLiquidsP2P() {
        IP2PTunnelRegistry reg = AEApi.instance().registries().p2pTunnel();
        reg.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeFluidsCobblestone), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeFluidsEmerald), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeFluidsGold), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeFluidsIron), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeFluidsSandstone), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeFluidsStone), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeFluidsVoid), TunnelType.FLUID);
        reg.addNewAttunement(new ItemStack(buildcraft.BuildCraftTransport.pipeFluidsWood), TunnelType.FLUID);
    }

    @Override
    public void init() throws Throwable {
        this.initPipeConnection();
        this.initFacades();
    }

    @Override
    public void postInit() {
        this.registerPowerP2P();
        this.registerItemP2P();
        this.registerLiquidsP2P();
    }

    private void initPipeConnection() {
        IAppEngApi api = AEApi.instance();
        api.partHelper().registerNewLayer("appeng.parts.layers.LayerIPipeConnection", "buildcraft.api.transport.IPipeConnection");
        api.registries().externalStorage().addExternalStorageInterface(new BCPipeHandler());
    }

    private void initFacades() {
        IAppEngApi api = AEApi.instance();
        IBlocks blocks = api.definitions().blocks();
        this.addFacadeStack(blocks.fluix());
        this.addFacadeStack(blocks.quartz());
        this.addFacadeStack(blocks.quartzChiseled());
        this.addFacadeStack(blocks.quartzPillar());
        for (Block skyStoneBlock : blocks.skyStone().maybeBlock().asSet()) {
            this.addFacade(new ItemStack(skyStoneBlock, 1, 0));
            this.addFacade(new ItemStack(skyStoneBlock, 1, 1));
            this.addFacade(new ItemStack(skyStoneBlock, 1, 2));
            this.addFacade(new ItemStack(skyStoneBlock, 1, 3));
        }
    }

    private void addFacadeStack(IItemDefinition definition) {
        for (ItemStack facadeStack : definition.maybeStack(1).asSet()) {
            this.addFacade(facadeStack);
        }
    }
}

