/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LightningFX
extends EntityFX {
    private static final Random RANDOM_GENERATOR = new Random();
    private static final int STEPS = 5;
    private final double[][] precomputedSteps;
    private final double[] vertices = new double[3];
    private final double[] verticesWithUV = new double[3];
    private boolean hasData = false;

    public LightningFX(World w, double x, double y, double z, double r, double g, double b) {
        this(w, x, y, z, r, g, b, 6);
        this.regen();
    }

    protected LightningFX(World w, double x, double y, double z, double r, double g, double b, int maxAge) {
        super(w, x, y, z, r, g, b);
        this.precomputedSteps = new double[5][3];
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.particleMaxAge = maxAge;
        this.noClip = true;
    }

    protected void regen() {
        double lastDirectionX = (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9;
        double lastDirectionY = (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9;
        double lastDirectionZ = (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9;
        for (int s = 0; s < 5; ++s) {
            this.precomputedSteps[s][0] = lastDirectionX = (lastDirectionX + (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9) / 2.0;
            this.precomputedSteps[s][1] = lastDirectionY = (lastDirectionY + (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9) / 2.0;
            this.precomputedSteps[s][2] = lastDirectionZ = (lastDirectionZ + (RANDOM_GENERATOR.nextDouble() - 0.5) * 0.9) / 2.0;
        }
    }

    protected int getSteps() {
        return 5;
    }

    public int getBrightnessForRender(float par1) {
        int j1 = 13;
        return 0xD000D0;
    }

    public void renderParticle(Tessellator tess, float l, float rX, float rY, float rZ, float rYZ, float rXY) {
        float j = 1.0f;
        tess.setColorRGBA_F(this.particleRed * 1.0f * 0.9f, this.particleGreen * 1.0f * 0.95f, this.particleBlue * 1.0f, this.particleAlpha);
        if (this.particleAge == 3) {
            this.regen();
        }
        double f6 = (double)this.particleTextureIndexX / 16.0;
        double f7 = f6 + (double)0.0324375f;
        double f8 = (double)this.particleTextureIndexY / 16.0;
        double f9 = f8 + (double)0.0324375f;
        f6 = f7;
        f8 = f9;
        double scale = 0.02;
        double[] a = new double[3];
        double[] b = new double[3];
        double ox = 0.0;
        double oy = 0.0;
        double oz = 0.0;
        EntityClientPlayerMP p = Minecraft.getMinecraft().thePlayer;
        double offX = -rZ;
        double offY = MathHelper.cos((float)((float)(1.5707963267948966 + (double)(p.rotationPitch * ((float)Math.PI / 180)))));
        double offZ = rX;
        for (int layer = 0; layer < 2; ++layer) {
            if (layer == 0) {
                scale = 0.04;
                offX *= 0.001;
                offY *= 0.001;
                offZ *= 0.001;
                tess.setColorRGBA_F(this.particleRed * 1.0f * 0.4f, this.particleGreen * 1.0f * 0.25f, this.particleBlue * 1.0f * 0.45f, this.particleAlpha);
            } else {
                offX = 0.0;
                offY = 0.0;
                offZ = 0.0;
                scale = 0.02;
                tess.setColorRGBA_F(this.particleRed * 1.0f * 0.9f, this.particleGreen * 1.0f * 0.65f, this.particleBlue * 1.0f * 0.85f, this.particleAlpha);
            }
            for (int cycle = 0; cycle < 3; ++cycle) {
                this.clear();
                double x = this.prevPosX + (this.posX - this.prevPosX) * (double)l - interpPosX - offX;
                double y = this.prevPosY + (this.posY - this.prevPosY) * (double)l - interpPosY - offY;
                double z = this.prevPosZ + (this.posZ - this.prevPosZ) * (double)l - interpPosZ - offZ;
                for (int s = 0; s < 5; ++s) {
                    double xN = x + this.precomputedSteps[s][0];
                    double yN = y + this.precomputedSteps[s][1];
                    double zN = z + this.precomputedSteps[s][2];
                    double xD = xN - x;
                    double yD = yN - y;
                    double zD = zN - z;
                    if (cycle == 0) {
                        ox = yD * 0.0 - 1.0 * zD;
                        oy = zD * 0.0 - 0.0 * xD;
                        oz = xD * 1.0 - 0.0 * yD;
                    }
                    if (cycle == 1) {
                        ox = yD * 1.0 - 0.0 * zD;
                        oy = zD * 0.0 - 1.0 * xD;
                        oz = xD * 0.0 - 0.0 * yD;
                    }
                    if (cycle == 2) {
                        ox = yD * 0.0 - 0.0 * zD;
                        oy = zD * 1.0 - 0.0 * xD;
                        oz = xD * 0.0 - 1.0 * yD;
                    }
                    double ss = Math.sqrt(ox * ox + oy * oy + oz * oz) / ((5.0 - (double)s) / 5.0 * scale);
                    a[0] = x + (ox /= ss);
                    a[1] = y + (oy /= ss);
                    a[2] = z + (oz /= ss);
                    b[0] = x;
                    b[1] = y;
                    b[2] = z;
                    this.draw(tess, a, b, f6, f8);
                    x = xN;
                    y = yN;
                    z = zN;
                }
            }
        }
    }

    private void clear() {
        this.hasData = false;
    }

    private void draw(Tessellator tess, double[] a, double[] b, double f6, double f8) {
        if (this.hasData) {
            tess.addVertexWithUV(a[0], a[1], a[2], f6, f8);
            tess.addVertexWithUV(this.vertices[0], this.vertices[1], this.vertices[2], f6, f8);
            tess.addVertexWithUV(this.verticesWithUV[0], this.verticesWithUV[1], this.verticesWithUV[2], f6, f8);
            tess.addVertexWithUV(b[0], b[1], b[2], f6, f8);
        }
        this.hasData = true;
        for (int x = 0; x < 3; ++x) {
            this.vertices[x] = a[x];
            this.verticesWithUV[x] = b[x];
        }
    }

    protected double[][] getPrecomputedSteps() {
        return this.precomputedSteps;
    }
}

