/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.core.AELog;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;

@SideOnly(value=Side.CLIENT)
public final class WorldRender
implements ISimpleBlockRenderingHandler {
    public static final WorldRender INSTANCE = new WorldRender();
    private final Map<AEBaseBlock, BaseBlockRender> blockRenders = new HashMap<AEBaseBlock, BaseBlockRender>();
    private final int renderID = RenderingRegistry.getNextAvailableRenderId();
    private final RenderBlocks renderer = new RenderBlocks();
    private boolean hasError = false;

    private WorldRender() {
    }

    void setRender(AEBaseBlock in, BaseBlockRender r) {
        this.blockRenders.put(in, r);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        AEBaseBlock blk = (AEBaseBlock)block;
        renderer.setRenderBoundsFromBlock(block);
        return this.getRender(blk).renderInWorld(blk, world, x, y, z, renderer);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.renderID;
    }

    private BaseBlockRender getRender(AEBaseBlock block) {
        return block.getRendererInstance().getRendererInstance();
    }

    void renderItemBlock(ItemStack item, IItemRenderer.ItemRenderType type, Object[] data) {
        Block blk = Block.getBlockFromItem((Item)item.getItem());
        if (blk instanceof AEBaseBlock) {
            AEBaseBlock block = (AEBaseBlock)blk;
            this.renderer.setRenderBoundsFromBlock((Block)block);
            this.renderer.uvRotateWest = 0;
            this.renderer.uvRotateTop = 0;
            this.renderer.uvRotateSouth = 0;
            this.renderer.uvRotateNorth = 0;
            this.renderer.uvRotateEast = 0;
            this.renderer.uvRotateBottom = 0;
            this.getRender(block).renderInventory(block, item, this.renderer, type, data);
            this.renderer.uvRotateWest = 0;
            this.renderer.uvRotateTop = 0;
            this.renderer.uvRotateSouth = 0;
            this.renderer.uvRotateNorth = 0;
            this.renderer.uvRotateEast = 0;
            this.renderer.uvRotateBottom = 0;
        } else if (!this.hasError) {
            this.hasError = true;
            AELog.error("Invalid render - item/block mismatch", new Object[0]);
            AELog.error("\t\titem: " + item.getUnlocalizedName(), new Object[0]);
            AELog.error("\t\tblock: " + blk.getUnlocalizedName(), new Object[0]);
        }
    }
}

