/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.api.util.IOrientable;
import appeng.block.AEBaseBlock;
import appeng.client.render.BlockRenderInfo;
import appeng.client.texture.ExtraBlockTextures;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.FloatBuffer;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BaseBlockRender<B extends AEBaseBlock, T extends AEBaseTile> {
    private static final int ORIENTATION_BITS = 7;
    private static final int FLIP_H_BIT = 8;
    private static final int FLIP_V_BIT = 16;
    private static final byte[][][] ORIENTATION_MAP = new byte[6][6][6];
    private final boolean hasTESR;
    private final double renderDistance;
    private final FloatBuffer rotMat = BufferUtils.createFloatBuffer((int)16);

    public BaseBlockRender() {
        this(false, 20.0);
    }

    public BaseBlockRender(boolean enableTESR, double renderDistance) {
        this.hasTESR = enableTESR;
        this.renderDistance = renderDistance;
        BaseBlockRender.setOriMap();
    }

    private static void setOriMap() {
        BaseBlockRender.ORIENTATION_MAP[0][3][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[1][3][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[2][3][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[3][3][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[4][3][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[5][3][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[0][5][1] = 1;
        BaseBlockRender.ORIENTATION_MAP[1][5][1] = 2;
        BaseBlockRender.ORIENTATION_MAP[2][5][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[3][5][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[4][5][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[5][5][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[0][2][1] = 3;
        BaseBlockRender.ORIENTATION_MAP[1][2][1] = 3;
        BaseBlockRender.ORIENTATION_MAP[2][2][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[3][2][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[4][2][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[5][2][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[0][4][1] = 2;
        BaseBlockRender.ORIENTATION_MAP[1][4][1] = 1;
        BaseBlockRender.ORIENTATION_MAP[2][4][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[3][4][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[4][4][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[5][4][1] = 0;
        BaseBlockRender.ORIENTATION_MAP[0][3][0] = 8;
        BaseBlockRender.ORIENTATION_MAP[1][3][0] = 8;
        BaseBlockRender.ORIENTATION_MAP[2][3][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[3][3][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[4][3][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[5][3][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[0][4][0] = 10;
        BaseBlockRender.ORIENTATION_MAP[1][4][0] = 9;
        BaseBlockRender.ORIENTATION_MAP[2][4][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[3][4][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[4][4][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[5][4][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[0][5][0] = 9;
        BaseBlockRender.ORIENTATION_MAP[1][5][0] = 10;
        BaseBlockRender.ORIENTATION_MAP[2][5][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[3][5][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[4][5][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[5][5][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[0][2][0] = 11;
        BaseBlockRender.ORIENTATION_MAP[1][2][0] = 11;
        BaseBlockRender.ORIENTATION_MAP[2][2][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[3][2][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[4][2][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[5][2][0] = 3;
        BaseBlockRender.ORIENTATION_MAP[0][3][5] = 17;
        BaseBlockRender.ORIENTATION_MAP[1][3][5] = 9;
        BaseBlockRender.ORIENTATION_MAP[2][3][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[3][3][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[4][3][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[5][3][5] = 17;
        BaseBlockRender.ORIENTATION_MAP[0][1][5] = 9;
        BaseBlockRender.ORIENTATION_MAP[1][1][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[2][1][5] = 19;
        BaseBlockRender.ORIENTATION_MAP[3][1][5] = 3;
        BaseBlockRender.ORIENTATION_MAP[4][1][5] = 17;
        BaseBlockRender.ORIENTATION_MAP[5][1][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[0][2][5] = 9;
        BaseBlockRender.ORIENTATION_MAP[1][2][5] = 9;
        BaseBlockRender.ORIENTATION_MAP[2][2][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[3][2][5] = 18;
        BaseBlockRender.ORIENTATION_MAP[4][2][5] = 17;
        BaseBlockRender.ORIENTATION_MAP[5][2][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[0][0][5] = 9;
        BaseBlockRender.ORIENTATION_MAP[1][0][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[2][0][5] = 0;
        BaseBlockRender.ORIENTATION_MAP[3][0][5] = 16;
        BaseBlockRender.ORIENTATION_MAP[4][0][5] = 1;
        BaseBlockRender.ORIENTATION_MAP[5][0][5] = 17;
        BaseBlockRender.ORIENTATION_MAP[0][1][2] = 8;
        BaseBlockRender.ORIENTATION_MAP[1][1][2] = 0;
        BaseBlockRender.ORIENTATION_MAP[2][1][2] = 10;
        BaseBlockRender.ORIENTATION_MAP[3][1][2] = 1;
        BaseBlockRender.ORIENTATION_MAP[4][1][2] = 3;
        BaseBlockRender.ORIENTATION_MAP[5][1][2] = 11;
        BaseBlockRender.ORIENTATION_MAP[0][4][2] = 8;
        BaseBlockRender.ORIENTATION_MAP[1][4][2] = 8;
        BaseBlockRender.ORIENTATION_MAP[2][4][2] = 10;
        BaseBlockRender.ORIENTATION_MAP[3][4][2] = 1;
        BaseBlockRender.ORIENTATION_MAP[4][4][2] = 9;
        BaseBlockRender.ORIENTATION_MAP[5][4][2] = 2;
        BaseBlockRender.ORIENTATION_MAP[0][0][2] = 16;
        BaseBlockRender.ORIENTATION_MAP[1][0][2] = 0;
        BaseBlockRender.ORIENTATION_MAP[2][0][2] = 2;
        BaseBlockRender.ORIENTATION_MAP[3][0][2] = 9;
        BaseBlockRender.ORIENTATION_MAP[4][0][2] = 11;
        BaseBlockRender.ORIENTATION_MAP[5][0][2] = 0;
        BaseBlockRender.ORIENTATION_MAP[0][5][2] = 8;
        BaseBlockRender.ORIENTATION_MAP[1][5][2] = 8;
        BaseBlockRender.ORIENTATION_MAP[2][5][2] = 2;
        BaseBlockRender.ORIENTATION_MAP[3][5][2] = 9;
        BaseBlockRender.ORIENTATION_MAP[4][5][2] = 2;
        BaseBlockRender.ORIENTATION_MAP[5][5][2] = 9;
        BaseBlockRender.ORIENTATION_MAP[0][0][3] = 11;
        BaseBlockRender.ORIENTATION_MAP[1][0][3] = 3;
        BaseBlockRender.ORIENTATION_MAP[2][0][3] = 1;
        BaseBlockRender.ORIENTATION_MAP[3][0][3] = 10;
        BaseBlockRender.ORIENTATION_MAP[4][0][3] = 0;
        BaseBlockRender.ORIENTATION_MAP[5][0][3] = 8;
        BaseBlockRender.ORIENTATION_MAP[0][4][3] = 3;
        BaseBlockRender.ORIENTATION_MAP[1][4][3] = 3;
        BaseBlockRender.ORIENTATION_MAP[2][4][3] = 9;
        BaseBlockRender.ORIENTATION_MAP[3][4][3] = 2;
        BaseBlockRender.ORIENTATION_MAP[4][4][3] = 1;
        BaseBlockRender.ORIENTATION_MAP[5][4][3] = 10;
        BaseBlockRender.ORIENTATION_MAP[0][1][3] = 19;
        BaseBlockRender.ORIENTATION_MAP[1][1][3] = 3;
        BaseBlockRender.ORIENTATION_MAP[2][1][3] = 9;
        BaseBlockRender.ORIENTATION_MAP[3][1][3] = 2;
        BaseBlockRender.ORIENTATION_MAP[4][1][3] = 11;
        BaseBlockRender.ORIENTATION_MAP[5][1][3] = 0;
        BaseBlockRender.ORIENTATION_MAP[0][5][3] = 3;
        BaseBlockRender.ORIENTATION_MAP[1][5][3] = 3;
        BaseBlockRender.ORIENTATION_MAP[2][5][3] = 1;
        BaseBlockRender.ORIENTATION_MAP[3][5][3] = 10;
        BaseBlockRender.ORIENTATION_MAP[4][5][3] = 10;
        BaseBlockRender.ORIENTATION_MAP[5][5][3] = 1;
        BaseBlockRender.ORIENTATION_MAP[0][3][4] = 1;
        BaseBlockRender.ORIENTATION_MAP[1][3][4] = 2;
        BaseBlockRender.ORIENTATION_MAP[2][3][4] = 10;
        BaseBlockRender.ORIENTATION_MAP[3][3][4] = 1;
        BaseBlockRender.ORIENTATION_MAP[4][3][4] = 10;
        BaseBlockRender.ORIENTATION_MAP[5][3][4] = 1;
        BaseBlockRender.ORIENTATION_MAP[0][0][4] = 9;
        BaseBlockRender.ORIENTATION_MAP[1][0][4] = 2;
        BaseBlockRender.ORIENTATION_MAP[2][0][4] = 0;
        BaseBlockRender.ORIENTATION_MAP[3][0][4] = 8;
        BaseBlockRender.ORIENTATION_MAP[4][0][4] = 10;
        BaseBlockRender.ORIENTATION_MAP[5][0][4] = 1;
        BaseBlockRender.ORIENTATION_MAP[0][1][4] = 9;
        BaseBlockRender.ORIENTATION_MAP[1][1][4] = 2;
        BaseBlockRender.ORIENTATION_MAP[2][1][4] = 11;
        BaseBlockRender.ORIENTATION_MAP[3][1][4] = 3;
        BaseBlockRender.ORIENTATION_MAP[4][1][4] = 2;
        BaseBlockRender.ORIENTATION_MAP[5][1][4] = 9;
        BaseBlockRender.ORIENTATION_MAP[0][2][4] = 1;
        BaseBlockRender.ORIENTATION_MAP[1][2][4] = 2;
        BaseBlockRender.ORIENTATION_MAP[2][2][4] = 1;
        BaseBlockRender.ORIENTATION_MAP[3][2][4] = 10;
        BaseBlockRender.ORIENTATION_MAP[4][2][4] = 2;
        BaseBlockRender.ORIENTATION_MAP[5][2][4] = 9;
    }

    public boolean hasTESR() {
        return this.hasTESR;
    }

    protected int adjustBrightness(int v, double d) {
        int r = 0xFF & v >> 16;
        int g = 0xFF & v >> 8;
        int b = 0xFF & v;
        r = (int)((double)r * d);
        g = (int)((double)g * d);
        b = (int)((double)b * d);
        r = Math.min(255, Math.max(0, r));
        g = Math.min(255, Math.max(0, g));
        b = Math.min(255, Math.max(0, b));
        return r << 16 | g << 8 | b;
    }

    double getTesrRenderDistance() {
        return this.renderDistance;
    }

    public void renderInventory(B block, ItemStack item, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] data) {
        Tessellator tess = Tessellator.instance;
        BlockRenderInfo info = ((AEBaseBlock)block).getRendererInstance();
        if (info.isValid()) {
            if (((AEBaseBlock)block).hasSubtypes()) {
                ((AEBaseBlock)block).setRenderStateByMeta(item.getItemDamage());
            }
            renderer.uvRotateBottom = info.getTexture(ForgeDirection.DOWN).setFlip(BaseBlockRender.getOrientation(ForgeDirection.DOWN, ForgeDirection.SOUTH, ForgeDirection.UP));
            renderer.uvRotateTop = info.getTexture(ForgeDirection.UP).setFlip(BaseBlockRender.getOrientation(ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.UP));
            renderer.uvRotateEast = info.getTexture(ForgeDirection.EAST).setFlip(BaseBlockRender.getOrientation(ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.UP));
            renderer.uvRotateWest = info.getTexture(ForgeDirection.WEST).setFlip(BaseBlockRender.getOrientation(ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.UP));
            renderer.uvRotateNorth = info.getTexture(ForgeDirection.NORTH).setFlip(BaseBlockRender.getOrientation(ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.UP));
            renderer.uvRotateSouth = info.getTexture(ForgeDirection.SOUTH).setFlip(BaseBlockRender.getOrientation(ForgeDirection.SOUTH, ForgeDirection.SOUTH, ForgeDirection.UP));
        }
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), block, item, tess, 0xFFFFFF, renderer);
        if (((AEBaseBlock)block).hasSubtypes()) {
            info.setTemporaryRenderIcon(null);
        }
        renderer.uvRotateWest = 0;
        renderer.uvRotateTop = 0;
        renderer.uvRotateSouth = 0;
        renderer.uvRotateNorth = 0;
        renderer.uvRotateEast = 0;
        renderer.uvRotateBottom = 0;
    }

    static int getOrientation(ForgeDirection in, ForgeDirection forward, ForgeDirection up) {
        if (in == null || in == ForgeDirection.UNKNOWN || forward == null || forward == ForgeDirection.UNKNOWN || up == null || up == ForgeDirection.UNKNOWN) {
            return 0;
        }
        int a = in.ordinal();
        int b = forward.ordinal();
        int c = up.ordinal();
        return ORIENTATION_MAP[a][b][c];
    }

    public void renderInvBlock(EnumSet<ForgeDirection> sides, B block, ItemStack item, Tessellator tess, int color, RenderBlocks renderer) {
        if (block == null) {
            return;
        }
        int meta = 0;
        if (((AEBaseBlock)block).hasSubtypes() && item != null) {
            meta = item.getItemDamage();
        }
        if (sides.contains(ForgeDirection.DOWN)) {
            tess.startDrawingQuads();
            tess.setNormal(0.0f, -1.0f, 0.0f);
            tess.setColorOpaque_I(color);
            renderer.renderFaceYNeg(block, 0.0, 0.0, 0.0, this.firstNotNull(renderer.overrideBlockTexture, ((AEBaseBlock)block).getRendererInstance().getTexture(ForgeDirection.DOWN), ((AEBaseBlock)block).getIcon(ForgeDirection.DOWN.ordinal(), meta)));
            tess.draw();
        }
        if (sides.contains(ForgeDirection.UP)) {
            tess.startDrawingQuads();
            tess.setNormal(0.0f, 1.0f, 0.0f);
            tess.setColorOpaque_I(color);
            renderer.renderFaceYPos(block, 0.0, 0.0, 0.0, this.firstNotNull(renderer.overrideBlockTexture, ((AEBaseBlock)block).getRendererInstance().getTexture(ForgeDirection.UP), ((AEBaseBlock)block).getIcon(ForgeDirection.UP.ordinal(), meta)));
            tess.draw();
        }
        if (sides.contains(ForgeDirection.NORTH)) {
            tess.startDrawingQuads();
            tess.setNormal(0.0f, 0.0f, -1.0f);
            tess.setColorOpaque_I(color);
            renderer.renderFaceZNeg(block, 0.0, 0.0, 0.0, this.firstNotNull(renderer.overrideBlockTexture, ((AEBaseBlock)block).getRendererInstance().getTexture(ForgeDirection.NORTH), ((AEBaseBlock)block).getIcon(ForgeDirection.NORTH.ordinal(), meta)));
            tess.draw();
        }
        if (sides.contains(ForgeDirection.SOUTH)) {
            tess.startDrawingQuads();
            tess.setNormal(0.0f, 0.0f, 1.0f);
            tess.setColorOpaque_I(color);
            renderer.renderFaceZPos(block, 0.0, 0.0, 0.0, this.firstNotNull(renderer.overrideBlockTexture, ((AEBaseBlock)block).getRendererInstance().getTexture(ForgeDirection.SOUTH), ((AEBaseBlock)block).getIcon(ForgeDirection.SOUTH.ordinal(), meta)));
            tess.draw();
        }
        if (sides.contains(ForgeDirection.WEST)) {
            tess.startDrawingQuads();
            tess.setNormal(-1.0f, 0.0f, 0.0f);
            tess.setColorOpaque_I(color);
            renderer.renderFaceXNeg(block, 0.0, 0.0, 0.0, this.firstNotNull(renderer.overrideBlockTexture, ((AEBaseBlock)block).getRendererInstance().getTexture(ForgeDirection.WEST), ((AEBaseBlock)block).getIcon(ForgeDirection.WEST.ordinal(), meta)));
            tess.draw();
        }
        if (sides.contains(ForgeDirection.EAST)) {
            tess.startDrawingQuads();
            tess.setNormal(1.0f, 0.0f, 0.0f);
            tess.setColorOpaque_I(color);
            renderer.renderFaceXPos(block, 0.0, 0.0, 0.0, this.firstNotNull(renderer.overrideBlockTexture, ((AEBaseBlock)block).getRendererInstance().getTexture(ForgeDirection.EAST), ((AEBaseBlock)block).getIcon(ForgeDirection.EAST.ordinal(), meta)));
            tess.draw();
        }
    }

    private IIcon firstNotNull(IIcon ... s) {
        for (IIcon o : s) {
            if (o == null) continue;
            return o;
        }
        return ExtraBlockTextures.getMissing();
    }

    public boolean renderInWorld(B block, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        this.preRenderInWorld(block, world, x, y, z, renderer);
        boolean o = renderer.renderStandardBlock(block, x, y, z);
        this.postRenderInWorld(renderer);
        return o;
    }

    public void preRenderInWorld(B block, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        BlockRenderInfo info = ((AEBaseBlock)block).getRendererInstance();
        IOrientable te = this.getOrientable(block, world, x, y, z);
        if (te != null) {
            ForgeDirection forward = te.getForward();
            ForgeDirection up = te.getUp();
            renderer.uvRotateBottom = info.getTexture(ForgeDirection.DOWN).setFlip(BaseBlockRender.getOrientation(ForgeDirection.DOWN, forward, up));
            renderer.uvRotateTop = info.getTexture(ForgeDirection.UP).setFlip(BaseBlockRender.getOrientation(ForgeDirection.UP, forward, up));
            renderer.uvRotateEast = info.getTexture(ForgeDirection.EAST).setFlip(BaseBlockRender.getOrientation(ForgeDirection.EAST, forward, up));
            renderer.uvRotateWest = info.getTexture(ForgeDirection.WEST).setFlip(BaseBlockRender.getOrientation(ForgeDirection.WEST, forward, up));
            renderer.uvRotateNorth = info.getTexture(ForgeDirection.NORTH).setFlip(BaseBlockRender.getOrientation(ForgeDirection.NORTH, forward, up));
            renderer.uvRotateSouth = info.getTexture(ForgeDirection.SOUTH).setFlip(BaseBlockRender.getOrientation(ForgeDirection.SOUTH, forward, up));
        }
    }

    public void postRenderInWorld(RenderBlocks renderer) {
        renderer.uvRotateWest = 0;
        renderer.uvRotateTop = 0;
        renderer.uvRotateSouth = 0;
        renderer.uvRotateNorth = 0;
        renderer.uvRotateEast = 0;
        renderer.uvRotateBottom = 0;
    }

    @Nullable
    public IOrientable getOrientable(B block, IBlockAccess w, int x, int y, int z) {
        return ((AEBaseBlock)block).getOrientable(w, x, y, z);
    }

    protected void setInvRenderBounds(RenderBlocks renderer, int i, int j, int k, int l, int m, int n) {
        renderer.setRenderBounds((double)i / 16.0, (double)j / 16.0, (double)k / 16.0, (double)l / 16.0, (double)m / 16.0, (double)n / 16.0);
    }

    protected void renderBlockBounds(RenderBlocks renderer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, ForgeDirection x, ForgeDirection y, ForgeDirection z) {
        double aX = (minX /= 16.0) * (double)x.offsetX + (minY /= 16.0) * (double)y.offsetX + (minZ /= 16.0) * (double)z.offsetX;
        double aY = minX * (double)x.offsetY + minY * (double)y.offsetY + minZ * (double)z.offsetY;
        double aZ = minX * (double)x.offsetZ + minY * (double)y.offsetZ + minZ * (double)z.offsetZ;
        double bX = (maxX /= 16.0) * (double)x.offsetX + (maxY /= 16.0) * (double)y.offsetX + (maxZ /= 16.0) * (double)z.offsetX;
        double bY = maxX * (double)x.offsetY + maxY * (double)y.offsetY + maxZ * (double)z.offsetY;
        double bZ = maxX * (double)x.offsetZ + maxY * (double)y.offsetZ + maxZ * (double)z.offsetZ;
        if (x.offsetX + y.offsetX + z.offsetX < 0) {
            aX += 1.0;
            bX += 1.0;
        }
        if (x.offsetY + y.offsetY + z.offsetY < 0) {
            aY += 1.0;
            bY += 1.0;
        }
        if (x.offsetZ + y.offsetZ + z.offsetZ < 0) {
            aZ += 1.0;
            bZ += 1.0;
        }
        renderer.renderMinX = Math.min(aX, bX);
        renderer.renderMinY = Math.min(aY, bY);
        renderer.renderMinZ = Math.min(aZ, bZ);
        renderer.renderMaxX = Math.max(aX, bX);
        renderer.renderMaxY = Math.max(aY, bY);
        renderer.renderMaxZ = Math.max(aZ, bZ);
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderCutoutFace(B block, IIcon ico, int x, int y, int z, RenderBlocks renderer, ForgeDirection orientation, float edgeThickness) {
        Tessellator tess = Tessellator.instance;
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        double layerAX = 0.0;
        double layerAZ = 0.0;
        double layerBY = 0.0;
        double layerBZ = 0.0;
        boolean flip = false;
        switch (orientation) {
            case NORTH: {
                layerAX = 1.0;
                layerBY = 1.0;
                flip = true;
                break;
            }
            case SOUTH: {
                layerAX = 1.0;
                layerBY = 1.0;
                offsetZ = 1.0;
                break;
            }
            case EAST: {
                flip = true;
                layerAZ = 1.0;
                layerBY = 1.0;
                offsetX = 1.0;
                break;
            }
            case WEST: {
                layerAZ = 1.0;
                layerBY = 1.0;
                break;
            }
            case UP: {
                flip = true;
                layerAX = 1.0;
                layerBZ = 1.0;
                offsetY = 1.0;
                break;
            }
            case DOWN: {
                layerAX = 1.0;
                layerBZ = 1.0;
                break;
            }
        }
        double layerBX = 0.0;
        double layerAY = 0.0;
        this.renderFace(tess, offsetX += (double)x, offsetY += (double)y, offsetZ += (double)z, layerAX, 0.0, layerAZ, 0.0, layerBY, layerBZ, 0.0, 1.0, 0.0, edgeThickness, ico, flip);
        this.renderFace(tess, offsetX, offsetY, offsetZ, layerAX, 0.0, layerAZ, 0.0, layerBY, layerBZ, 0.0, edgeThickness, edgeThickness, 1.0 - (double)edgeThickness, ico, flip);
        this.renderFace(tess, offsetX, offsetY, offsetZ, layerAX, 0.0, layerAZ, 0.0, layerBY, layerBZ, 1.0 - (double)edgeThickness, 1.0, edgeThickness, 1.0 - (double)edgeThickness, ico, flip);
        this.renderFace(tess, offsetX, offsetY, offsetZ, layerAX, 0.0, layerAZ, 0.0, layerBY, layerBZ, 0.0, 1.0, 1.0 - (double)edgeThickness, 1.0, ico, flip);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderFace(Tessellator tess, double offsetX, double offsetY, double offsetZ, double ax, double ay, double az, double bx, double by, double bz, double ua, double ub, double va, double vb, IIcon ico, boolean flip) {
        if (flip) {
            tess.addVertexWithUV(offsetX + ax * ua + bx * va, offsetY + ay * ua + by * va, offsetZ + az * ua + bz * va, (double)ico.getInterpolatedU(ua * 16.0), (double)ico.getInterpolatedV(va * 16.0));
            tess.addVertexWithUV(offsetX + ax * ua + bx * vb, offsetY + ay * ua + by * vb, offsetZ + az * ua + bz * vb, (double)ico.getInterpolatedU(ua * 16.0), (double)ico.getInterpolatedV(vb * 16.0));
            tess.addVertexWithUV(offsetX + ax * ub + bx * vb, offsetY + ay * ub + by * vb, offsetZ + az * ub + bz * vb, (double)ico.getInterpolatedU(ub * 16.0), (double)ico.getInterpolatedV(vb * 16.0));
            tess.addVertexWithUV(offsetX + ax * ub + bx * va, offsetY + ay * ub + by * va, offsetZ + az * ub + bz * va, (double)ico.getInterpolatedU(ub * 16.0), (double)ico.getInterpolatedV(va * 16.0));
        } else {
            tess.addVertexWithUV(offsetX + ax * ua + bx * va, offsetY + ay * ua + by * va, offsetZ + az * ua + bz * va, (double)ico.getInterpolatedU(ua * 16.0), (double)ico.getInterpolatedV(va * 16.0));
            tess.addVertexWithUV(offsetX + ax * ub + bx * va, offsetY + ay * ub + by * va, offsetZ + az * ub + bz * va, (double)ico.getInterpolatedU(ub * 16.0), (double)ico.getInterpolatedV(va * 16.0));
            tess.addVertexWithUV(offsetX + ax * ub + bx * vb, offsetY + ay * ub + by * vb, offsetZ + az * ub + bz * vb, (double)ico.getInterpolatedU(ub * 16.0), (double)ico.getInterpolatedV(vb * 16.0));
            tess.addVertexWithUV(offsetX + ax * ua + bx * vb, offsetY + ay * ua + by * vb, offsetZ + az * ua + bz * vb, (double)ico.getInterpolatedU(ua * 16.0), (double)ico.getInterpolatedV(vb * 16.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderFace(int x, int y, int z, B block, IIcon ico, RenderBlocks renderer, ForgeDirection orientation) {
        switch (orientation) {
            case NORTH: {
                renderer.renderFaceZNeg(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case SOUTH: {
                renderer.renderFaceZPos(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case EAST: {
                renderer.renderFaceXPos(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case WEST: {
                renderer.renderFaceXNeg(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case UP: {
                renderer.renderFaceYPos(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case DOWN: {
                renderer.renderFaceYNeg(block, (double)x, (double)y, (double)z, ico);
                break;
            }
        }
    }

    public void selectFace(RenderBlocks renderer, ForgeDirection west, ForgeDirection up, ForgeDirection forward, int u1, int u2, int v1, int v2) {
        v1 = 16 - v1;
        v2 = 16 - v2;
        double minX = (double)(forward.offsetX > 0 ? 1 : 0) + this.mapFaceUV(west.offsetX, u1) + this.mapFaceUV(up.offsetX, v1);
        double minY = (double)(forward.offsetY > 0 ? 1 : 0) + this.mapFaceUV(west.offsetY, u1) + this.mapFaceUV(up.offsetY, v1);
        double minZ = (double)(forward.offsetZ > 0 ? 1 : 0) + this.mapFaceUV(west.offsetZ, u1) + this.mapFaceUV(up.offsetZ, v1);
        double maxX = (double)(forward.offsetX > 0 ? 1 : 0) + this.mapFaceUV(west.offsetX, u2) + this.mapFaceUV(up.offsetX, v2);
        double maxY = (double)(forward.offsetY > 0 ? 1 : 0) + this.mapFaceUV(west.offsetY, u2) + this.mapFaceUV(up.offsetY, v2);
        double maxZ = (double)(forward.offsetZ > 0 ? 1 : 0) + this.mapFaceUV(west.offsetZ, u2) + this.mapFaceUV(up.offsetZ, v2);
        renderer.renderMinX = Math.max(0.0, Math.min(minX, maxX) - (forward.offsetX != 0 ? 0.0 : 0.001));
        renderer.renderMaxX = Math.min(1.0, Math.max(minX, maxX) + (forward.offsetX != 0 ? 0.0 : 0.001));
        renderer.renderMinY = Math.max(0.0, Math.min(minY, maxY) - (forward.offsetY != 0 ? 0.0 : 0.001));
        renderer.renderMaxY = Math.min(1.0, Math.max(minY, maxY) + (forward.offsetY != 0 ? 0.0 : 0.001));
        renderer.renderMinZ = Math.max(0.0, Math.min(minZ, maxZ) - (forward.offsetZ != 0 ? 0.0 : 0.001));
        renderer.renderMaxZ = Math.min(1.0, Math.max(minZ, maxZ) + (forward.offsetZ != 0 ? 0.0 : 0.001));
    }

    private double mapFaceUV(int offset, int uv) {
        if (offset == 0) {
            return 0.0;
        }
        if (offset > 0) {
            return (double)uv / 16.0;
        }
        return (16.0 - (double)uv) / 16.0;
    }

    public void renderTile(B block, T tile, Tessellator tess, double x, double y, double z, float f, RenderBlocks renderer) {
        renderer.uvRotateSouth = 0;
        renderer.uvRotateNorth = 0;
        renderer.uvRotateWest = 0;
        renderer.uvRotateEast = 0;
        renderer.uvRotateTop = 0;
        renderer.uvRotateBottom = 0;
        ForgeDirection up = ForgeDirection.UP;
        ForgeDirection forward = ForgeDirection.SOUTH;
        this.applyTESRRotation(x, y, z, forward, up);
        Minecraft.getMinecraft().getTextureManager().bindTexture(TextureMap.locationBlocksTexture);
        RenderHelper.disableStandardItemLighting();
        if (Minecraft.isAmbientOcclusionEnabled()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tess.setTranslation((double)(-((AEBaseTile)tile).xCoord), (double)(-((AEBaseTile)tile).yCoord), (double)(-((AEBaseTile)tile).zCoord));
        tess.startDrawingQuads();
        renderer.setRenderBoundsFromBlock(block);
        renderer.renderStandardBlock(block, ((AEBaseTile)tile).xCoord, ((AEBaseTile)tile).yCoord, ((AEBaseTile)tile).zCoord);
        tess.draw();
        tess.setTranslation(0.0, 0.0, 0.0);
        RenderHelper.enableStandardItemLighting();
        renderer.uvRotateSouth = 0;
        renderer.uvRotateNorth = 0;
        renderer.uvRotateWest = 0;
        renderer.uvRotateEast = 0;
        renderer.uvRotateTop = 0;
        renderer.uvRotateBottom = 0;
    }

    protected void applyTESRRotation(double x, double y, double z, ForgeDirection forward, ForgeDirection up) {
        if (forward != null && up != null) {
            if (forward == ForgeDirection.UNKNOWN) {
                forward = ForgeDirection.SOUTH;
            }
            if (up == ForgeDirection.UNKNOWN) {
                up = ForgeDirection.UP;
            }
            ForgeDirection west = Platform.crossProduct(forward, up);
            this.rotMat.put(0, west.offsetX);
            this.rotMat.put(1, west.offsetY);
            this.rotMat.put(2, west.offsetZ);
            this.rotMat.put(3, 0.0f);
            this.rotMat.put(4, up.offsetX);
            this.rotMat.put(5, up.offsetY);
            this.rotMat.put(6, up.offsetZ);
            this.rotMat.put(7, 0.0f);
            this.rotMat.put(8, forward.offsetX);
            this.rotMat.put(9, forward.offsetY);
            this.rotMat.put(10, forward.offsetZ);
            this.rotMat.put(11, 0.0f);
            this.rotMat.put(12, 0.0f);
            this.rotMat.put(13, 0.0f);
            this.rotMat.put(14, 0.0f);
            this.rotMat.put(15, 1.0f);
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GL11.glMultMatrix((FloatBuffer)this.rotMat);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        } else {
            GL11.glTranslated((double)x, (double)y, (double)z);
        }
    }

    public void doRenderItem(ItemStack itemstack, TileEntity par1EntityItemFrame) {
        if (itemstack != null) {
            EntityItem entityitem = new EntityItem(par1EntityItemFrame.getWorldObj(), 0.0, 0.0, 0.0, itemstack);
            entityitem.getEntityItem().stackSize = 1;
            entityitem.hoverStart = 0.0f;
            entityitem.age = 0;
            entityitem.rotationYaw = 0.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)-0.14f, (float)0.0f);
            RenderItem.renderInFrame = true;
            RenderManager.instance.renderEntityWithPosYaw((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            RenderItem.renderInFrame = false;
            GL11.glPopMatrix();
        }
    }
}

