/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.util.IConfigManager;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotRestrictedInput;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotNormal;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.util.Platform;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ContainerInterface
extends ContainerUpgradeable
implements IOptionalSlotHost {
    private final DualityInterface myDuality;
    @GuiSync(value=3)
    public YesNo bMode = YesNo.NO;
    @GuiSync(value=4)
    public YesNo iTermMode = YesNo.YES;
    @GuiSync(value=7)
    public int patternRows;

    public ContainerInterface(InventoryPlayer ip, IInterfaceHost te) {
        super(ip, te.getInterfaceDuality().getHost());
        int x;
        this.myDuality = te.getInterfaceDuality();
        this.patternRows = this.getPatternCapacityCardsInstalled();
        for (int row = 0; row < 4; ++row) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new OptionalSlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, this.myDuality.getPatterns(), this, x2 + row * 9, 8 + 18 * x2, 108 - row * 18, row, this.getInventoryPlayer()));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new SlotFake(this.myDuality.getConfig(), x, 8 + 18 * x, 15));
        }
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new SlotNormal(this.myDuality.getStorage(), x, 8 + 18 * x, 33));
        }
    }

    @Override
    protected int getHeight() {
        return 211;
    }

    @Override
    protected void setupConfig() {
        this.setupUpgrades();
    }

    @Override
    public int availableUpgrades() {
        return 4;
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (Platform.isClient() && field.equals("patternRows")) {
            this.getRemovedPatterns();
        }
    }

    @Override
    public void func_75142_b() {
        TileEntity te;
        ArrayList<ItemStack> drops;
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.patternRows != this.getPatternCapacityCardsInstalled()) {
            this.patternRows = this.getPatternCapacityCardsInstalled();
        }
        if (!(drops = this.getRemovedPatterns()).isEmpty() && (te = this.myDuality.getHost().getTile()) != null) {
            Platform.spawnDrops(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e, drops);
        }
        super.func_75142_b();
    }

    private ArrayList<ItemStack> getRemovedPatterns() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (Object o : this.field_75151_b) {
            ItemStack s;
            OptionalSlotRestrictedInput fs;
            if (!(o instanceof OptionalSlotRestrictedInput) || (fs = (OptionalSlotRestrictedInput)((Object)o)).isEnabled() || (s = fs.field_75224_c.func_70301_a(fs.getSlotIndex())) == null) continue;
            drops.add(s);
            fs.field_75224_c.func_70299_a(fs.getSlotIndex(), null);
            fs.clearStack();
        }
        return drops;
    }

    @Override
    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setBlockingMode((YesNo)cm.getSetting(Settings.BLOCK));
        this.setInterfaceTerminalMode((YesNo)cm.getSetting(Settings.INTERFACE_TERMINAL));
    }

    public YesNo getBlockingMode() {
        return this.bMode;
    }

    private void setBlockingMode(YesNo bMode) {
        this.bMode = bMode;
    }

    public YesNo getInterfaceTerminalMode() {
        return this.iTermMode;
    }

    private void setInterfaceTerminalMode(YesNo iTermMode) {
        this.iTermMode = iTermMode;
    }

    public int getPatternCapacityCardsInstalled() {
        if (this.myDuality == null) {
            return 0;
        }
        return this.myDuality.getInstalledUpgrades(Upgrades.PATTERN_CAPACITY);
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        return this.myDuality.getInstalledUpgrades(Upgrades.PATTERN_CAPACITY) >= idx;
    }
}

