/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.powersink;

import appeng.api.config.PowerUnits;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IIC2;
import appeng.tile.powersink.GTPowerSink;
import appeng.transformer.annotations.Integration;
import appeng.util.Platform;
import ic2.api.energy.tile.IEnergySink;
import java.util.EnumSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@Integration.Interface(iname=IntegrationType.IC2, iface="ic2.api.energy.tile.IEnergySink")
public abstract class IC2
extends GTPowerSink
implements IEnergySink {
    private boolean isInIC2 = false;

    public final boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.getPowerSides().contains(direction);
    }

    public final double getDemandedEnergy() {
        return this.getExternalPowerDemand(PowerUnits.EU, Double.MAX_VALUE);
    }

    public final int getSinkTier() {
        return Integer.MAX_VALUE;
    }

    public final double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        double overflow = PowerUnits.EU.convertTo(PowerUnits.AE, this.injectExternalPower(PowerUnits.EU, amount));
        this.setInternalCurrentPower(this.getInternalCurrentPower() + overflow);
        return 0.0;
    }

    public void invalidate() {
        super.invalidate();
        this.removeFromENet();
    }

    private void removeFromENet() {
        if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.IC2)) {
            IIC2 ic2Integration = (IIC2)IntegrationRegistry.INSTANCE.getInstance(IntegrationType.IC2);
            if (this.isInIC2 && Platform.isServer() && ic2Integration != null) {
                ic2Integration.removeFromEnergyNet(this);
                this.isInIC2 = false;
            }
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.removeFromENet();
    }

    @Override
    public void onReady() {
        super.onReady();
        this.addToENet();
    }

    private void addToENet() {
        if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.IC2)) {
            IIC2 ic2Integration = (IIC2)IntegrationRegistry.INSTANCE.getInstance(IntegrationType.IC2);
            if (!this.isInIC2 && Platform.isServer() && ic2Integration != null) {
                ic2Integration.addToEnergyNet(this);
                this.isInIC2 = true;
            }
        }
    }

    @Override
    protected void setPowerSides(EnumSet<ForgeDirection> sides) {
        super.setPowerSides(sides);
        this.removeFromENet();
        this.addToENet();
    }
}

