/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.grindstone;

import appeng.api.implementations.tiles.ICrankable;
import appeng.helpers.ICustomCollision;
import appeng.tile.AEBaseTile;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCrank
extends AEBaseTile
implements ICustomCollision {
    private final int ticksPerRotation = 18;
    private float visibleRotation = 0.0f;
    private int charge = 0;
    private int hits = 0;
    private int rotation = 0;

    @TileEvent(value=TileEventType.TICK)
    public void Tick_TileCrank() {
        if (this.rotation > 0) {
            this.setVisibleRotation(this.getVisibleRotation() - (float)(360 / this.ticksPerRotation));
            ++this.charge;
            if (this.charge >= this.ticksPerRotation) {
                this.charge -= this.ticksPerRotation;
                ICrankable g = this.getGrinder();
                if (g != null) {
                    g.applyTurn();
                }
            }
            --this.rotation;
        }
    }

    private ICrankable getGrinder() {
        if (Platform.isClient()) {
            return null;
        }
        ForgeDirection grinder = this.getUp().getOpposite();
        TileEntity te = this.worldObj.getTileEntity(this.xCoord + grinder.offsetX, this.yCoord + grinder.offsetY, this.zCoord + grinder.offsetZ);
        if (te instanceof ICrankable) {
            return (ICrankable)te;
        }
        return null;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileCrank(ByteBuf data) {
        this.rotation = data.readInt();
        return false;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileCrank(ByteBuf data) {
        data.writeInt(this.rotation);
    }

    @Override
    public void setOrientation(ForgeDirection inForward, ForgeDirection inUp) {
        super.setOrientation(inForward, inUp);
        this.getBlockType().onNeighborBlockChange(this.worldObj, this.xCoord, this.yCoord, this.zCoord, Platform.AIR_BLOCK);
    }

    @Override
    public boolean requiresTESR() {
        return true;
    }

    public boolean power() {
        ICrankable g;
        if (Platform.isClient()) {
            return false;
        }
        if (this.rotation < 3 && (g = this.getGrinder()) != null) {
            if (g.canTurn()) {
                this.hits = 0;
                this.rotation += this.ticksPerRotation;
                this.markForUpdate();
                return true;
            }
            ++this.hits;
            if (this.hits > 10) {
                this.worldObj.func_147480_a(this.xCoord, this.yCoord, this.zCoord, false);
            }
        }
        return false;
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, int x, int y, int z, Entity e, boolean isVisual) {
        double xOff = -0.15 * (double)this.getUp().offsetX;
        double yOff = -0.15 * (double)this.getUp().offsetY;
        double zOff = -0.15 * (double)this.getUp().offsetZ;
        return Collections.singletonList(AxisAlignedBB.getBoundingBox((double)(xOff + 0.15), (double)(yOff + 0.15), (double)(zOff + 0.15), (double)(xOff + 0.85), (double)(yOff + 0.85), (double)(zOff + 0.85)));
    }

    @Override
    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        double xOff = -0.15 * (double)this.getUp().offsetX;
        double yOff = -0.15 * (double)this.getUp().offsetY;
        double zOff = -0.15 * (double)this.getUp().offsetZ;
        out.add(AxisAlignedBB.getBoundingBox((double)(xOff + 0.15), (double)(yOff + 0.15), (double)(zOff + 0.15), (double)(xOff + 0.85), (double)(yOff + 0.85), (double)(zOff + 0.85)));
    }

    public float getVisibleRotation() {
        return this.visibleRotation;
    }

    private void setVisibleRotation(float visibleRotation) {
        this.visibleRotation = visibleRotation;
    }
}

