/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.DimensionalCoord;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCompassResponse;
import appeng.core.worlddata.WorldData;
import appeng.services.compass.ICompassCallback;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class PacketCompassRequest
extends AppEngPacket
implements ICompassCallback {
    final long attunement;
    final int cx;
    final int cz;
    final int cdy;
    private EntityPlayer talkBackTo;

    public PacketCompassRequest(ByteBuf stream) {
        this.attunement = stream.readLong();
        this.cx = stream.readInt();
        this.cz = stream.readInt();
        this.cdy = stream.readInt();
    }

    public PacketCompassRequest(long attunement, int cx, int cz, int cdy) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        this.attunement = attunement;
        data.writeLong(this.attunement);
        this.cx = cx;
        data.writeInt(this.cx);
        this.cz = cz;
        data.writeInt(this.cz);
        this.cdy = cdy;
        data.writeInt(this.cdy);
        this.configureWrite(data);
    }

    @Override
    public void calculatedDirection(boolean hasResult, boolean spin, double radians, double dist) {
        NetworkHandler.instance.sendTo(new PacketCompassResponse(this, hasResult, spin, radians), (EntityPlayerMP)this.talkBackTo);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        this.talkBackTo = player;
        DimensionalCoord loc = new DimensionalCoord(player.worldObj, this.cx << 4, this.cdy << 5, this.cz << 4);
        WorldData.instance().compassData().service().getCompassDirection(loc, 174, this);
    }
}

