/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.api.features.IInscriberRecipe;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseBlock;
import appeng.block.misc.BlockInscriber;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.ExtraBlockTextures;
import appeng.core.AELog;
import appeng.tile.AEBaseTile;
import appeng.tile.misc.TileInscriber;
import appeng.util.Platform;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderBlockInscriber
extends BaseBlockRender<BlockInscriber, TileInscriber> {
    private static final float ITEM_RENDER_SCALE = 0.9090909f;

    public RenderBlockInscriber() {
        super(true, 30.0);
    }

    @Override
    public void renderInventory(BlockInscriber blk, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        Tessellator tess = Tessellator.instance;
        renderer.renderAllFaces = true;
        this.setInvRenderBounds(renderer, 6, 1, 0, 10, 15, 2);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, tess, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 3, 1, 0, 13, 15, 3);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, tess, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 0, 1, 0, 3, 15, 16);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, tess, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 13, 1, 0, 16, 15, 16);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, tess, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 1, 0, 1, 15, 2, 15);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, tess, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 1, 14, 1, 15, 16, 15);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, tess, 0xFFFFFF, renderer);
        blk.getRendererInstance().setTemporaryRenderIcon(ExtraBlockTextures.BlockInscriberInside.getIcon());
        this.setInvRenderBounds(renderer, 3, 2, 3, 13, 3, 13);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, tess, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 3, 13, 3, 13, 15, 13);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, tess, 0xFFFFFF, renderer);
        blk.getRendererInstance().setTemporaryRenderIcon(null);
        renderer.renderAllFaces = false;
    }

    @Override
    public boolean renderInWorld(BlockInscriber block, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        IOrientable te = this.getOrientable(block, world, x, y, z);
        if (te == null) {
            return false;
        }
        this.preRenderInWorld(block, world, x, y, z, renderer);
        ForgeDirection fdy = te.getUp();
        ForgeDirection fdz = te.getForward();
        ForgeDirection fdx = Platform.crossProduct(fdz, fdy).getOpposite();
        renderer.renderAllFaces = true;
        this.renderBlockBounds(renderer, 3.0, 1.0, 0.0, 13.0, 15.0, 3.0, fdx, fdy, fdz);
        boolean out = renderer.renderStandardBlock((Block)block, x, y, z);
        this.renderBlockBounds(renderer, 0.0, 1.0, 0.0, 3.0, 15.0, 16.0, fdx, fdy, fdz);
        out = renderer.renderStandardBlock((Block)block, x, y, z);
        this.renderBlockBounds(renderer, 13.0, 1.0, 0.0, 16.0, 15.0, 16.0, fdx, fdy, fdz);
        out = renderer.renderStandardBlock((Block)block, x, y, z);
        this.renderBlockBounds(renderer, 1.0, 0.0, 1.0, 15.0, 4.0, 15.0, fdx, fdy, fdz);
        out = renderer.renderStandardBlock((Block)block, x, y, z);
        this.renderBlockBounds(renderer, 1.0, 12.0, 1.0, 15.0, 16.0, 15.0, fdx, fdy, fdz);
        out = renderer.renderStandardBlock((Block)block, x, y, z);
        block.getRendererInstance().setTemporaryRenderIcon(null);
        renderer.renderAllFaces = false;
        block.getRendererInstance().setTemporaryRenderIcon(null);
        this.postRenderInWorld(renderer);
        return out;
    }

    @Override
    public void renderTile(BlockInscriber block, TileInscriber tile, Tessellator tess, double x, double y, double z, float f, RenderBlocks renderer) {
        float relativeProgress;
        float progress;
        long currentTime;
        GL11.glPushMatrix();
        this.applyTESRRotation(x, y, z, tile.getForward(), tile.getUp());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)32826);
        GL11.glCullFace((int)1028);
        Minecraft mc = Minecraft.getMinecraft();
        mc.renderEngine.bindTexture(TextureMap.locationBlocksTexture);
        int br = tile.getWorldObj().getLightBrightnessForSkyBlocks(tile.xCoord, tile.yCoord, tile.zCoord, 0);
        int var11 = br % 65536;
        int var12 = br / 65536;
        OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)var11, (float)var12);
        long absoluteProgress = 0L;
        if (tile.isSmash() && (absoluteProgress = (currentTime = System.currentTimeMillis()) - tile.getClientStart()) > 800L) {
            tile.setSmash(false);
        }
        if ((progress = (relativeProgress = (float)(absoluteProgress % 800L) / 400.0f)) > 1.0f) {
            progress = 1.0f - (progress - 1.0f);
        }
        float press = 0.2f;
        IIcon ic = ExtraBlockTextures.BlockInscriberInside.getIcon();
        tess.startDrawingQuads();
        float middle = 0.5f;
        float TwoPx = 0.125f;
        tess.addVertexWithUV(0.125, (double)((middle += 0.02f) + (press -= progress / 5.0f)), 0.125, (double)ic.getInterpolatedU(2.0), (double)ic.getInterpolatedV(2.0));
        tess.addVertexWithUV(0.875, (double)(middle + press), 0.125, (double)ic.getInterpolatedU(14.0), (double)ic.getInterpolatedV(2.0));
        tess.addVertexWithUV(0.875, (double)(middle + press), 0.875, (double)ic.getInterpolatedU(14.0), (double)ic.getInterpolatedV(13.0));
        tess.addVertexWithUV(0.125, (double)(middle + press), 0.875, (double)ic.getInterpolatedU(2.0), (double)ic.getInterpolatedV(13.0));
        tess.addVertexWithUV(0.125, (double)(middle + press), 0.875, (double)ic.getInterpolatedU(2.0), (double)ic.getInterpolatedV(3.0));
        tess.addVertexWithUV(0.875, (double)(middle + press), 0.875, (double)ic.getInterpolatedU(14.0), (double)ic.getInterpolatedV(3.0));
        float base = 0.4f;
        tess.addVertexWithUV(0.875, (double)(middle + 0.4f), 0.875, (double)ic.getInterpolatedU(14.0), (double)ic.getInterpolatedV((double)(3.0f - 16.0f * (press - 0.4f))));
        tess.addVertexWithUV(0.125, (double)(middle + 0.4f), 0.875, (double)ic.getInterpolatedU(2.0), (double)ic.getInterpolatedV((double)(3.0f - 16.0f * (press - 0.4f))));
        tess.addVertexWithUV(0.875, (double)((middle -= 0.04f) - press), 0.125, (double)ic.getInterpolatedU(2.0), (double)ic.getInterpolatedV(2.0));
        tess.addVertexWithUV(0.125, (double)(middle - press), 0.125, (double)ic.getInterpolatedU(14.0), (double)ic.getInterpolatedV(2.0));
        tess.addVertexWithUV(0.125, (double)(middle - press), 0.875, (double)ic.getInterpolatedU(14.0), (double)ic.getInterpolatedV(13.0));
        tess.addVertexWithUV(0.875, (double)(middle - press), 0.875, (double)ic.getInterpolatedU(2.0), (double)ic.getInterpolatedV(13.0));
        tess.addVertexWithUV(0.875, (double)(middle - press), 0.875, (double)ic.getInterpolatedU(2.0), (double)ic.getInterpolatedV(3.0));
        tess.addVertexWithUV(0.125, (double)(middle - press), 0.875, (double)ic.getInterpolatedU(14.0), (double)ic.getInterpolatedV(3.0));
        tess.addVertexWithUV(0.125, (double)(middle - 0.4f), 0.875, (double)ic.getInterpolatedU(14.0), (double)ic.getInterpolatedV((double)(3.0f - 16.0f * (press - 0.4f))));
        tess.addVertexWithUV(0.875, (double)(middle + -0.4f), 0.875, (double)ic.getInterpolatedU(2.0), (double)ic.getInterpolatedV((double)(3.0f - 16.0f * (press - 0.4f))));
        tess.draw();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int items = 0;
        if (tile.getStackInSlot(0) != null) {
            ++items;
        }
        if (tile.getStackInSlot(1) != null) {
            ++items;
        }
        if (tile.getStackInSlot(2) != null) {
            ++items;
        }
        if (relativeProgress > 1.0f || items == 0) {
            IInscriberRecipe ir;
            ItemStack is = tile.getStackInSlot(3);
            if (is == null && (ir = tile.getTask()) != null) {
                is = ir.getOutput().copy();
            }
            this.renderItem(is, 0.0f, block, tile, tess, x, y, z, f, renderer);
        } else {
            this.renderItem(tile.getStackInSlot(0), press, block, tile, tess, x, y, z, f, renderer);
            this.renderItem(tile.getStackInSlot(1), -press, block, tile, tess, x, y, z, f, renderer);
            this.renderItem(tile.getStackInSlot(2), 0.0f, block, tile, tess, x, y, z, f, renderer);
        }
        GL11.glEnable((int)2896);
        GL11.glEnable((int)32826);
        GL11.glCullFace((int)1029);
    }

    private void renderItem(ItemStack sis, float o, AEBaseBlock block, AEBaseTile tile, Tessellator tess, double x, double y, double z, float f, RenderBlocks renderer) {
        if (sis != null) {
            sis = sis.copy();
            GL11.glPushMatrix();
            this.applyTESRRotation(x, y, z, tile.getForward(), tile.getUp());
            try {
                GL11.glTranslatef((float)0.5f, (float)(0.5f + o), (float)0.5f);
                GL11.glScalef((float)0.9090909f, (float)0.9090909f, (float)0.9090909f);
                Block blk = Block.getBlockFromItem((Item)sis.getItem());
                if (sis.getItemSpriteNumber() == 0 && block != null && RenderBlocks.renderItemIn3d((int)blk.getRenderType())) {
                    GL11.glRotatef((float)22.5f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)-33.75f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else {
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                int br = tile.getWorldObj().getLightBrightnessForSkyBlocks(tile.xCoord, tile.yCoord, tile.zCoord, 0);
                int var11 = br % 65536;
                int var12 = br / 65536;
                OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)var11, (float)var12);
                tess.setColorOpaque_F(1.0f, 1.0f, 1.0f);
                this.doRenderItem(sis, tile);
            }
            catch (Exception err) {
                AELog.debug(err);
            }
            GL11.glPopMatrix();
        }
    }
}

