/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.qnb;

import appeng.block.AEBaseTileBlock;
import appeng.client.render.blocks.RenderQNB;
import appeng.core.features.AEFeature;
import appeng.helpers.ICustomCollision;
import appeng.tile.qnb.TileQuantumBridge;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockQuantumBase
extends AEBaseTileBlock
implements ICustomCollision {
    public BlockQuantumBase(Material mat) {
        super(mat);
        this.setTileEntity(TileQuantumBridge.class);
        float shave = 0.125f;
        this.setBlockBounds(0.125f, 0.125f, 0.125f, 0.875f, 0.875f, 0.875f);
        this.setLightOpacity(0);
        this.isOpaque = false;
        this.isFullSize = false;
        this.setFeature(EnumSet.of(AEFeature.QuantumNetworkBridge));
    }

    public void onNeighborBlockChange(World w, int x, int y, int z, Block pointlessNumber) {
        TileQuantumBridge bridge = (TileQuantumBridge)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (bridge != null) {
            bridge.neighborUpdate();
        }
    }

    @Override
    public void breakBlock(World w, int x, int y, int z, Block a, int b) {
        TileQuantumBridge bridge = (TileQuantumBridge)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (bridge != null) {
            bridge.breakCluster();
        }
        super.breakBlock(w, x, y, z, a, b);
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderQNB getRenderer() {
        return new RenderQNB();
    }
}

