/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.texture.CableBusTextures;
import appeng.core.settings.TickRates;
import appeng.core.sync.GuiBridge;
import appeng.me.GridAccessException;
import appeng.parts.automation.PartSharedItemBus;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.OreFilteredList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Vec3;

public class PartImportBus
extends PartSharedItemBus
implements IInventoryDestination {
    private final BaseActionSource source;
    private IMEInventory<IAEItemStack> destination = null;
    private IAEItemStack lastItemChecked = null;
    private int itemToSend;
    private boolean worked;

    public PartImportBus(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.source = new MachineSource(this);
    }

    @Override
    public boolean canInsert(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        this.lastItemChecked = AEApi.instance().storage().createItemStack(stack);
        IAEItemStack out = this.destination.injectItems(this.lastItemChecked, Actionable.SIMULATE, this.source);
        if (out == null) {
            return true;
        }
        return out.getStackSize() != (long)stack.field_77994_a;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.getItemStack().func_77954_c(), CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartImportSides.getIcon());
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 15.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, this, this.getRenderCache()));
        rh.setTexture(CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.getItemStack().func_77954_c(), CableBusTextures.PartImportSides.getIcon(), CableBusTextures.PartImportSides.getIcon());
        rh.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(6.0f, 6.0f, 12.0f, 10.0f, 10.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorBack.getIcon(), this.getItemStack().func_77954_c(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon());
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(player, this.getHost().getTile(), this.getSide(), GuiBridge.GUI_BUS);
            return true;
        }
        return false;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.ImportBus.getMin(), TickRates.ImportBus.getMax(), this.getHandler() == null, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        return this.doBusWork();
    }

    @Override
    protected TickRateModulation doBusWork() {
        if (!this.getProxy().isActive() || !this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        this.worked = false;
        InventoryAdaptor myAdaptor = this.getHandler();
        FuzzyMode fzMode = (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE);
        if (myAdaptor != null) {
            try {
                this.itemToSend = this.calculateItemsToSend();
                this.itemToSend = Math.min(this.itemToSend, (int)(0.01 + this.getProxy().getEnergy().extractAEPower((double)this.itemToSend, Actionable.SIMULATE, PowerMultiplier.CONFIG)));
                IMEMonitor<IAEItemStack> inv = this.getProxy().getStorage().getItemInventory();
                IEnergyGrid energy = this.getProxy().getEnergy();
                boolean configured = false;
                if (this.getInstalledUpgrades(Upgrades.ORE_FILTER) == 0) {
                    for (int x = 0; x < this.availableSlots(); ++x) {
                        IAEItemStack ais = this.getConfig().getAEStackInSlot(x);
                        if (ais == null || this.itemToSend <= 0) continue;
                        configured = true;
                        while (this.itemToSend > 0 && !this.importStuff(myAdaptor, ais, inv, energy, fzMode)) {
                        }
                    }
                } else if (!this.oreFilterString.isEmpty()) {
                    configured = true;
                    if (this.filterPredicate == null) {
                        this.filterPredicate = OreFilteredList.makeFilter(this.oreFilterString);
                    }
                    for (ItemSlot slot : myAdaptor) {
                        if (this.itemToSend > 0) {
                            if (!slot.isExtractable() || !this.filterPredicate.test(slot.getAEItemStack())) continue;
                            while (this.itemToSend > 0 && !this.importStuff(myAdaptor, slot.getAEItemStack(), inv, energy, fzMode)) {
                            }
                            continue;
                        }
                        break;
                    }
                }
                if (!configured) {
                    while (this.itemToSend > 0) {
                        if (!this.importStuff(myAdaptor, null, inv, energy, fzMode)) continue;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {}
        } else {
            return TickRateModulation.SLEEP;
        }
        return this.worked ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    private boolean importStuff(InventoryAdaptor myAdaptor, IAEItemStack whatToImport, IMEMonitor<IAEItemStack> inv, IEnergySource energy, FuzzyMode fzMode) {
        int toSend = this.calculateMaximumAmountToImport(myAdaptor, whatToImport, inv, fzMode);
        ItemStack newItems = this.getInstalledUpgrades(Upgrades.FUZZY) > 0 ? myAdaptor.removeSimilarItems(toSend, whatToImport == null ? null : whatToImport.getItemStack(), fzMode, this.configDestination(inv)) : myAdaptor.removeItems(toSend, whatToImport == null ? null : whatToImport.getItemStack(), this.configDestination(inv));
        if (newItems != null) {
            newItems.field_77994_a = (int)(Math.min((double)newItems.field_77994_a, energy.extractAEPower(newItems.field_77994_a, Actionable.SIMULATE, PowerMultiplier.CONFIG)) + 0.01);
            this.itemToSend -= newItems.field_77994_a;
            if (this.lastItemChecked == null || !this.lastItemChecked.isSameType(newItems)) {
                this.lastItemChecked = AEApi.instance().storage().createItemStack(newItems);
            } else {
                this.lastItemChecked.setStackSize(newItems.field_77994_a);
            }
            IAEItemStack failed = Platform.poweredInsert(energy, this.destination, this.lastItemChecked, this.source);
            if (failed != null) {
                myAdaptor.addItems(failed.getItemStack());
                return true;
            }
        } else {
            return true;
        }
        this.worked = true;
        return false;
    }

    private int calculateMaximumAmountToImport(InventoryAdaptor myAdaptor, IAEItemStack whatToImport, IMEMonitor<IAEItemStack> inv, FuzzyMode fzMode) {
        int toSend = Math.min(this.itemToSend, 64);
        ItemStack itemStackToImport = whatToImport == null ? null : whatToImport.getItemStack();
        ItemStack simResult = this.getInstalledUpgrades(Upgrades.FUZZY) > 0 ? myAdaptor.simulateSimilarRemove(toSend, itemStackToImport, fzMode, this.configDestination(inv)) : myAdaptor.simulateRemove(toSend, itemStackToImport, this.configDestination(inv));
        IAEItemStack itemAmountNotStorable = this.destination.injectItems(AEItemStack.create(simResult), Actionable.SIMULATE, this.source);
        if (itemAmountNotStorable != null) {
            return (int)Math.min((long)simResult.field_77994_a - itemAmountNotStorable.getStackSize(), (long)toSend);
        }
        return toSend;
    }

    private IInventoryDestination configDestination(IMEMonitor<IAEItemStack> itemInventory) {
        this.destination = itemInventory;
        return this;
    }

    @Override
    protected boolean isSleeping() {
        return this.getHandler() == null || super.isSleeping();
    }

    @Override
    public RedstoneMode getRSMode() {
        return (RedstoneMode)this.getConfigManager().getSetting(Settings.REDSTONE_CONTROLLED);
    }
}

