/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.exceptions.AppEngException;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.CellInventoryHandler;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CellInventory
implements ICellInventory {
    private static final String ITEM_TYPE_TAG = "it";
    private static final String ITEM_COUNT_TAG = "ic";
    private static final String ITEM_SLOT = "#";
    private static final String ITEM_SLOT_COUNT = "@";
    private static final Set<Integer> BLACK_LIST = new HashSet<Integer>();
    private static String[] itemSlots;
    private static String[] itemSlotCount;
    private final NBTTagCompound tagCompound;
    private final ISaveProvider container;
    private int maxItemTypes = 63;
    private short storedItems = 0;
    private int storedItemCount = 0;
    private IItemList<IAEItemStack> cellItems;
    private final ItemStack cellItem;
    private IStorageCell cellType;

    private CellInventory(ItemStack o, ISaveProvider container) throws AppEngException {
        if (itemSlots == null) {
            itemSlots = new String[this.maxItemTypes];
            itemSlotCount = new String[this.maxItemTypes];
            for (int x = 0; x < this.maxItemTypes; ++x) {
                CellInventory.itemSlots[x] = ITEM_SLOT + x;
                CellInventory.itemSlotCount[x] = ITEM_SLOT_COUNT + x;
            }
        }
        if (o == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        this.cellType = null;
        this.cellItem = o;
        Item type = this.cellItem.func_77973_b();
        if (type instanceof IStorageCell) {
            this.cellType = (IStorageCell)this.cellItem.func_77973_b();
            this.maxItemTypes = this.cellType.getTotalTypes(this.cellItem);
        }
        if (this.cellType == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        if (!this.cellType.isStorageCell(this.cellItem)) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        if (this.maxItemTypes > 63) {
            this.maxItemTypes = 63;
        }
        if (this.maxItemTypes < 1) {
            this.maxItemTypes = 1;
        }
        this.container = container;
        this.tagCompound = Platform.openNbtData(o);
        this.storedItems = this.tagCompound.func_74765_d(ITEM_TYPE_TAG);
        this.storedItemCount = this.tagCompound.func_74762_e(ITEM_COUNT_TAG);
        this.cellItems = null;
    }

    public static IMEInventoryHandler<IAEItemStack> getCell(ItemStack o, ISaveProvider container2) {
        try {
            return new CellInventoryHandler(new CellInventory(o, container2));
        }
        catch (AppEngException e) {
            return null;
        }
    }

    private static boolean isStorageCell(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        try {
            Item type = itemStack.func_77973_b();
            if (type instanceof IStorageCell) {
                return !((IStorageCell)type).storableInStorageCell();
            }
        }
        catch (Throwable err) {
            return true;
        }
        return false;
    }

    public static boolean isCell(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item type = itemStack.func_77973_b();
        if (type instanceof IStorageCell) {
            return ((IStorageCell)type).isStorageCell(itemStack);
        }
        return false;
    }

    public static void addBasicBlackList(int itemID, int meta) {
        BLACK_LIST.add(meta << 16 | itemID);
    }

    private static boolean isBlackListed(IAEItemStack input) {
        if (BLACK_LIST.contains(0x7FFF0000 | Item.func_150891_b((Item)input.getItem()))) {
            return true;
        }
        return BLACK_LIST.contains(input.getItemDamage() << 16 | Item.func_150891_b((Item)input.getItem()));
    }

    private boolean isEmpty(IMEInventory<IAEItemStack> meInventory) {
        return meInventory.getAvailableItems(AEApi.instance().storage().createItemList()).isEmpty();
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, BaseActionSource src) {
        int remainingItemCount;
        IMEInventoryHandler<IAEItemStack> meInventory;
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (CellInventory.isBlackListed(input) || this.cellType.isBlackListed(this.cellItem, input)) {
            return input;
        }
        ItemStack sharedItemStack = input.getItemStack();
        if (CellInventory.isStorageCell(sharedItemStack) && (meInventory = CellInventory.getCell(sharedItemStack, null)) != null && !this.isEmpty(meInventory)) {
            return input;
        }
        IAEItemStack l = this.getCellItems().findPrecise(input);
        if (l != null) {
            long remainingItemSlots = this.getRemainingItemCount();
            if (remainingItemSlots < 0L) {
                return input;
            }
            if (input.getStackSize() > remainingItemSlots) {
                IAEItemStack r = input.copy();
                r.setStackSize(r.getStackSize() - remainingItemSlots);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() + remainingItemSlots);
                    this.updateItemCount(remainingItemSlots);
                    this.saveChanges();
                }
                return r;
            }
            if (mode == Actionable.MODULATE) {
                l.setStackSize(l.getStackSize() + input.getStackSize());
                this.updateItemCount(input.getStackSize());
                this.saveChanges();
            }
            return null;
        }
        if (this.canHoldNewItem() && (remainingItemCount = (int)this.getRemainingItemCount() - this.getBytesPerType() * 8) > 0) {
            if (input.getStackSize() > (long)remainingItemCount) {
                ItemStack toReturn = Platform.cloneItemStack(sharedItemStack);
                toReturn.field_77994_a = sharedItemStack.field_77994_a - remainingItemCount;
                if (mode == Actionable.MODULATE) {
                    ItemStack toWrite = Platform.cloneItemStack(sharedItemStack);
                    toWrite.field_77994_a = remainingItemCount;
                    this.cellItems.add(AEItemStack.create(toWrite));
                    this.updateItemCount(toWrite.field_77994_a);
                    this.saveChanges();
                }
                return AEItemStack.create(toReturn);
            }
            if (mode == Actionable.MODULATE) {
                this.updateItemCount(input.getStackSize());
                this.cellItems.add(input);
                this.saveChanges();
            }
            return null;
        }
        return input;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        if (request == null) {
            return null;
        }
        long size = Math.min(Integer.MAX_VALUE, request.getStackSize());
        IAEItemStack results = null;
        IAEItemStack l = this.getCellItems().findPrecise(request);
        if (l != null) {
            results = l.copy();
            if (l.getStackSize() <= size) {
                results.setStackSize(l.getStackSize());
                if (mode == Actionable.MODULATE) {
                    this.updateItemCount(-l.getStackSize());
                    l.setStackSize(0L);
                    this.saveChanges();
                }
            } else {
                results.setStackSize(size);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() - size);
                    this.updateItemCount(-size);
                    this.saveChanges();
                }
            }
        }
        return results;
    }

    private IItemList<IAEItemStack> getCellItems() {
        if (this.cellItems == null) {
            this.loadCellItems();
        }
        return this.cellItems;
    }

    private void updateItemCount(long delta) {
        this.storedItemCount = (int)((long)this.storedItemCount + delta);
        this.tagCompound.func_74768_a(ITEM_COUNT_TAG, this.storedItemCount);
    }

    private void saveChanges() {
        int itemCount = 0;
        int x = 0;
        for (IAEItemStack v : this.cellItems) {
            itemCount = (int)((long)itemCount + v.getStackSize());
            NBTBase c = this.tagCompound.func_74781_a(itemSlots[x]);
            if (c instanceof NBTTagCompound) {
                v.writeToNBT((NBTTagCompound)c);
            } else {
                NBTTagCompound g = new NBTTagCompound();
                v.writeToNBT(g);
                this.tagCompound.func_74782_a(itemSlots[x], (NBTBase)g);
            }
            this.tagCompound.func_74768_a(itemSlotCount[x], (int)v.getStackSize());
            ++x;
        }
        int oldStoredItems = this.storedItems;
        this.storedItems = (short)this.cellItems.size();
        if (this.cellItems.isEmpty()) {
            this.tagCompound.func_82580_o(ITEM_TYPE_TAG);
        } else {
            this.tagCompound.func_74777_a(ITEM_TYPE_TAG, this.storedItems);
        }
        this.storedItemCount = itemCount;
        if (itemCount == 0) {
            this.tagCompound.func_82580_o(ITEM_COUNT_TAG);
        } else {
            this.tagCompound.func_74768_a(ITEM_COUNT_TAG, itemCount);
        }
        while (x < oldStoredItems && x < this.maxItemTypes) {
            this.tagCompound.func_82580_o(itemSlots[x]);
            this.tagCompound.func_82580_o(itemSlotCount[x]);
            ++x;
        }
        if (this.container != null) {
            this.container.saveChanges(this);
        }
    }

    private void loadCellItems() {
        if (this.cellItems == null) {
            this.cellItems = AEApi.instance().storage().createItemList();
        }
        this.cellItems.resetStatus();
        int types = (int)this.getStoredItemTypes();
        for (int x = 0; x < types; ++x) {
            ItemStack t = ItemStack.func_77949_a((NBTTagCompound)this.tagCompound.func_74775_l(itemSlots[x]));
            if (t == null) continue;
            t.field_77994_a = this.tagCompound.func_74762_e(itemSlotCount[x]);
            if (t.field_77994_a <= 0) continue;
            this.cellItems.add(AEItemStack.create(t));
        }
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        for (IAEItemStack i : this.getCellItems()) {
            out.add(i);
        }
        return out;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public ItemStack getItemStack() {
        return this.cellItem;
    }

    @Override
    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    @Override
    public FuzzyMode getFuzzyMode() {
        return this.cellType.getFuzzyMode(this.cellItem);
    }

    @Override
    public String getOreFilter() {
        return this.cellType.getOreFilter(this.cellItem);
    }

    @Override
    public IInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.cellItem);
    }

    @Override
    public IInventory getUpgradesInventory() {
        return this.cellType.getUpgradesInventory(this.cellItem);
    }

    @Override
    public int getBytesPerType() {
        return this.cellType.getBytesPerType(this.cellItem);
    }

    @Override
    public boolean canHoldNewItem() {
        long bytesFree = this.getFreeBytes();
        return (bytesFree > (long)this.getBytesPerType() || bytesFree == (long)this.getBytesPerType() && this.getUnusedItemCount() > 0) && this.getRemainingItemTypes() > 0L;
    }

    @Override
    public long getTotalBytes() {
        return this.cellType.getBytes(this.cellItem);
    }

    @Override
    public long getFreeBytes() {
        return this.getTotalBytes() - this.getUsedBytes();
    }

    @Override
    public long getUsedBytes() {
        long bytesForItemCount = (this.getStoredItemCount() + (long)this.getUnusedItemCount()) / 8L;
        return this.getStoredItemTypes() * (long)this.getBytesPerType() + bytesForItemCount;
    }

    @Override
    public long getTotalItemTypes() {
        return this.maxItemTypes;
    }

    @Override
    public long getStoredItemCount() {
        return this.storedItemCount;
    }

    @Override
    public long getStoredItemTypes() {
        return this.storedItems;
    }

    @Override
    public long getRemainingItemTypes() {
        long baseOnTotal;
        long basedOnStorage = this.getFreeBytes() / (long)this.getBytesPerType();
        return basedOnStorage > (baseOnTotal = this.getTotalItemTypes() - this.getStoredItemTypes()) ? baseOnTotal : basedOnStorage;
    }

    @Override
    public long getRemainingItemCount() {
        long remaining = this.getFreeBytes() * 8L + (long)this.getUnusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    @Override
    public int getUnusedItemCount() {
        int div = (int)(this.getStoredItemCount() % 8L);
        if (div == 0) {
            return 0;
        }
        return 8 - div;
    }

    @Override
    public int getStatusForCell() {
        if (this.canHoldNewItem()) {
            return 1;
        }
        if (this.getRemainingItemCount() > 0L) {
            return 2;
        }
        return 3;
    }
}

