/*
 * This file is part of Applied Energistics 2.
 * Copyright (c) 2013 - 2014, AlgorithmX2, All rights reserved.
 *
 * Applied Energistics 2 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Applied Energistics 2 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with Applied Energistics 2.  If not, see <http://www.gnu.org/licenses/lgpl>.
 */

package appeng.transformer.annotations;


import appeng.integration.IntegrationType;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


public @interface Integration
{
	@Retention( RetentionPolicy.RUNTIME )
	@Target( ElementType.TYPE ) @interface InterfaceList
	{
		Interface[] value();
	}


	@Retention( RetentionPolicy.RUNTIME )
	@Target( ElementType.TYPE ) @interface Interface
	{
		String iface();

		IntegrationType iname();
	}


	@Retention( RetentionPolicy.RUNTIME )
	@Target( ElementType.METHOD ) @interface Method
	{
		IntegrationType iname();
	}
}