/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;

public class TileVibrationChamber
extends AENetworkInvTile
implements IGridTickable {
    private static final int FUEL_SLOT_INDEX = 0;
    private static final double POWER_PER_TICK = 5.0;
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0};
    private static final int MAX_BURN_SPEED = 200;
    private static final double DILATION_SCALING = 100.0;
    private static final int MIN_BURN_SPEED = 20;
    private final IInventory inv = new AppEngInternalInventory(this, 1);
    private int burnSpeed = 100;
    private double burnTime = 0.0;
    private double maxBurnTime = 0.0;
    public boolean isOn;

    public TileVibrationChamber() {
        this.getProxy().setIdlePowerUsage(0.0);
        this.getProxy().setFlags(new GridFlags[0]);
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean hasUpdate(ByteBuf data) {
        boolean wasOn = this.isOn;
        this.isOn = data.readBoolean();
        return wasOn != this.isOn;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToNetwork(ByteBuf data) {
        data.writeBoolean(this.getBurnTime() > 0.0);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileVibrationChamber(NBTTagCompound data) {
        data.setDouble("burnTime", this.getBurnTime());
        data.setDouble("maxBurnTime", this.getMaxBurnTime());
        data.setInteger("burnSpeed", this.getBurnSpeed());
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileVibrationChamber(NBTTagCompound data) {
        this.setBurnTime(data.getDouble("burnTime"));
        this.setMaxBurnTime(data.getDouble("maxBurnTime"));
        this.setBurnSpeed(data.getInteger("burnSpeed"));
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return TileEntityFurnace.getItemBurnTime((ItemStack)itemstack) > 0;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.getBurnTime() <= 0.0 && this.canEatFuel()) {
            try {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean canExtractItem(int slotIndex, ItemStack extractedItem, int side) {
        return extractedItem.getItem() == Items.bucket;
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return ACCESSIBLE_SLOTS;
    }

    private boolean canEatFuel() {
        int newBurnTime;
        ItemStack is = this.getStackInSlot(0);
        return is != null && (newBurnTime = TileEntityFurnace.getItemBurnTime((ItemStack)is)) > 0 && is.stackSize > 0;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        if (this.getBurnTime() <= 0.0) {
            this.eatFuel();
        }
        return new TickingRequest(TickRates.VibrationChamber.getMin(), TickRates.VibrationChamber.getMax(), this.getBurnTime() <= 0.0, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.getBurnTime() <= 0.0) {
            this.eatFuel();
            if (this.getBurnTime() > 0.0) {
                return TickRateModulation.URGENT;
            }
            this.setBurnSpeed(100);
            return TickRateModulation.SLEEP;
        }
        this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
        double dilation = (double)this.getBurnSpeed() / 100.0;
        double timePassed = (double)ticksSinceLastCall * dilation;
        this.setBurnTime(this.getBurnTime() - timePassed);
        if (this.getBurnTime() < 0.0) {
            timePassed += this.getBurnTime();
            this.setBurnTime(0.0);
        }
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            double newPower = timePassed * 5.0;
            double overFlow = grid.injectPower(newPower, Actionable.SIMULATE);
            grid.injectPower(Math.max(0.0, newPower - overFlow), Actionable.MODULATE);
            if (overFlow > 0.0) {
                this.setBurnSpeed(this.getBurnSpeed() - ticksSinceLastCall);
            } else {
                this.setBurnSpeed(this.getBurnSpeed() + ticksSinceLastCall);
            }
            this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
            return overFlow > 0.0 ? TickRateModulation.SLOWER : TickRateModulation.FASTER;
        }
        catch (GridAccessException e) {
            this.setBurnSpeed(this.getBurnSpeed() - ticksSinceLastCall);
            this.setBurnSpeed(Math.max(20, Math.min(this.getBurnSpeed(), 200)));
            return TickRateModulation.SLOWER;
        }
    }

    private void eatFuel() {
        int newBurnTime;
        ItemStack is = this.getStackInSlot(0);
        if (is != null && (newBurnTime = TileEntityFurnace.getItemBurnTime((ItemStack)is)) > 0 && is.stackSize > 0) {
            this.setBurnTime(this.getBurnTime() + (double)newBurnTime);
            this.setMaxBurnTime(this.getBurnTime());
            --is.stackSize;
            if (is.stackSize <= 0) {
                ItemStack container = null;
                if (is.getItem() != null && is.getItem().hasContainerItem(is)) {
                    container = is.getItem().getContainerItem(is);
                }
                this.setInventorySlotContents(0, container);
            } else {
                this.setInventorySlotContents(0, is);
            }
            this.markDirty();
        }
        if (this.getBurnTime() > 0.0) {
            try {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        if (!this.isOn && this.getBurnTime() > 0.0 || this.isOn && this.getBurnTime() <= 0.0) {
            this.isOn = this.getBurnTime() > 0.0;
            this.markForUpdate();
            if (this.hasWorldObj()) {
                Platform.notifyBlocksOfNeighbors(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    public int getBurnSpeed() {
        return this.burnSpeed;
    }

    private void setBurnSpeed(int burnSpeed) {
        this.burnSpeed = burnSpeed;
    }

    public double getMaxBurnTime() {
        return this.maxBurnTime;
    }

    private void setMaxBurnTime(double maxBurnTime) {
        this.maxBurnTime = maxBurnTime;
    }

    public double getBurnTime() {
        return this.burnTime;
    }

    private void setBurnTime(double burnTime) {
        this.burnTime = burnTime;
    }
}

