/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.AEApi;
import appeng.core.AEConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;

public class StorageChunkProvider
extends ChunkProviderGenerate {
    private static final int SQUARE_CHUNK_SIZE = 256;
    private static final Block[] BLOCKS = new Block[65280];
    private final World world;

    public StorageChunkProvider(World world, long i) {
        super(world, i, false);
        this.world = world;
    }

    public Chunk provideChunk(int x, int z) {
        Chunk chunk = new Chunk(this.world, BLOCKS, x, z);
        byte[] biomes = chunk.getBiomeArray();
        AEConfig config = AEConfig.instance;
        for (int k = 0; k < biomes.length; ++k) {
            biomes[k] = (byte)config.storageBiomeID;
        }
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            chunk.resetRelightChecks();
        }
        return chunk;
    }

    public void populate(IChunkProvider par1iChunkProvider, int par2, int par3) {
    }

    public boolean unloadQueuedChunks() {
        return true;
    }

    public List getPossibleCreatures(EnumCreatureType a, int b, int c, int d) {
        return new ArrayList();
    }

    static {
        for (Block matrixFrameBlock : AEApi.instance().definitions().blocks().matrixFrame().maybeBlock().asSet()) {
            for (int x = 0; x < BLOCKS.length; ++x) {
                StorageChunkProvider.BLOCKS[x] = matrixFrameBlock;
            }
        }
    }
}

