/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.MEPassThrough;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.FuzzyPriorityList;
import appeng.util.prioitylist.OreFilteredList;
import appeng.util.prioitylist.PrecisePriorityList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CellInventoryHandler
extends MEInventoryHandler<IAEItemStack>
implements ICellInventoryHandler {
    CellInventoryHandler(IMEInventory<IAEItemStack> c) {
        super(c, StorageChannel.ITEMS);
        ICellInventory ci = this.getCellInv();
        if (ci != null) {
            IInventory upgrades = ci.getUpgradesInventory();
            IInventory config = ci.getConfigInventory();
            FuzzyMode fzMode = ci.getFuzzyMode();
            String filter = ci.getOreFilter();
            boolean hasInverter = false;
            boolean hasFuzzy = false;
            boolean hasOreFilter = false;
            block5: for (int x = 0; x < upgrades.getSizeInventory(); ++x) {
                Upgrades u;
                ItemStack is = upgrades.getStackInSlot(x);
                if (is == null || !(is.getItem() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.getItem()).getType(is)) == null) continue;
                switch (u) {
                    case FUZZY: {
                        hasFuzzy = true;
                        continue block5;
                    }
                    case INVERTER: {
                        hasInverter = true;
                        continue block5;
                    }
                    case ORE_FILTER: {
                        hasOreFilter = true;
                        continue block5;
                    }
                }
            }
            this.setWhitelist(hasInverter ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
            if (hasOreFilter && !filter.isEmpty()) {
                this.setPartitionList(new OreFilteredList(filter));
            } else {
                IItemList<IAEItemStack> priorityList = AEApi.instance().storage().createItemList();
                for (int x = 0; x < config.getSizeInventory(); ++x) {
                    ItemStack is = config.getStackInSlot(x);
                    if (is == null) continue;
                    priorityList.add(AEItemStack.create(is));
                }
                if (!priorityList.isEmpty()) {
                    if (hasFuzzy) {
                        this.setPartitionList(new FuzzyPriorityList<IAEItemStack>(priorityList, fzMode));
                    } else {
                        this.setPartitionList(new PrecisePriorityList<IAEItemStack>(priorityList));
                    }
                }
            }
        }
    }

    @Override
    public ICellInventory getCellInv() {
        IMEInventory o = this.getInternal();
        if (o instanceof MEPassThrough) {
            o = ((MEPassThrough)o).getInternal();
        }
        return (ICellInventory)(o instanceof ICellInventory ? o : null);
    }

    @Override
    public boolean isPreformatted() {
        return !this.getPartitionList().isEmpty();
    }

    @Override
    public boolean isFuzzy() {
        return this.getPartitionList() instanceof FuzzyPriorityList;
    }

    @Override
    public IncludeExclude getIncludeExcludeMode() {
        return this.getWhitelist();
    }

    public int getStatusForCell() {
        int val = this.getCellInv().getStatusForCell();
        if (val == 1 && this.isPreformatted()) {
            val = 2;
        }
        return val;
    }
}

