/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.guiobjects.IGuiItem;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.implementations.items.IAEWrench;
import appeng.api.networking.IGridHost;
import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.INetworkToolAgent;
import appeng.client.ClientHelper;
import appeng.container.AEBaseContainer;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketClick;
import appeng.integration.IntegrationType;
import appeng.items.AEBaseItem;
import appeng.items.contents.NetworkToolViewer;
import appeng.transformer.annotations.Integration;
import appeng.util.Platform;
import buildcraft.api.tools.IToolWrench;
import com.google.common.base.Optional;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

@Integration.Interface(iface="buildcraft.api.tools.IToolWrench", iname=IntegrationType.BuildCraftCore)
public class ToolNetworkTool
extends AEBaseItem
implements IGuiItem,
IAEWrench,
IToolWrench {
    public ToolNetworkTool() {
        super((Optional<String>)Optional.absent());
        this.setFeature(EnumSet.of(AEFeature.NetworkTool));
        this.setMaxStackSize(1);
        this.setHarvestLevel("wrench", 0);
    }

    @Override
    public IGuiItemObject getGuiObject(ItemStack is, World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        return new NetworkToolViewer(is, (IGridHost)(te instanceof IGridHost ? te : null));
    }

    public ItemStack onItemRightClick(ItemStack it, World w, EntityPlayer p) {
        if (Platform.isClient()) {
            MovingObjectPosition mop = ClientHelper.proxy.getMOP();
            if (mop == null) {
                this.onItemUseFirst(it, p, w, 0, 0, 0, -1, 0.0f, 0.0f, 0.0f);
            } else {
                int i = mop.blockX;
                int j = mop.blockY;
                int k = mop.blockZ;
                if (w.getBlock(i, j, k).isAir((IBlockAccess)w, i, j, k)) {
                    this.onItemUseFirst(it, p, w, 0, 0, 0, -1, 0.0f, 0.0f, 0.0f);
                }
            }
        }
        return it;
    }

    public boolean onItemUseFirst(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)is, (int)1) <= 0) {
            return true;
        }
        Block blk = world.getBlock(x, y, z);
        if (blk != null && ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)(blk.isAir((IBlockAccess)world, x, y, z) ? PlayerInteractEvent.Action.RIGHT_CLICK_AIR : PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK), (int)x, (int)y, (int)z, (int)side, (World)world).isCanceled()) {
            return true;
        }
        MovingObjectPosition mop = new MovingObjectPosition(x, y, z, side, Vec3.createVectorHelper((double)hitX, (double)hitY, (double)hitZ));
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof IPartHost) {
            SelectedPart part = ((IPartHost)te).selectPart(mop.hitVec);
            if ((part.part != null || part.facade != null) && part.part instanceof INetworkToolAgent && !((INetworkToolAgent)((Object)part.part)).showNetworkInfo(mop)) {
                return false;
            }
        } else if (te instanceof INetworkToolAgent && !((INetworkToolAgent)te).showNetworkInfo(mop)) {
            return false;
        }
        if (Platform.isClient()) {
            NetworkHandler.instance.sendToServer(new PacketClick(x, y, z, side, hitX, hitY, hitZ));
        }
        return true;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    public boolean serverSideToolLogic(ItemStack is, EntityPlayer p, World w, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (side >= 0) {
            TileEntity te;
            if (!Platform.hasPermissions(new DimensionalCoord(w, x, y, z), p)) {
                return false;
            }
            Block b = w.getBlock(x, y, z);
            if (b != null && ForgeEventFactory.onPlayerInteract((EntityPlayer)p, (PlayerInteractEvent.Action)(b.isAir((IBlockAccess)w, x, y, z) ? PlayerInteractEvent.Action.RIGHT_CLICK_AIR : PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK), (int)x, (int)y, (int)z, (int)side, (World)w).isCanceled()) {
                return false;
            }
            if (b != null && !p.isSneaking() && !((te = w.getTileEntity(x, y, z)) instanceof IGridHost) && b.rotateBlock(w, x, y, z, ForgeDirection.getOrientation((int)side))) {
                b.onNeighborBlockChange(w, x, y, z, Platform.AIR_BLOCK);
                p.swingItem();
                return !w.isRemote;
            }
            if (!p.isSneaking()) {
                if (p.openContainer instanceof AEBaseContainer) {
                    return true;
                }
                te = w.getTileEntity(x, y, z);
                if (te instanceof IGridHost) {
                    Platform.openGUI(p, te, ForgeDirection.getOrientation((int)side), GuiBridge.GUI_NETWORK_STATUS);
                } else {
                    Platform.openGUI(p, null, ForgeDirection.UNKNOWN, GuiBridge.GUI_NETWORK_TOOL);
                }
                return true;
            }
            b.onBlockActivated(w, x, y, z, p, side, hitX, hitY, hitZ);
        } else {
            Platform.openGUI(p, null, ForgeDirection.UNKNOWN, GuiBridge.GUI_NETWORK_TOOL);
        }
        return false;
    }

    @Override
    public boolean canWrench(ItemStack is, EntityPlayer player, int x, int y, int z) {
        return true;
    }

    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        return true;
    }

    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        player.swingItem();
    }
}

