/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.storage;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.FuzzyPriorityList;
import appeng.util.prioitylist.IPartitionList;
import appeng.util.prioitylist.MergedPriorityList;
import appeng.util.prioitylist.OreFilteredList;
import appeng.util.prioitylist.PrecisePriorityList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ItemViewCell
extends AEBaseItem
implements ICellWorkbenchItem {
    public ItemViewCell() {
        this.setFeature(EnumSet.of(AEFeature.Core));
        this.setMaxStackSize(1);
    }

    public static IPartitionList<IAEItemStack> createFilter(ItemStack[] list) {
        MergedPriorityList<IAEItemStack> myPartitionList = null;
        MergedPriorityList<IAEItemStack> myMergedList = new MergedPriorityList<IAEItemStack>();
        for (ItemStack currentViewCell : list) {
            if (currentViewCell == null || !(currentViewCell.getItem() instanceof ItemViewCell)) continue;
            ICellWorkbenchItem vc = (ICellWorkbenchItem)currentViewCell.getItem();
            IInventory upgrades = vc.getUpgradesInventory(currentViewCell);
            IInventory config = vc.getConfigInventory(currentViewCell);
            FuzzyMode fzMode = vc.getFuzzyMode(currentViewCell);
            String filter = vc.getOreFilter(currentViewCell);
            boolean hasInverter = false;
            boolean hasFuzzy = false;
            boolean hasOreFilter = false;
            block6: for (int x = 0; x < upgrades.getSizeInventory(); ++x) {
                Upgrades u;
                ItemStack is = upgrades.getStackInSlot(x);
                if (is == null || !(is.getItem() instanceof IUpgradeModule) || (u = ((IUpgradeModule)is.getItem()).getType(is)) == null) continue;
                switch (u) {
                    case FUZZY: {
                        hasFuzzy = true;
                        continue block6;
                    }
                    case INVERTER: {
                        hasInverter = true;
                        continue block6;
                    }
                    case ORE_FILTER: {
                        hasOreFilter = true;
                        continue block6;
                    }
                }
            }
            if (hasOreFilter && !filter.isEmpty()) {
                myMergedList.addNewList(new OreFilteredList(filter), !hasInverter);
            } else {
                IItemList<IAEItemStack> priorityList = AEApi.instance().storage().createItemList();
                for (int x = 0; x < config.getSizeInventory(); ++x) {
                    ItemStack is = config.getStackInSlot(x);
                    if (is == null) continue;
                    priorityList.add(AEItemStack.create(is));
                }
                if (!priorityList.isEmpty()) {
                    if (hasFuzzy) {
                        myMergedList.addNewList(new FuzzyPriorityList<IAEItemStack>(priorityList, fzMode), !hasInverter);
                    } else {
                        myMergedList.addNewList(new PrecisePriorityList<IAEItemStack>(priorityList), !hasInverter);
                    }
                }
            }
            myPartitionList = myMergedList;
        }
        return myPartitionList;
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    @Override
    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData(is).getString("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData(is).setString("FuzzyMode", fzMode.name());
    }

    @Override
    public String getOreFilter(ItemStack is) {
        return Platform.openNbtData(is).getString("OreFilter");
    }

    @Override
    public void setOreFilter(ItemStack is, String filter) {
        Platform.openNbtData(is).setString("OreFilter", filter);
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        String filter = this.getOreFilter(stack);
        if (!filter.isEmpty()) {
            lines.add(GuiText.PartitionedOre.getLocal() + " : " + filter);
        }
    }
}

