/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.AEApi;
import appeng.api.definitions.IBlockDefinition;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.ITileDefinition;
import appeng.api.util.IOrientableBlock;
import appeng.core.AELog;
import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationHelper;
import appeng.integration.modules.BCHelpers.AECableSchematicTile;
import appeng.integration.modules.BCHelpers.AEGenericSchematicTile;
import appeng.integration.modules.BCHelpers.AERotatableBlockSchematic;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.ISchematicRegistry;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicTile;
import com.google.common.base.Optional;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class BuildCraftBuilder
implements IIntegrationModule {
    public static BuildCraftBuilder instance;

    public BuildCraftBuilder() {
        IntegrationHelper.testClassExistence(this, BuilderAPI.class);
        IntegrationHelper.testClassExistence(this, IBuilderContext.class);
        IntegrationHelper.testClassExistence(this, ISchematicRegistry.class);
        IntegrationHelper.testClassExistence(this, SchematicTile.class);
        IntegrationHelper.testClassExistence(this, SchematicBlock.class);
    }

    @Override
    public void init() throws Throwable {
        try {
            this.initBuilderSupport();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void postInit() {
    }

    private void initBuilderSupport() {
        ISchematicRegistry schematicRegistry = BuilderAPI.schematicRegistry;
        IBlocks blocks = AEApi.instance().definitions().blocks();
        ITileDefinition maybeMultiPart = blocks.multiPart();
        for (Method blockDefinition : blocks.getClass().getMethods()) {
            try {
                IBlockDefinition def = (IBlockDefinition)blockDefinition.invoke((Object)blocks, new Object[0]);
                Optional<Block> maybeBlock = def.maybeBlock();
                if (!maybeBlock.isPresent()) continue;
                Block block = (Block)maybeBlock.get();
                if (block instanceof IOrientableBlock && ((IOrientableBlock)block).usesMetadata() && !(def instanceof ITileDefinition)) {
                    schematicRegistry.registerSchematicBlock(block, AERotatableBlockSchematic.class, new Object[0]);
                    continue;
                }
                if (maybeMultiPart.isSameAs(new ItemStack(block))) {
                    schematicRegistry.registerSchematicBlock(block, AECableSchematicTile.class, new Object[0]);
                    continue;
                }
                if (!(def instanceof ITileDefinition)) continue;
                schematicRegistry.registerSchematicBlock(block, AEGenericSchematicTile.class, new Object[0]);
            }
            catch (InvocationTargetException ignore) {
                AELog.warn("Encountered problems while initializing the BuildCraft Builder support. Can not invoke the method %s", blockDefinition);
            }
            catch (IllegalAccessException ignore) {
                AELog.warn("Encountered problems while initializing the BuildCraft Builder support. Can not access the method %s", blockDefinition);
            }
        }
    }
}

