/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.AEApi;
import appeng.api.definitions.IMaterials;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.entity.AEBaseEntityItem;
import appeng.util.Platform;
import java.util.Date;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public final class EntitySingularity
extends AEBaseEntityItem {
    private static int randTickSeed = 0;

    public EntitySingularity(World w) {
        super(w);
    }

    public EntitySingularity(World w, double x, double y, double z, ItemStack is) {
        super(w, x, y, z, is);
    }

    public boolean attackEntityFrom(DamageSource src, float dmg) {
        if (src.isExplosion()) {
            this.doExplosion();
            return false;
        }
        return super.attackEntityFrom(src, dmg);
    }

    private void doExplosion() {
        if (Platform.isClient()) {
            return;
        }
        if (!AEConfig.instance.isFeatureEnabled(AEFeature.InWorldSingularity)) {
            return;
        }
        ItemStack item = this.getEntityItem();
        IMaterials materials = AEApi.instance().definitions().materials();
        if (materials.singularity().isSameAs(item)) {
            AxisAlignedBB region = AxisAlignedBB.getBoundingBox((double)(this.posX - 4.0), (double)(this.posY - 4.0), (double)(this.posZ - 4.0), (double)(this.posX + 4.0), (double)(this.posY + 4.0), (double)(this.posZ + 4.0));
            List<Entity> l = this.getCheckedEntitiesWithinAABBExcludingEntity(region);
            for (Entity e : l) {
                ItemStack other;
                if (!(e instanceof EntityItem) || (other = ((EntityItem)e).getEntityItem()) == null) continue;
                boolean matches = false;
                for (ItemStack is : OreDictionary.getOres((String)"dustEnder")) {
                    if (!OreDictionary.itemMatches((ItemStack)other, (ItemStack)is, (boolean)false)) continue;
                    matches = true;
                    break;
                }
                if (!matches) {
                    for (ItemStack is : OreDictionary.getOres((String)"dustEnderPearl")) {
                        if (!OreDictionary.itemMatches((ItemStack)other, (ItemStack)is, (boolean)false)) continue;
                        matches = true;
                        break;
                    }
                }
                if (!matches) continue;
                while (item.stackSize > 0 && other.stackSize > 0) {
                    --other.stackSize;
                    if (other.stackSize == 0) {
                        e.setDead();
                    }
                    for (ItemStack singularityStack : materials.qESingularity().maybeStack(2).asSet()) {
                        NBTTagCompound cmp = Platform.openNbtData(singularityStack);
                        cmp.setLong("freq", new Date().getTime() * 100L + (long)(randTickSeed % 100));
                        ++randTickSeed;
                        --item.stackSize;
                        EntitySingularity entity = new EntitySingularity(this.worldObj, this.posX, this.posY, this.posZ, singularityStack);
                        this.worldObj.spawnEntityInWorld((Entity)entity);
                    }
                }
                if (item.stackSize > 0) continue;
                this.setDead();
            }
        }
    }
}

