/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.stats;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.util.AEColor;
import appeng.api.util.AEColoredItemDefinition;
import appeng.core.stats.AchievementType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;

public enum Achievements {
    Compass(-2, -4, AEApi.instance().definitions().blocks().skyCompass(), AchievementType.Craft),
    Presses(-2, -2, AEApi.instance().definitions().materials().logicProcessorPress(), AchievementType.Custom),
    SpatialIO(-4, -4, AEApi.instance().definitions().blocks().spatialIOPort(), AchievementType.Craft),
    SpatialIOExplorer(-4, -2, AEApi.instance().definitions().items().spatialCell128(), AchievementType.Custom),
    StorageCell(-6, -4, AEApi.instance().definitions().items().cell64k(), AchievementType.CraftItem),
    IOPort(-6, -2, AEApi.instance().definitions().blocks().iOPort(), AchievementType.Craft),
    CraftingTerminal(-8, -4, AEApi.instance().definitions().parts().craftingTerminal(), AchievementType.Craft),
    PatternTerminal(-8, -2, AEApi.instance().definitions().parts().patternTerminal(), AchievementType.Craft),
    ChargedQuartz(0, -4, AEApi.instance().definitions().materials().certusQuartzCrystalCharged(), AchievementType.Pickup),
    Fluix(0, -2, AEApi.instance().definitions().materials().fluixCrystal(), AchievementType.Pickup),
    Charger(0, 0, AEApi.instance().definitions().blocks().charger(), AchievementType.Craft),
    CrystalGrowthAccelerator(-2, 0, AEApi.instance().definitions().blocks().quartzGrowthAccelerator(), AchievementType.Craft),
    GlassCable(2, 0, AEApi.instance().definitions().parts().cableGlass(), AchievementType.Craft),
    Networking1(4, -6, AEApi.instance().definitions().parts().cableCovered(), AchievementType.Custom),
    Controller(4, -4, AEApi.instance().definitions().blocks().controller(), AchievementType.Craft),
    Networking2(4, 0, AEApi.instance().definitions().parts().cableSmart(), AchievementType.Custom),
    Networking3(4, 2, AEApi.instance().definitions().parts().cableDense(), AchievementType.Custom),
    P2P(2, -2, AEApi.instance().definitions().parts().p2PTunnelME(), AchievementType.Craft),
    Recursive(6, -2, AEApi.instance().definitions().blocks().iface(), AchievementType.Craft),
    CraftingCPU(6, 0, AEApi.instance().definitions().blocks().craftingStorage64k(), AchievementType.CraftItem),
    Facade(6, 2, AEApi.instance().definitions().items().facade(), AchievementType.CraftItem),
    NetworkTool(8, 0, AEApi.instance().definitions().items().networkTool(), AchievementType.Craft),
    PortableCell(8, 2, AEApi.instance().definitions().items().portableCell(), AchievementType.Craft),
    StorageBus(10, 0, AEApi.instance().definitions().parts().storageBus(), AchievementType.Craft),
    QNB(10, 2, AEApi.instance().definitions().blocks().quantumLink(), AchievementType.Craft);

    private final ItemStack stack;
    private final AchievementType type;
    private final int x;
    private final int y;
    private Achievement parent;
    private Achievement stat;

    private Achievements(int x, int y, AEColoredItemDefinition which, AchievementType type) {
        this.stack = which != null ? which.stack(AEColor.Transparent, 1) : null;
        this.type = type;
        this.x = x;
        this.y = y;
    }

    private Achievements(int x, int y, IItemDefinition which, AchievementType type) {
        this.stack = (ItemStack)which.maybeStack(1).orNull();
        this.type = type;
        this.x = x;
        this.y = y;
    }

    private Achievements(int x, int y, ItemStack which, AchievementType type) {
        this.stack = which;
        this.type = type;
        this.x = x;
        this.y = y;
    }

    void setParent(Achievements parent) {
        this.parent = parent.getAchievement();
    }

    public Achievement getAchievement() {
        if (this.stat == null && this.getStack() != null) {
            this.stat = new Achievement("achievement.ae2." + this.name(), "ae2." + this.name(), this.x, this.y, this.getStack(), this.parent);
            this.stat.registerStat();
        }
        return this.stat;
    }

    public void addToPlayer(EntityPlayer player) {
        player.addStat((StatBase)this.getAchievement(), 1);
    }

    AchievementType getType() {
        return this.type;
    }

    ItemStack getStack() {
        return this.stack;
    }
}

