/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.AEApi;
import appeng.api.config.TunnelType;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IParts;
import appeng.api.features.IP2PTunnelRegistry;
import appeng.api.util.AEColor;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;

public final class P2PTunnelRegistry
implements IP2PTunnelRegistry {
    private static final int INITIAL_CAPACITY = 40;
    private final Map<ItemStack, TunnelType> tunnels = new HashMap<ItemStack, TunnelType>(40);

    public void configure() {
        this.addNewAttunement(new ItemStack(Blocks.torch), TunnelType.LIGHT);
        this.addNewAttunement(new ItemStack(Blocks.glowstone), TunnelType.LIGHT);
        this.addNewAttunement(new ItemStack(Items.redstone), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack(Items.repeater), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack(Blocks.redstone_lamp), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((Block)Blocks.unpowered_comparator), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((Block)Blocks.powered_comparator), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((Block)Blocks.powered_repeater), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((Block)Blocks.unpowered_repeater), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((Block)Blocks.daylight_detector), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((Block)Blocks.redstone_wire), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack(Blocks.redstone_block), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack(Blocks.lever), TunnelType.REDSTONE);
        this.addNewAttunement(this.getModItem("EnderIO", "itemRedstoneConduit", Short.MAX_VALUE), TunnelType.REDSTONE);
        IDefinitions definitions = AEApi.instance().definitions();
        IBlocks blocks = definitions.blocks();
        IParts parts = definitions.parts();
        this.addNewAttunement(blocks.iface(), TunnelType.ITEM);
        this.addNewAttunement(parts.iface(), TunnelType.ITEM);
        this.addNewAttunement(parts.storageBus(), TunnelType.ITEM);
        this.addNewAttunement(parts.importBus(), TunnelType.ITEM);
        this.addNewAttunement(parts.exportBus(), TunnelType.ITEM);
        this.addNewAttunement(new ItemStack((Block)Blocks.hopper), TunnelType.ITEM);
        this.addNewAttunement(new ItemStack((Block)Blocks.chest), TunnelType.ITEM);
        this.addNewAttunement(new ItemStack(Blocks.trapped_chest), TunnelType.ITEM);
        this.addNewAttunement(this.getModItem("ExtraUtilities", "extractor_base", 0), TunnelType.ITEM);
        this.addNewAttunement(this.getModItem("Mekanism", "PartTransmitter", 9), TunnelType.ITEM);
        this.addNewAttunement(this.getModItem("EnderIO", "itemItemConduit", Short.MAX_VALUE), TunnelType.ITEM);
        this.addNewAttunement(this.getModItem("ThermalDynamics", "ThermalDynamics_32", 0), TunnelType.ITEM);
        this.addNewAttunement(new ItemStack(Items.bucket), TunnelType.FLUID);
        this.addNewAttunement(new ItemStack(Items.lava_bucket), TunnelType.FLUID);
        this.addNewAttunement(new ItemStack(Items.milk_bucket), TunnelType.FLUID);
        this.addNewAttunement(new ItemStack(Items.water_bucket), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("Mekanism", "MachineBlock2", 11), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("Mekanism", "PartTransmitter", 4), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("ExtraUtilities", "extractor_base", 6), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("ExtraUtilities", "drum", Short.MAX_VALUE), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("EnderIO", "itemLiquidConduit", Short.MAX_VALUE), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("ThermalDynamics", "ThermalDynamics_16", 0), TunnelType.FLUID);
        for (AEColor c : AEColor.values()) {
            this.addNewAttunement(parts.cableGlass().stack(c, 1), TunnelType.ME);
            this.addNewAttunement(parts.cableCovered().stack(c, 1), TunnelType.ME);
            this.addNewAttunement(parts.cableSmart().stack(c, 1), TunnelType.ME);
            this.addNewAttunement(parts.cableDense().stack(c, 1), TunnelType.ME);
        }
    }

    @Override
    public void addNewAttunement(@Nullable ItemStack trigger, @Nullable TunnelType type) {
        if (type == null || trigger == null) {
            return;
        }
        this.tunnels.put(trigger, type);
    }

    @Override
    @Nullable
    public TunnelType getTunnelTypeByItem(ItemStack trigger) {
        if (trigger != null) {
            if (FluidContainerRegistry.isContainer((ItemStack)trigger)) {
                return TunnelType.FLUID;
            }
            for (ItemStack is : this.tunnels.keySet()) {
                if (is.getItem() == trigger.getItem() && is.getItemDamage() == Short.MAX_VALUE) {
                    return this.tunnels.get(is);
                }
                if (!Platform.isSameItem(is, trigger)) continue;
                return this.tunnels.get(is);
            }
        }
        return null;
    }

    @Nullable
    private ItemStack getModItem(String modID, String name, int meta) {
        ItemStack myItemStack = GameRegistry.findItemStack((String)modID, (String)name, (int)1);
        if (myItemStack == null) {
            return null;
        }
        myItemStack.setItemDamage(meta);
        return myItemStack;
    }

    private void addNewAttunement(IItemDefinition definition, TunnelType type) {
        for (ItemStack definitionStack : definition.maybeStack(1).asSet()) {
            this.addNewAttunement(definitionStack, type);
        }
    }
}

