/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.util.AEColor;
import appeng.block.qnb.BlockQuantumBase;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.ExtraBlockTextures;
import appeng.tile.qnb.TileQuantumBridge;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderQNB
extends BaseBlockRender<BlockQuantumBase, TileQuantumBridge> {
    private static final float DEFAULT_RENDER_MIN = 0.125f;
    private static final float DEFAULT_RENDER_MAX = 0.875f;
    private static final float CORNER_POWERED_RENDER_MIN = 0.24375f;
    private static final float CORNER_POWERED_RENDER_MAX = 0.75625f;
    private static final float CENTER_POWERED_RENDER_MIN = -6.25E-4f;
    private static final float CENTER_POWERED_RENDER_MAX = 1.000625f;

    @Override
    public void renderInventory(BlockQuantumBase block, ItemStack item, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        renderer.setRenderBounds(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
        super.renderInventory(block, item, renderer, type, obj);
    }

    @Override
    public boolean renderInWorld(BlockQuantumBase block, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        TileQuantumBridge tqb = (TileQuantumBridge)block.getTileEntity(world, x, y, z);
        if (tqb == null) {
            return false;
        }
        renderer.renderAllFaces = true;
        IDefinitions definitions = AEApi.instance().definitions();
        IBlocks blocks = definitions.blocks();
        IParts parts = definitions.parts();
        for (Block linkBlock : blocks.quantumLink().maybeBlock().asSet()) {
            if (tqb.getBlockType() == linkBlock) {
                if (tqb.isFormed()) {
                    EnumSet<ForgeDirection> sides = tqb.getConnections();
                    Item transGlassCable = parts.cableGlass().item(AEColor.Transparent);
                    this.renderCableAt(0.11, world, x, y, z, block, renderer, transGlassCable.getIconIndex(parts.cableGlass().stack(AEColor.Transparent, 1)), 0.141, sides);
                    Item transCoveredCable = parts.cableCovered().item(AEColor.Transparent);
                    this.renderCableAt(0.188, world, x, y, z, block, renderer, transCoveredCable.getIconIndex(parts.cableCovered().stack(AEColor.Transparent, 1)), 0.1875, sides);
                }
                renderer.setRenderBounds(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
                renderer.renderStandardBlock((Block)block, x, y, z);
                continue;
            }
            if (!tqb.isFormed()) {
                renderer.setRenderBounds(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
                renderer.renderStandardBlock((Block)block, x, y, z);
                continue;
            }
            if (tqb.isCorner()) {
                Item transCoveredCable = parts.cableCovered().item(AEColor.Transparent);
                this.renderCableAt(0.188, world, x, y, z, block, renderer, transCoveredCable.getIconIndex(parts.cableCovered().stack(AEColor.Transparent, 1)), 0.05, tqb.getConnections());
                renderer.setRenderBounds(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
                renderer.renderStandardBlock((Block)block, x, y, z);
                if (!tqb.isPowered()) continue;
                renderer.setRenderBounds((double)0.24375f, (double)0.24375f, (double)0.24375f, (double)0.75625f, (double)0.75625f, (double)0.75625f);
                Tessellator.instance.setColorOpaque_F(1.0f, 1.0f, 1.0f);
                int bn = 15;
                Tessellator.instance.setBrightness(0xF000F0);
                ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
                int n = forgeDirectionArray.length;
                for (int i = 0; i < n; ++i) {
                    ForgeDirection side = forgeDirectionArray[i];
                    this.renderFace(x, y, z, block, ExtraBlockTextures.BlockQRingCornerLight.getIcon(), renderer, side);
                }
                continue;
            }
            renderer.setRenderBounds(0.0, 0.125, 0.125, 1.0, 0.875, 0.875);
            renderer.renderStandardBlock((Block)block, x, y, z);
            renderer.setRenderBounds(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
            renderer.renderStandardBlock((Block)block, x, y, z);
            renderer.setRenderBounds(0.125, 0.125, 0.0, 0.875, 0.875, 1.0);
            renderer.renderStandardBlock((Block)block, x, y, z);
            if (!tqb.isPowered()) continue;
            renderer.setRenderBounds((double)-6.25E-4f, (double)-6.25E-4f, (double)-6.25E-4f, (double)1.000625f, (double)1.000625f, (double)1.000625f);
            Tessellator.instance.setColorOpaque_F(1.0f, 1.0f, 1.0f);
            int bn = 15;
            Tessellator.instance.setBrightness(0xF000F0);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                this.renderFace(x, y, z, block, ExtraBlockTextures.BlockQRingEdgeLight.getIcon(), renderer, side);
            }
        }
        renderer.renderAllFaces = false;
        return true;
    }

    private void renderCableAt(double thickness, IBlockAccess world, int x, int y, int z, BlockQuantumBase block, RenderBlocks renderer, IIcon texture, double pull, Collection<ForgeDirection> connections) {
        block.getRendererInstance().setTemporaryRenderIcon(texture);
        if (connections.contains(ForgeDirection.UNKNOWN)) {
            renderer.setRenderBounds(0.5 - thickness, 0.5 - thickness, 0.5 - thickness, 0.5 + thickness, 0.5 + thickness, 0.5 + thickness);
            renderer.renderStandardBlock((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.WEST)) {
            renderer.setRenderBounds(0.0, 0.5 - thickness, 0.5 - thickness, 0.5 - thickness - pull, 0.5 + thickness, 0.5 + thickness);
            renderer.renderStandardBlock((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.EAST)) {
            renderer.setRenderBounds(0.5 + thickness + pull, 0.5 - thickness, 0.5 - thickness, 1.0, 0.5 + thickness, 0.5 + thickness);
            renderer.renderStandardBlock((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.NORTH)) {
            renderer.setRenderBounds(0.5 - thickness, 0.5 - thickness, 0.0, 0.5 + thickness, 0.5 + thickness, 0.5 - thickness - pull);
            renderer.renderStandardBlock((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.SOUTH)) {
            renderer.setRenderBounds(0.5 - thickness, 0.5 - thickness, 0.5 + thickness + pull, 0.5 + thickness, 0.5 + thickness, 1.0);
            renderer.renderStandardBlock((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.DOWN)) {
            renderer.setRenderBounds(0.5 - thickness, 0.0, 0.5 - thickness, 0.5 + thickness, 0.5 - thickness - pull, 0.5 + thickness);
            renderer.renderStandardBlock((Block)block, x, y, z);
        }
        if (connections.contains(ForgeDirection.UP)) {
            renderer.setRenderBounds(0.5 - thickness, 0.5 + thickness + pull, 0.5 - thickness, 0.5 + thickness, 1.0, 0.5 + thickness);
            renderer.renderStandardBlock((Block)block, x, y, z);
        }
        block.getRendererInstance().setTemporaryRenderIcon(null);
    }
}

