/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.api.AEApi;
import appeng.api.util.AEColor;
import appeng.block.AEBaseTileBlock;
import appeng.block.crafting.BlockCraftingMonitor;
import appeng.block.crafting.BlockCraftingUnit;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BusRenderHelper;
import appeng.client.render.BusRenderer;
import appeng.client.texture.ExtraBlockTextures;
import appeng.tile.crafting.TileCraftingMonitorTile;
import appeng.tile.crafting.TileCraftingTile;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderBlockCraftingCPU<B extends BlockCraftingUnit, T extends TileCraftingTile>
extends BaseBlockRender<B, T> {
    protected RenderBlockCraftingCPU(boolean useTESR, int range) {
        super(useTESR, range);
    }

    public RenderBlockCraftingCPU() {
        super(false, 20.0);
    }

    @Override
    public boolean renderInWorld(B blk, IBlockAccess w, int x, int y, int z, RenderBlocks renderer) {
        IIcon theIcon;
        TileCraftingTile craftingTile = (TileCraftingTile)((AEBaseTileBlock)blk).getTileEntity(w, x, y, z);
        if (craftingTile == null) {
            return false;
        }
        boolean formed = craftingTile.isFormed();
        boolean emitsLight = craftingTile.isPowered();
        int meta = w.getBlockMetadata(x, y, z) & 3;
        boolean isMonitor = blk.getClass() == BlockCraftingMonitor.class;
        IIcon nonForward = theIcon = ((BlockCraftingUnit)blk).getIcon(ForgeDirection.SOUTH.ordinal(), meta | (formed ? 8 : 0));
        if (isMonitor) {
            for (Block craftingBlock : AEApi.instance().definitions().blocks().craftingUnit().maybeBlock().asSet()) {
                nonForward = craftingBlock.getIcon(0, meta | (formed ? 8 : 0));
            }
        }
        if (formed && renderer.overrideBlockTexture == null) {
            renderer = BusRenderer.INSTANCE.getRenderer();
            BusRenderHelper i = BusRenderHelper.INSTANCE;
            BusRenderer.INSTANCE.getRenderer().setFacade(true);
            renderer.blockAccess = w;
            i.setPass(0);
            i.setOrientation(ForgeDirection.EAST, ForgeDirection.UP, ForgeDirection.SOUTH);
            try {
                craftingTile.setLightCache(i.useSimplifiedRendering(x, y, z, null, craftingTile.getLightCache()));
            }
            catch (Throwable craftingBlock) {
                // empty catch block
            }
            float highX = this.isConnected(w, x, y, z, ForgeDirection.EAST) ? 16.0f : 13.01f;
            float lowX = this.isConnected(w, x, y, z, ForgeDirection.WEST) ? 0.0f : 2.99f;
            float highY = this.isConnected(w, x, y, z, ForgeDirection.UP) ? 16.0f : 13.01f;
            float lowY = this.isConnected(w, x, y, z, ForgeDirection.DOWN) ? 0.0f : 2.99f;
            float highZ = this.isConnected(w, x, y, z, ForgeDirection.SOUTH) ? 16.0f : 13.01f;
            float lowZ = this.isConnected(w, x, y, z, ForgeDirection.NORTH) ? 0.0f : 2.99f;
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.UP, ForgeDirection.EAST, ForgeDirection.NORTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.UP, ForgeDirection.EAST, ForgeDirection.SOUTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.UP, ForgeDirection.WEST, ForgeDirection.NORTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.UP, ForgeDirection.WEST, ForgeDirection.SOUTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.NORTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.SOUTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.DOWN, ForgeDirection.WEST, ForgeDirection.NORTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.DOWN, ForgeDirection.WEST, ForgeDirection.SOUTH);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                i.setBounds(this.fso(side, lowX, ForgeDirection.WEST), this.fso(side, lowY, ForgeDirection.DOWN), this.fso(side, lowZ, ForgeDirection.NORTH), this.fso(side, highX, ForgeDirection.EAST), this.fso(side, highY, ForgeDirection.UP), this.fso(side, highZ, ForgeDirection.SOUTH));
                i.prepareBounds(renderer);
                boolean localEmit = emitsLight;
                if (blk instanceof BlockCraftingMonitor && craftingTile.getForward() != side) {
                    localEmit = false;
                }
                this.handleSide(blk, meta, x, y, z, i, renderer, craftingTile.getForward() == side ? theIcon : nonForward, localEmit, isMonitor, side, w);
            }
            BusRenderer.INSTANCE.getRenderer().setFacade(false);
            i.setFacesToRender(EnumSet.allOf(ForgeDirection.class));
            i.normalRendering();
            return true;
        }
        double a = 0.0;
        double o = 1.0;
        renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return renderer.renderStandardBlock(blk, x, y, z);
    }

    private boolean isConnected(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        int tileYPos = y + side.offsetY;
        if (0 <= tileYPos && tileYPos <= 255) {
            TileEntity tile = w.getTileEntity(x + side.offsetX, tileYPos, z + side.offsetZ);
            return tile instanceof TileCraftingTile;
        }
        return false;
    }

    private void renderCorner(BusRenderHelper i, RenderBlocks renderer, IBlockAccess w, int x, int y, int z, ForgeDirection up, ForgeDirection east, ForgeDirection south) {
        if (this.isConnected(w, x, y, z, up) || this.isConnected(w, x, y, z, east) || this.isConnected(w, x, y, z, south)) {
            return;
        }
        i.setBounds(this.gso(east, 3.0f, ForgeDirection.WEST), this.gso(up, 3.0f, ForgeDirection.DOWN), this.gso(south, 3.0f, ForgeDirection.NORTH), this.gso(east, 13.0f, ForgeDirection.EAST), this.gso(up, 13.0f, ForgeDirection.UP), this.gso(south, 13.0f, ForgeDirection.SOUTH));
        i.prepareBounds(renderer);
        i.setTexture(ExtraBlockTextures.BlockCraftingUnitRing.getIcon());
        i.renderBlockCurrentBounds(x, y, z, renderer);
    }

    private float fso(ForgeDirection side, float def, ForgeDirection target) {
        if (side == target) {
            if (side.offsetX > 0 || side.offsetY > 0 || side.offsetZ > 0) {
                return 16.0f;
            }
            return 0.0f;
        }
        return def;
    }

    private void handleSide(B blk, int meta, int x, int y, int z, BusRenderHelper i, RenderBlocks renderer, IIcon color, boolean emitsLight, boolean isMonitor, ForgeDirection side, IBlockAccess w) {
        if (this.isConnected(w, x, y, z, side)) {
            return;
        }
        i.setFacesToRender(EnumSet.of(side));
        if (meta == 0 && blk.getClass() == BlockCraftingUnit.class) {
            i.setTexture(ExtraBlockTextures.BlockCraftingUnitFit.getIcon());
            i.renderBlockCurrentBounds(x, y, z, renderer);
        } else {
            if (color == ExtraBlockTextures.BlockCraftingMonitorFit_Light.getIcon()) {
                i.setTexture(ExtraBlockTextures.BlockCraftingMonitorOuter.getIcon());
            } else {
                i.setTexture(ExtraBlockTextures.BlockCraftingFitSolid.getIcon());
            }
            i.renderBlockCurrentBounds(x, y, z, renderer);
            if (color != null) {
                i.setTexture(color);
                if (!emitsLight) {
                    if (color == ExtraBlockTextures.BlockCraftingMonitorFit_Light.getIcon()) {
                        int b = w.getLightBrightnessForSkyBlocks(x + side.offsetX, y + side.offsetY, z + side.offsetZ, 0);
                        TileCraftingMonitorTile sr = (TileCraftingMonitorTile)((AEBaseTileBlock)blk).getTileEntity(w, x, y, z);
                        AEColor col = sr.getColor();
                        Tessellator.instance.setBrightness(b);
                        Tessellator.instance.setColorOpaque_I(col.whiteVariant);
                        i.renderFace(x, y, z, color, side, renderer);
                        Tessellator.instance.setColorOpaque_I(col.mediumVariant);
                        i.renderFace(x, y, z, ExtraBlockTextures.BlockCraftingMonitorFit_Medium.getIcon(), side, renderer);
                        Tessellator.instance.setColorOpaque_I(col.blackVariant);
                        i.renderFace(x, y, z, ExtraBlockTextures.BlockCraftingMonitorFit_Dark.getIcon(), side, renderer);
                    } else {
                        i.renderBlockCurrentBounds(x, y, z, renderer);
                    }
                } else if (isMonitor) {
                    TileCraftingMonitorTile sr = (TileCraftingMonitorTile)((AEBaseTileBlock)blk).getTileEntity(w, x, y, z);
                    AEColor col = sr.getColor();
                    Tessellator.instance.setColorOpaque_I(col.whiteVariant);
                    Tessellator.instance.setBrightness(0xD000D0);
                    i.renderFace(x, y, z, color, side, renderer);
                    Tessellator.instance.setColorOpaque_I(col.mediumVariant);
                    Tessellator.instance.setBrightness(0xD000D0);
                    i.renderFace(x, y, z, ExtraBlockTextures.BlockCraftingMonitorFit_Medium.getIcon(), side, renderer);
                    Tessellator.instance.setColorOpaque_I(col.blackVariant);
                    Tessellator.instance.setBrightness(0xD000D0);
                    i.renderFace(x, y, z, ExtraBlockTextures.BlockCraftingMonitorFit_Dark.getIcon(), side, renderer);
                } else {
                    Tessellator.instance.setColorOpaque_F(1.0f, 1.0f, 1.0f);
                    Tessellator.instance.setBrightness(0xD000D0);
                    i.renderFace(x, y, z, color, side, renderer);
                }
            }
        }
        for (ForgeDirection a : ForgeDirection.VALID_DIRECTIONS) {
            if (a == side || a == side.getOpposite()) continue;
            if (!(side.offsetX == 0 && side.offsetZ == 0 || a != ForgeDirection.NORTH && a != ForgeDirection.EAST && a != ForgeDirection.WEST && a != ForgeDirection.SOUTH)) {
                i.setTexture(ExtraBlockTextures.BlockCraftingUnitRingLongRotated.getIcon());
            } else if (side.offsetY != 0 && (a == ForgeDirection.EAST || a == ForgeDirection.WEST)) {
                i.setTexture(ExtraBlockTextures.BlockCraftingUnitRingLongRotated.getIcon());
            } else {
                i.setTexture(ExtraBlockTextures.BlockCraftingUnitRingLong.getIcon());
            }
            if (i.getBound(a) < 0.001 || i.getBound(a) > 15.999) continue;
            double width = 0.1875;
            switch (a) {
                case DOWN: {
                    renderer.renderMinY = 0.0;
                    renderer.renderMaxY = 0.1875;
                    break;
                }
                case EAST: {
                    renderer.renderMaxX = 1.0;
                    renderer.renderMinX = 0.8125;
                    renderer.uvRotateTop = 1;
                    renderer.uvRotateBottom = 1;
                    renderer.uvRotateWest = 1;
                    renderer.uvRotateEast = 1;
                    break;
                }
                case NORTH: {
                    renderer.renderMinZ = 0.0;
                    renderer.renderMaxZ = 0.1875;
                    renderer.uvRotateWest = 1;
                    renderer.uvRotateNorth = 1;
                    renderer.uvRotateSouth = 1;
                    break;
                }
                case SOUTH: {
                    renderer.renderMaxZ = 1.0;
                    renderer.renderMinZ = 0.8125;
                    renderer.uvRotateNorth = 1;
                    renderer.uvRotateSouth = 1;
                    break;
                }
                case UP: {
                    renderer.renderMaxY = 1.0;
                    renderer.renderMinY = 0.8125;
                    break;
                }
                case WEST: {
                    renderer.renderMinX = 0.0;
                    renderer.renderMaxX = 0.1875;
                    renderer.uvRotateTop = 1;
                    renderer.uvRotateBottom = 1;
                    renderer.uvRotateWest = 1;
                    renderer.uvRotateEast = 1;
                    break;
                }
            }
            i.renderBlockCurrentBounds(x, y, z, renderer);
            i.prepareBounds(renderer);
        }
    }

    private float gso(ForgeDirection side, float def, ForgeDirection target) {
        if (side != target) {
            if (side.offsetX > 0 || side.offsetY > 0 || side.offsetZ > 0) {
                return 16.0f;
            }
            return 0.0f;
        }
        return def;
    }
}

