/*
 * Decompiled with CFR 0.152.
 */
package appeng.client;

import appeng.api.parts.CableRenderMode;
import appeng.api.util.AEColor;
import appeng.block.AEBaseBlock;
import appeng.client.EffectType;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.TESRWrapper;
import appeng.client.render.WorldRender;
import appeng.client.render.effects.AssemblerFX;
import appeng.client.render.effects.CraftingFx;
import appeng.client.render.effects.EnergyFx;
import appeng.client.render.effects.LightningArcFX;
import appeng.client.render.effects.LightningFX;
import appeng.client.render.effects.VibrantFX;
import appeng.client.texture.CableBusTextures;
import appeng.client.texture.ExtraBlockTextures;
import appeng.client.texture.ExtraItemTextures;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketAssemblerAnimation;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.entity.EntityFloatingItem;
import appeng.entity.EntityTinyTNTPrimed;
import appeng.entity.RenderFloatingItem;
import appeng.entity.RenderTinyTNTPrimed;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.TickHandler;
import appeng.server.ServerHelper;
import appeng.transformer.MissingCoreMod;
import appeng.util.Platform;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class ClientHelper
extends ServerHelper {
    private static final RenderItem ITEM_RENDERER = new RenderItem();
    private static final RenderBlocks BLOCK_RENDERER = new RenderBlocks();

    @SubscribeEvent
    public void postPlayerRender(RenderLivingEvent.Pre p) {
        TickHandler.PlayerColor player = TickHandler.INSTANCE.getPlayerColors().get(p.entity.getEntityId());
        if (player != null) {
            AEColor col = player.myColor;
            float r = 0xFF & col.mediumVariant >> 16;
            float g = 0xFF & col.mediumVariant >> 8;
            float b = 0xFF & col.mediumVariant;
            GL11.glColor3f((float)(r / 255.0f), (float)(g / 255.0f), (float)(b / 255.0f));
        }
    }

    @Override
    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public World getWorld() {
        if (Platform.isClient()) {
            return Minecraft.getMinecraft().theWorld;
        }
        return super.getWorld();
    }

    @Override
    public void bindTileEntitySpecialRenderer(Class tile, AEBaseBlock blk) {
        BaseBlockRender bbr = blk.getRendererInstance().getRendererInstance();
        if (bbr.hasTESR() && tile != null) {
            ClientRegistry.bindTileEntitySpecialRenderer((Class)tile, (TileEntitySpecialRenderer)new TESRWrapper(bbr));
        }
    }

    @Override
    public List<EntityPlayer> getPlayers() {
        if (Platform.isClient()) {
            ArrayList<EntityPlayer> o = new ArrayList<EntityPlayer>();
            o.add((EntityPlayer)Minecraft.getMinecraft().thePlayer);
            return o;
        }
        return super.getPlayers();
    }

    @Override
    public void spawnEffect(EffectType effect, World worldObj, double posX, double posY, double posZ, Object o) {
        if (AEConfig.instance.enableEffects) {
            switch (effect) {
                case Assembler: {
                    this.spawnAssembler(worldObj, posX, posY, posZ, o);
                    return;
                }
                case Vibrant: {
                    this.spawnVibrant(worldObj, posX, posY, posZ);
                    return;
                }
                case Crafting: {
                    this.spawnCrafting(worldObj, posX, posY, posZ);
                    return;
                }
                case Energy: {
                    this.spawnEnergy(worldObj, posX, posY, posZ);
                    return;
                }
                case Lightning: {
                    this.spawnLightning(worldObj, posX, posY, posZ);
                    return;
                }
                case LightningArc: {
                    this.spawnLightningArc(worldObj, posX, posY, posZ, (Vec3)o);
                    return;
                }
            }
        }
    }

    private void spawnAssembler(World worldObj, double posX, double posY, double posZ, Object o) {
        PacketAssemblerAnimation paa = (PacketAssemblerAnimation)o;
        AssemblerFX fx = new AssemblerFX((World)Minecraft.getMinecraft().theWorld, posX, posY, posZ, 0.0, 0.0, 0.0, paa.rate, paa.is);
        Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)fx);
    }

    private void spawnVibrant(World w, double x, double y, double z) {
        if (CommonHelper.proxy.shouldAddParticles(Platform.getRandom())) {
            double d0 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d1 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d2 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            VibrantFX fx = new VibrantFX(w, x + d0, y + d1, z + d2, 0.0, 0.0, 0.0);
            Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)fx);
        }
    }

    private void spawnCrafting(World w, double posX, double posY, double posZ) {
        float x = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float y = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float z = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        CraftingFx fx = new CraftingFx(w, posX + (double)x, posY + (double)y, posZ + (double)z, Items.diamond);
        fx.motionX = (double)(-x) * 0.2;
        fx.motionY = (double)(-y) * 0.2;
        fx.motionZ = (double)(-z) * 0.2;
        Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)fx);
    }

    private void spawnEnergy(World w, double posX, double posY, double posZ) {
        float x = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float y = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float z = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        EnergyFx fx = new EnergyFx(w, posX + (double)x, posY + (double)y, posZ + (double)z, Items.diamond);
        fx.motionX = (double)(-x) * 0.1;
        fx.motionY = (double)(-y) * 0.1;
        fx.motionZ = (double)(-z) * 0.1;
        Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)fx);
    }

    private void spawnLightning(World worldObj, double posX, double posY, double posZ) {
        LightningFX fx = new LightningFX(worldObj, posX, posY + (double)0.3f, posZ, 0.0, 0.0, 0.0);
        Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)fx);
    }

    private void spawnLightningArc(World worldObj, double posX, double posY, double posZ, Vec3 second) {
        LightningArcFX fx = new LightningArcFX(worldObj, posX, posY, posZ, second.xCoord, second.yCoord, second.zCoord, 0.0, 0.0, 0.0);
        Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)fx);
    }

    @Override
    public boolean shouldAddParticles(Random r) {
        int setting = Minecraft.getMinecraft().gameSettings.particleSetting;
        if (setting == 2) {
            return false;
        }
        if (setting == 0) {
            return true;
        }
        return r.nextInt(2 * (setting + 1)) == 0;
    }

    @Override
    public MovingObjectPosition getMOP() {
        return Minecraft.getMinecraft().objectMouseOver;
    }

    @Override
    public void doRenderItem(ItemStack itemstack, World w) {
        if (itemstack != null) {
            EntityItem entityitem = new EntityItem(w, 0.0, 0.0, 0.0, itemstack);
            entityitem.getEntityItem().stackSize = 1;
            entityitem.hoverStart = 0.0f;
            entityitem.age = 0;
            entityitem.rotationYaw = 0.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)-0.04f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (itemstack.isItemEnchanted() || itemstack.getItem().requiresMultipleRenderPasses()) {
                IItemRenderer customRenderer;
                GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)-0.25f);
                GL11.glScalef((float)0.6666667f, (float)0.6666667f, (float)0.6666667f);
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)0.005f);
                Block block = Block.getBlockFromItem((Item)itemstack.getItem());
                if (itemstack.getItemSpriteNumber() == 0 && block != null && RenderBlocks.renderItemIn3d((int)block.getRenderType())) {
                    GL11.glRotatef((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)15.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if ((customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemstack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY)) != null && !(itemstack.getItem() instanceof ItemBlock)) {
                    if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, itemstack, IItemRenderer.ItemRendererHelper.BLOCK_3D)) {
                        GL11.glTranslatef((float)0.0f, (float)-0.04f, (float)0.0f);
                        GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
                        GL11.glRotatef((float)35.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                } else if (itemstack.getItem() instanceof ItemBlock) {
                    GL11.glTranslatef((float)0.0f, (float)-0.04f, (float)0.0f);
                    GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else {
                    GL11.glTranslatef((float)0.0f, (float)-0.14f, (float)0.0f);
                    GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
                }
                RenderItem.renderInFrame = true;
                RenderManager.instance.renderEntityWithPosYaw((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                RenderItem.renderInFrame = false;
            } else {
                GL11.glScalef((float)0.023809524f, (float)0.023809524f, (float)0.023809524f);
                GL11.glTranslated((double)-8.0, (double)-10.2, (double)-10.4);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)0.005f);
                RenderItem.renderInFrame = false;
                FontRenderer fr = Minecraft.getMinecraft().fontRenderer;
                if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)BLOCK_RENDERER, (TextureManager)Minecraft.getMinecraft().renderEngine, (ItemStack)itemstack, (boolean)true, (float)0.0f, (float)0.0f, (float)0.0f)) {
                    ITEM_RENDERER.renderItemIntoGUI(fr, Minecraft.getMinecraft().renderEngine, itemstack, 0, 0, false);
                }
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public void postInit() {
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)WorldRender.INSTANCE);
        RenderManager.instance.entityRenderMap.put(EntityTinyTNTPrimed.class, new RenderTinyTNTPrimed());
        RenderManager.instance.entityRenderMap.put(EntityFloatingItem.class, new RenderFloatingItem());
    }

    @Override
    public CableRenderMode getRenderMode() {
        if (Platform.isServer()) {
            return super.getRenderMode();
        }
        Minecraft mc = Minecraft.getMinecraft();
        EntityClientPlayerMP player = mc.thePlayer;
        return this.renderModeForPlayer((EntityPlayer)player);
    }

    @Override
    public void triggerUpdates() {
        Minecraft mc = Minecraft.getMinecraft();
        if (mc == null || mc.thePlayer == null || mc.theWorld == null) {
            return;
        }
        EntityClientPlayerMP player = mc.thePlayer;
        int x = (int)player.posX;
        int y = (int)player.posY;
        int z = (int)player.posZ;
        int range = 256;
        mc.theWorld.markBlockRangeForRenderUpdate(x - 256, y - 256, z - 256, x + 256, y + 256, z + 256);
    }

    @Override
    public void missingCoreMod() {
        throw new MissingCoreMod();
    }

    @SubscribeEvent
    public void wheelEvent(MouseEvent me) {
        if (me.isCanceled() || me.dwheel == 0) {
            return;
        }
        Minecraft mc = Minecraft.getMinecraft();
        EntityClientPlayerMP player = mc.thePlayer;
        ItemStack is = player.getHeldItem();
        if (is != null && is.getItem() instanceof IMouseWheelItem && player.isSneaking()) {
            try {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("Item", me.dwheel > 0 ? "WheelUp" : "WheelDown"));
                me.setCanceled(true);
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
    }

    @SubscribeEvent
    public void updateTextureSheet(TextureStitchEvent.Pre ev) {
        if (ev.map.getTextureType() == 1) {
            for (Enum enum_ : ExtraItemTextures.values()) {
                ((ExtraItemTextures)enum_).registerIcon(ev.map);
            }
        }
        if (ev.map.getTextureType() == 0) {
            for (Enum enum_ : ExtraBlockTextures.values()) {
                ((ExtraBlockTextures)enum_).registerIcon(ev.map);
            }
            for (Enum enum_ : CableBusTextures.values()) {
                ((CableBusTextures)enum_).registerIcon(ev.map);
            }
        }
    }
}

