/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.api.config.PowerMultiplier;
import appeng.block.AEBaseItemBlock;
import appeng.block.AEBaseItemBlockChargeable;
import appeng.block.AEBaseTileBlock;
import appeng.client.render.blocks.RenderBlockEnergyCube;
import appeng.client.texture.ExtraBlockTextures;
import appeng.core.features.AEFeature;
import appeng.helpers.AEGlassMaterial;
import appeng.tile.networking.TileEnergyCell;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class BlockEnergyCell
extends AEBaseTileBlock {
    public BlockEnergyCell() {
        super(AEGlassMaterial.INSTANCE);
        this.setTileEntity(TileEnergyCell.class);
        this.setFeature(EnumSet.of(AEFeature.Core));
    }

    @SideOnly(value=Side.CLIENT)
    protected RenderBlockEnergyCube getRenderer() {
        return new RenderBlockEnergyCube();
    }

    @Override
    public IIcon getIcon(int direction, int metadata) {
        switch (metadata) {
            case 0: {
                return ExtraBlockTextures.MEEnergyCell0.getIcon();
            }
            case 1: {
                return ExtraBlockTextures.MEEnergyCell1.getIcon();
            }
            case 2: {
                return ExtraBlockTextures.MEEnergyCell2.getIcon();
            }
            case 3: {
                return ExtraBlockTextures.MEEnergyCell3.getIcon();
            }
            case 4: {
                return ExtraBlockTextures.MEEnergyCell4.getIcon();
            }
            case 5: {
                return ExtraBlockTextures.MEEnergyCell5.getIcon();
            }
            case 6: {
                return ExtraBlockTextures.MEEnergyCell6.getIcon();
            }
            case 7: {
                return ExtraBlockTextures.MEEnergyCell7.getIcon();
            }
        }
        return super.getIcon(direction, metadata);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
        super.getCheckedSubBlocks(item, tabs, itemStacks);
        ItemStack charged = new ItemStack((Block)this, 1);
        NBTTagCompound tag = Platform.openNbtData(charged);
        tag.setDouble("internalCurrentPower", this.getMaxPower());
        tag.setDouble("internalMaxPower", this.getMaxPower());
        itemStacks.add(charged);
    }

    public double getMaxPower() {
        return 200000.0 * PowerMultiplier.CONFIG.multiplier;
    }

    @Override
    public Class<? extends AEBaseItemBlock> getItemBlockClass() {
        return AEBaseItemBlockChargeable.class;
    }
}

