/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.game;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IItems;
import appeng.api.definitions.IMaterials;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IItemList;
import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public final class DisassembleRecipe
implements IRecipe {
    private static final ItemStack MISMATCHED_STACK = null;
    private final Map<IItemDefinition, IItemDefinition> cellMappings;
    private final Map<IItemDefinition, IItemDefinition> nonCellMappings;

    public DisassembleRecipe() {
        IDefinitions definitions = AEApi.instance().definitions();
        IBlocks blocks = definitions.blocks();
        IItems items = definitions.items();
        IMaterials mats = definitions.materials();
        this.cellMappings = new HashMap<IItemDefinition, IItemDefinition>(4);
        this.nonCellMappings = new HashMap<IItemDefinition, IItemDefinition>(5);
        this.cellMappings.put(items.cell1k(), mats.cell1kPart());
        this.cellMappings.put(items.cell4k(), mats.cell4kPart());
        this.cellMappings.put(items.cell16k(), mats.cell16kPart());
        this.cellMappings.put(items.cell64k(), mats.cell64kPart());
        this.nonCellMappings.put(items.encodedPattern(), mats.blankPattern());
        this.nonCellMappings.put(blocks.craftingStorage1k(), mats.cell1kPart());
        this.nonCellMappings.put(blocks.craftingStorage4k(), mats.cell4kPart());
        this.nonCellMappings.put(blocks.craftingStorage16k(), mats.cell16kPart());
        this.nonCellMappings.put(blocks.craftingStorage64k(), mats.cell64kPart());
    }

    public boolean func_77569_a(InventoryCrafting inv, World w) {
        return this.getOutput((IInventory)inv) != null;
    }

    @Nullable
    private ItemStack getOutput(IInventory inventory) {
        int itemCount = 0;
        ItemStack output = MISMATCHED_STACK;
        for (int slotIndex = 0; slotIndex < inventory.func_70302_i_(); ++slotIndex) {
            ItemStack stackInSlot = inventory.func_70301_a(slotIndex);
            if (stackInSlot == null) continue;
            if (++itemCount > 1) {
                return MISMATCHED_STACK;
            }
            for (ItemStack storageCellStack : this.getCellOutput(stackInSlot).asSet()) {
                IItemList list;
                IMEInventoryHandler cellInv = AEApi.instance().registries().cell().getCellInventory(stackInSlot, null, StorageChannel.ITEMS);
                if (cellInv != null && !(list = cellInv.getAvailableItems(StorageChannel.ITEMS.createList())).isEmpty()) {
                    return null;
                }
                output = storageCellStack;
            }
            Iterator iterator = this.getNonCellOutput(stackInSlot).asSet().iterator();
            while (iterator.hasNext()) {
                ItemStack craftingStorageStack;
                output = craftingStorageStack = (ItemStack)iterator.next();
            }
        }
        return output;
    }

    @Nonnull
    private Optional<ItemStack> getCellOutput(ItemStack compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.cellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return entry.getValue().maybeStack(1);
        }
        return Optional.absent();
    }

    @Nonnull
    private Optional<ItemStack> getNonCellOutput(ItemStack compared) {
        for (Map.Entry<IItemDefinition, IItemDefinition> entry : this.nonCellMappings.entrySet()) {
            if (!entry.getKey().isSameAs(compared)) continue;
            return entry.getValue().maybeStack(1);
        }
        return Optional.absent();
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.getOutput((IInventory)inv);
    }

    public int func_77570_a() {
        return 1;
    }

    @Nullable
    public ItemStack func_77571_b() {
        return null;
    }
}

