/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import appeng.api.AEApi;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IDefinitions;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.parts.ISimplifiedBundle;
import appeng.api.parts.PartItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IConfigManager;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IPriorityHost;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.parts.networking.PartCable;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import com.google.common.base.Preconditions;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public abstract class AEBasePart
implements IPart,
IGridProxyable,
IActionHost,
IUpgradeableHost,
ICustomNameObject {
    private final AENetworkProxy proxy;
    private final ItemStack is;
    private ISimplifiedBundle renderCache = null;
    private TileEntity tile = null;
    private IPartHost host = null;
    private ForgeDirection side = null;

    public AEBasePart(ItemStack is) {
        Preconditions.checkNotNull((Object)is);
        this.is = is;
        this.proxy = new AENetworkProxy(this, "part", is, this instanceof PartCable);
        this.proxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
    }

    public IPartHost getHost() {
        return this.host;
    }

    @Override
    public IGridNode getGridNode(ForgeDirection dir) {
        return this.proxy.getNode();
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.GLASS;
    }

    @Override
    public void securityBreak() {
        if (this.getItemStack().field_77994_a > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(this.getItemStack().func_77946_l());
            this.host.removePart(this.getSide(), false);
            Platform.spawnDrops(this.tile.func_145831_w(), this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, items);
            this.getItemStack().field_77994_a = 0;
        }
    }

    protected AEColor getColor() {
        if (this.host == null) {
            return AEColor.Transparent;
        }
        return this.host.getColor();
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setBounds(1.0f, 1.0f, 1.0f, 15.0f, 15.0f, 15.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(1.0f, 1.0f, 1.0f, 15.0f, 15.0f, 15.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    public TileEntity getTile() {
        return this.tile;
    }

    @Override
    public AENetworkProxy getProxy() {
        return this.proxy;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.tile);
    }

    @Override
    public void gridChanged() {
    }

    @Override
    public IGridNode getActionableNode() {
        return this.proxy.getNode();
    }

    public void saveChanges() {
        this.host.markForSave();
    }

    @Override
    public String getCustomName() {
        return this.getItemStack().func_82833_r();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setBounds(1.0f, 1.0f, 1.0f, 15.0f, 15.0f, 15.0f);
        rh.renderBlock(x, y, z, renderer);
    }

    @Override
    public boolean hasCustomName() {
        return this.getItemStack().func_82837_s();
    }

    public void addEntityCrashInfo(CrashReportCategory crashreportcategory) {
        crashreportcategory.func_71507_a("Part Side", (Object)this.getSide());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, IPartRenderHelper rh, RenderBlocks renderer) {
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        if (type == PartItemStack.Network) {
            ItemStack copy = this.is.func_77946_l();
            copy.func_77982_d(null);
            return copy;
        }
        return this.is;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public void onNeighborChanged() {
    }

    @Override
    public boolean canConnectRedstone() {
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.proxy.readFromNBT(data);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        this.proxy.writeToNBT(data);
    }

    @Override
    public int isProvidingStrongPower() {
        return 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return 0;
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        return false;
    }

    @Override
    public IGridNode getGridNode() {
        return this.proxy.getNode();
    }

    @Override
    public void onEntityCollision(Entity entity) {
    }

    @Override
    public void removeFromWorld() {
        this.proxy.invalidate();
    }

    @Override
    public void addToWorld() {
        this.proxy.onReady();
    }

    @Override
    public void setPartHostInfo(ForgeDirection side, IPartHost host, TileEntity tile) {
        this.setSide(side);
        this.tile = tile;
        this.host = host;
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random r) {
    }

    @Override
    public int getLightLevel() {
        return 0;
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
    }

    @Override
    public int cableConnectionRenderTo() {
        return 3;
    }

    @Override
    public boolean isLadder(EntityLivingBase entity) {
        return false;
    }

    @Override
    public IConfigManager getConfigManager() {
        return null;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        return null;
    }

    private void uploadSettings(SettingsFrom from, NBTTagCompound compound) {
        IInventory inv;
        IConfigManager cm;
        if (compound != null && (cm = this.getConfigManager()) != null) {
            cm.readFromNBT(compound);
        }
        if (this instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)this);
            pHost.setPriority(compound.func_74762_e("priority"));
        }
        if ((inv = this.getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            AppEngInternalAEInventory target = (AppEngInternalAEInventory)inv;
            AppEngInternalAEInventory tmp = new AppEngInternalAEInventory(null, target.func_70302_i_());
            tmp.readFromNBT(compound, "config");
            for (int x = 0; x < tmp.func_70302_i_(); ++x) {
                target.func_70299_a(x, tmp.func_70301_a(x));
            }
        }
    }

    private NBTTagCompound downloadSettings(SettingsFrom from) {
        IInventory inv;
        NBTTagCompound output = new NBTTagCompound();
        IConfigManager cm = this.getConfigManager();
        if (cm != null) {
            cm.writeToNBT(output);
        }
        if (this instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)this);
            output.func_74768_a("priority", pHost.getPriority());
        }
        if ((inv = this.getInventoryByName("config")) instanceof AppEngInternalAEInventory) {
            ((AppEngInternalAEInventory)inv).writeToNBT(output, "config");
        }
        return output.func_82582_d() ? null : output;
    }

    public boolean useStandardMemoryCard() {
        return true;
    }

    private boolean useMemoryCard(EntityPlayer player) {
        ItemStack memCardIS = player.field_71071_by.func_70448_g();
        if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)memCardIS, (int)1) <= 0) {
            return false;
        }
        if (memCardIS != null && this.useStandardMemoryCard() && memCardIS.func_77973_b() instanceof IMemoryCard) {
            IMemoryCard memoryCard = (IMemoryCard)memCardIS.func_77973_b();
            ItemStack is = this.getItemStack(PartItemStack.Network);
            IDefinitions definitions = AEApi.instance().definitions();
            if (definitions.parts().iface().isSameAs(is)) {
                Iterator iterator = definitions.blocks().iface().maybeStack(1).asSet().iterator();
                while (iterator.hasNext()) {
                    ItemStack iface;
                    is = iface = (ItemStack)iterator.next();
                }
            }
            String name = is.func_77977_a();
            if (player.func_70093_af()) {
                NBTTagCompound data = this.downloadSettings(SettingsFrom.MEMORY_CARD);
                if (data != null) {
                    memoryCard.setMemoryCardContents(memCardIS, name, data);
                    memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                }
            } else {
                String storedName = memoryCard.getSettingsName(memCardIS);
                NBTTagCompound data = memoryCard.getData(memCardIS);
                if (name.equals(storedName)) {
                    this.uploadSettings(SettingsFrom.MEMORY_CARD, data);
                    memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                } else {
                    memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean onActivate(EntityPlayer player, Vec3 pos) {
        int x = this.tile.field_145851_c;
        int y = this.tile.field_145848_d;
        int z = this.tile.field_145849_e;
        PlayerInteractEvent event = ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, (int)x, (int)y, (int)z, (int)this.side.flag, (World)player.func_130014_f_());
        if (event.isCanceled()) {
            return false;
        }
        if (this.useMemoryCard(player)) {
            return true;
        }
        return this.onPartActivate(player, pos);
    }

    @Override
    public final boolean onShiftActivate(EntityPlayer player, Vec3 pos) {
        int x = this.tile.field_145851_c;
        int y = this.tile.field_145848_d;
        int z = this.tile.field_145849_e;
        PlayerInteractEvent event = ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, (int)x, (int)y, (int)z, (int)this.side.flag, (World)player.func_130014_f_());
        if (event.isCanceled()) {
            return false;
        }
        if (this.useMemoryCard(player)) {
            return true;
        }
        return this.onPartShiftActivate(player, pos);
    }

    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        return false;
    }

    public boolean onPartShiftActivate(EntityPlayer player, Vec3 pos) {
        return false;
    }

    @Override
    public void onPlacement(EntityPlayer player, ItemStack held, ForgeDirection side) {
        this.proxy.setOwner(player);
    }

    @Override
    public boolean canBePlacedOn(BusSupport what) {
        return what == BusSupport.CABLE;
    }

    @Override
    public boolean requireDynamicRender() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getBreakingTexture() {
        return null;
    }

    public ForgeDirection getSide() {
        return this.side;
    }

    private void setSide(ForgeDirection side) {
        this.side = side;
    }

    public ItemStack getItemStack() {
        return this.is;
    }

    public ISimplifiedBundle getRenderCache() {
        return this.renderCache;
    }

    public void setRenderCache(ISimplifiedBundle renderCache) {
        this.renderCache = renderCache;
    }
}

