/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.spatial;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.YesNo;
import appeng.api.implementations.TransitionResult;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkSpatialEvent;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.hooks.TickHandler;
import appeng.me.cache.SpatialPylonCache;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSpatialIOPort
extends AENetworkInvTile
implements IWorldCallable<Void> {
    private final int[] sides = new int[]{0, 1};
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 2);
    private YesNo lastRedstoneState = YesNo.UNDECIDED;

    public TileSpatialIOPort() {
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileSpatialIOPort(NBTTagCompound data) {
        data.setInteger("lastRedstoneState", this.lastRedstoneState.ordinal());
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileSpatialIOPort(NBTTagCompound data) {
        if (data.hasKey("lastRedstoneState")) {
            this.lastRedstoneState = YesNo.values()[data.getInteger("lastRedstoneState")];
        }
    }

    public boolean getRedstoneState() {
        if (this.lastRedstoneState == YesNo.UNDECIDED) {
            this.updateRedstoneState();
        }
        return this.lastRedstoneState == YesNo.YES;
    }

    public void updateRedstoneState() {
        YesNo currentState;
        YesNo yesNo = currentState = this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord) ? YesNo.YES : YesNo.NO;
        if (this.lastRedstoneState != currentState) {
            this.lastRedstoneState = currentState;
            if (this.lastRedstoneState == YesNo.YES) {
                this.triggerTransition();
            }
        }
    }

    private void triggerTransition() {
        ItemStack cell;
        if (Platform.isServer() && this.isSpatialCell(cell = this.getStackInSlot(0))) {
            TickHandler.INSTANCE.addCallable(null, this);
        }
    }

    private boolean isSpatialCell(ItemStack cell) {
        if (cell != null && cell.getItem() instanceof ISpatialStorageCell) {
            ISpatialStorageCell sc = (ISpatialStorageCell)cell.getItem();
            return sc != null && sc.isSpatialStorage(cell);
        }
        return false;
    }

    @Override
    public Void call(World world) throws Exception {
        ItemStack cell = this.getStackInSlot(0);
        if (this.isSpatialCell(cell) && this.getStackInSlot(1) == null) {
            MENetworkEvent res;
            double req;
            double pr;
            IGrid gi = this.getProxy().getGrid();
            IEnergyGrid energy = this.getProxy().getEnergy();
            ISpatialStorageCell sc = (ISpatialStorageCell)cell.getItem();
            SpatialPylonCache spc = (SpatialPylonCache)gi.getCache(ISpatialCache.class);
            if (spc.hasRegion() && spc.isValidRegion() && Math.abs((pr = energy.extractAEPower(req = (double)spc.requiredPower(), Actionable.SIMULATE, PowerMultiplier.CONFIG)) - req) < req * 0.001 && !(res = gi.postEvent(new MENetworkSpatialEvent(this, req))).isCanceled()) {
                TransitionResult tr = sc.doSpatialTransition(cell, this.worldObj, spc.getMin(), spc.getMax(), true);
                if (tr.success) {
                    energy.extractAEPower(req, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.setInventorySlotContents(0, null);
                    this.setInventorySlotContents(1, cell);
                }
            }
        }
        return null;
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return i == 0 && this.isSpatialCell(itemstack);
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public boolean canInsertItem(int slotIndex, ItemStack insertingItem, int side) {
        return this.isItemValidForSlot(slotIndex, insertingItem);
    }

    @Override
    public boolean canExtractItem(int slotIndex, ItemStack extractedItem, int side) {
        return slotIndex == 1;
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }
}

