/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.IConfigManager;
import appeng.core.sync.GuiBridge;
import appeng.me.GridAccessException;
import appeng.parts.reporting.AbstractPartDisplay;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public abstract class AbstractPartTerminal
extends AbstractPartDisplay
implements ITerminalHost,
IConfigManagerHost,
IViewCellStorage,
IAEAppEngInventory {
    private final IConfigManager cm = new ConfigManager(this);
    private final AppEngInternalInventory viewCell = new AppEngInternalInventory(this, 5);

    public AbstractPartTerminal(ItemStack is) {
        super(is);
        this.cm.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.cm.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.cm.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack is : this.viewCell) {
            if (is == null) continue;
            drops.add(is);
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.cm;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.cm.readFromNBT(data);
        this.viewCell.readFromNBT(data, "viewCell");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.cm.writeToNBT(data);
        this.viewCell.writeToNBT(data, "viewCell");
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (!super.onPartActivate(player, pos) && !player.isSneaking()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(player, this.getHost().getTile(), this.getSide(), this.getGui(player));
            return true;
        }
        return false;
    }

    public GuiBridge getGui(EntityPlayer player) {
        return GuiBridge.GUI_ME;
    }

    @Override
    public IMEMonitor<IAEItemStack> getItemInventory() {
        try {
            return this.getProxy().getStorage().getItemInventory();
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    @Override
    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        try {
            return this.getProxy().getStorage().getFluidInventory();
        }
        catch (GridAccessException gridAccessException) {
            return null;
        }
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }

    @Override
    public IInventory getViewCellStorage() {
        return this.viewCell;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        this.getHost().markForSave();
    }
}

