/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.util.AEColor;
import appeng.client.render.items.PaintBallRender;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class ItemPaintBall
extends AEBaseItem {
    private static final int DAMAGE_THRESHOLD = 20;

    public ItemPaintBall() {
        this.setFeature(EnumSet.of(AEFeature.PaintBalls));
        this.setHasSubtypes(true);
        if (Platform.isClient()) {
            MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)new PaintBallRender());
        }
    }

    public String getItemStackDisplayName(ItemStack is) {
        return super.getItemStackDisplayName(is) + " - " + this.getExtraName(is);
    }

    private String getExtraName(ItemStack is) {
        return (is.getItemDamage() >= 20 ? GuiText.Lumen.getLocal() + ' ' : "") + (Object)((Object)this.getColor(is));
    }

    public AEColor getColor(ItemStack is) {
        int dmg = is.getItemDamage();
        if (dmg >= 20) {
            dmg -= 20;
        }
        if (dmg >= AEColor.values().length) {
            return AEColor.Transparent;
        }
        return AEColor.values()[dmg];
    }

    @Override
    protected void getCheckedSubItems(Item sameItem, CreativeTabs creativeTab, List<ItemStack> itemStacks) {
        for (AEColor c : AEColor.values()) {
            if (c == AEColor.Transparent) continue;
            itemStacks.add(new ItemStack((Item)this, 1, c.ordinal()));
        }
        for (AEColor c : AEColor.values()) {
            if (c == AEColor.Transparent) continue;
            itemStacks.add(new ItemStack((Item)this, 1, 20 + c.ordinal()));
        }
    }

    public boolean isLumen(ItemStack is) {
        int dmg = is.getItemDamage();
        return dmg >= 20;
    }
}

