/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.helpers;

import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class MinefactoryReloadedDeepStorageUnit
implements IMEInventory<IAEItemStack> {
    private final IDeepStorageUnit dsu;

    public MinefactoryReloadedDeepStorageUnit(TileEntity ta) {
        this.dsu = (IDeepStorageUnit)ta;
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, BaseActionSource src) {
        ItemStack is = this.dsu.getStoredItemType();
        if (is != null) {
            if (input.equals(is)) {
                long storedItems;
                long max = this.dsu.getMaxStoredCount();
                if (max == (storedItems = (long)is.stackSize)) {
                    return input;
                }
                if ((storedItems += input.getStackSize()) > max) {
                    AEItemStack overflow = AEItemStack.create(is);
                    overflow.setStackSize((int)(storedItems - max));
                    if (mode == Actionable.MODULATE) {
                        this.dsu.setStoredItemCount((int)max);
                    }
                    return overflow;
                }
                if (mode == Actionable.MODULATE) {
                    this.dsu.setStoredItemCount(is.stackSize + (int)input.getStackSize());
                }
                return null;
            }
        } else {
            if (input.getTagCompound() != null) {
                return input;
            }
            if (mode == Actionable.MODULATE) {
                this.dsu.setStoredItemType(input.getItemStack(), (int)input.getStackSize());
            }
            return null;
        }
        return input;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        ItemStack is = this.dsu.getStoredItemType();
        if (request.equals(is)) {
            if (request.getStackSize() >= (long)is.stackSize) {
                is = is.copy();
                if (mode == Actionable.MODULATE) {
                    this.dsu.setStoredItemCount(0);
                }
                return AEItemStack.create(is);
            }
            if (mode == Actionable.MODULATE) {
                this.dsu.setStoredItemCount(is.stackSize - (int)request.getStackSize());
            }
            return request.copy();
        }
        return null;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        ItemStack is = this.dsu.getStoredItemType();
        if (is != null) {
            out.add(AEItemStack.create(is));
        }
        return out;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }
}

