/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features;

import appeng.api.definitions.ITileDefinition;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public final class WrappedDamageItemDefinition
implements ITileDefinition {
    private final ITileDefinition definition;
    private final int damage;

    public WrappedDamageItemDefinition(ITileDefinition definition, int damage) {
        Preconditions.checkNotNull((Object)definition);
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0);
        this.definition = definition;
        this.damage = damage;
    }

    @Override
    public Optional<? extends Class<? extends TileEntity>> maybeEntity() {
        return this.definition.maybeEntity();
    }

    @Override
    public Optional<Block> maybeBlock() {
        return this.definition.maybeBlock();
    }

    @Override
    public Optional<ItemBlock> maybeItemBlock() {
        return this.definition.maybeItemBlock();
    }

    @Override
    public Optional<Item> maybeItem() {
        return this.definition.maybeItem();
    }

    @Override
    public Optional<ItemStack> maybeStack(int stackSize) {
        return this.definition.maybeBlock().transform((Function)new BlockTransformFunction(stackSize, this.damage));
    }

    @Override
    public boolean isEnabled() {
        return this.definition.isEnabled();
    }

    @Override
    public boolean isSameAs(ItemStack comparableStack) {
        if (comparableStack == null) {
            return false;
        }
        boolean sameItem = this.definition.isSameAs(new ItemStack(comparableStack.getItem()));
        boolean sameDamage = comparableStack.getItemDamage() == this.damage;
        return sameItem && sameDamage;
    }

    @Override
    public boolean isSameAs(IBlockAccess world, int x, int y, int z) {
        return this.definition.isSameAs(world, x, y, z) && world.getBlockMetadata(x, y, z) == this.damage;
    }

    private static final class BlockTransformFunction
    implements Function<Block, ItemStack> {
        private final int stackSize;
        private final int damage;

        public BlockTransformFunction(int stackSize, int damage) {
            Preconditions.checkArgument((stackSize > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0);
            this.stackSize = stackSize;
            this.damage = damage;
        }

        public ItemStack apply(Block input) {
            Preconditions.checkNotNull((Object)input);
            return new ItemStack(input, this.stackSize, this.damage);
        }
    }
}

