/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.container.AEBaseContainer;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCompressedNBT;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.InventoryAction;
import appeng.items.misc.ItemEncodedPattern;
import appeng.parts.misc.PartInterface;
import appeng.parts.reporting.PartInterfaceTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.TileInterface;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.inv.WrapperInvSlot;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public final class ContainerInterfaceTerminal
extends AEBaseContainer {
    private static long autoBase = Long.MIN_VALUE;
    private final Map<IInterfaceHost, InvTracker> diList = new HashMap<IInterfaceHost, InvTracker>();
    private final Map<Long, InvTracker> byId = new HashMap<Long, InvTracker>();
    private IGrid grid;
    private NBTTagCompound data = new NBTTagCompound();

    public ContainerInterfaceTerminal(InventoryPlayer ip, PartInterfaceTerminal anchor) {
        super(ip, anchor);
        if (Platform.isServer()) {
            this.grid = anchor.getActionableNode().getGrid();
        }
        this.bindPlayerInventory(ip, 0, 140);
    }

    @Override
    public void detectAndSendChanges() {
        IGridNode agn;
        if (Platform.isClient()) {
            return;
        }
        super.detectAndSendChanges();
        if (this.grid == null) {
            return;
        }
        int total = 0;
        boolean missing = false;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityInterface dual;
            InvTracker t;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileInterface.class)) {
                if (!gn.isActive() || (ih = (IInterfaceHost)gn.getMachine()).getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getInterfaceDuality();
                    if (!t.unlocalizedName.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
            for (IGridNode gn : this.grid.getMachines(PartInterface.class)) {
                if (!gn.isActive() || (ih = (IInterfaceHost)gn.getMachine()).getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getInterfaceDuality();
                    if (!t.unlocalizedName.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
        }
        if (total != this.diList.size() || missing) {
            this.regenList(this.data);
        } else {
            for (Map.Entry<IInterfaceHost, InvTracker> en : this.diList.entrySet()) {
                InvTracker inv = en.getValue();
                for (int x = 0; x < inv.server.getSizeInventory(); ++x) {
                    if (!this.isDifferent(inv.server.getStackInSlot(x), inv.client.getStackInSlot(x))) continue;
                    this.addItems(this.data, inv, x, 1);
                }
            }
        }
        if (!this.data.hasNoTags()) {
            try {
                NetworkHandler.instance.sendTo(new PacketCompressedNBT(this.data), (EntityPlayerMP)this.getPlayerInv().player);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.data = new NBTTagCompound();
        }
    }

    @Override
    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        InvTracker inv = this.byId.get(id);
        if (inv != null) {
            ItemStack is = inv.server.getStackInSlot(slot);
            boolean hasItemInHand = player.inventory.getItemStack() != null;
            AdaptorPlayerHand playerHand = new AdaptorPlayerHand((EntityPlayer)player);
            PatternInvSlot slotInv = new PatternInvSlot(inv.server);
            IInventory theSlot = slotInv.getWrapper(slot);
            AdaptorIInventory interfaceSlot = new AdaptorIInventory(theSlot);
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (hasItemInHand) {
                        ItemStack inSlot = theSlot.getStackInSlot(0);
                        if (inSlot == null) {
                            player.inventory.setItemStack(((InventoryAdaptor)interfaceSlot).addItems(player.inventory.getItemStack()));
                            break;
                        }
                        inSlot = inSlot.copy();
                        ItemStack inHand = player.inventory.getItemStack().copy();
                        theSlot.setInventorySlotContents(0, null);
                        player.inventory.setItemStack(null);
                        player.inventory.setItemStack(((InventoryAdaptor)interfaceSlot).addItems(inHand.copy()));
                        if (player.inventory.getItemStack() == null) {
                            player.inventory.setItemStack(inSlot);
                            break;
                        }
                        player.inventory.setItemStack(inHand);
                        theSlot.setInventorySlotContents(0, inSlot);
                        break;
                    }
                    IInventory mySlot = slotInv.getWrapper(slot);
                    mySlot.setInventorySlotContents(0, ((InventoryAdaptor)playerHand).addItems(mySlot.getStackInSlot(0)));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    if (hasItemInHand) {
                        ItemStack extra = ((InventoryAdaptor)playerHand).removeItems(1, null, null);
                        if (extra != null) {
                            extra = ((InventoryAdaptor)interfaceSlot).addItems(extra);
                        }
                        if (extra == null) break;
                        ((InventoryAdaptor)playerHand).addItems(extra);
                        break;
                    }
                    if (is == null) break;
                    ItemStack extra = ((InventoryAdaptor)interfaceSlot).removeItems((is.stackSize + 1) / 2, null, null);
                    if (extra != null) {
                        extra = ((InventoryAdaptor)playerHand).addItems(extra);
                    }
                    if (extra == null) break;
                    ((InventoryAdaptor)interfaceSlot).addItems(extra);
                    break;
                }
                case SHIFT_CLICK: {
                    IInventory mySlot = slotInv.getWrapper(slot);
                    InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor(player, ForgeDirection.UNKNOWN);
                    mySlot.setInventorySlotContents(0, playerInv.addItems(mySlot.getStackInSlot(0)));
                    break;
                }
                case MOVE_REGION: {
                    InventoryAdaptor playerInvAd = InventoryAdaptor.getAdaptor(player, ForgeDirection.UNKNOWN);
                    for (int x = 0; x < inv.server.getSizeInventory(); ++x) {
                        inv.server.setInventorySlotContents(x, playerInvAd.addItems(inv.server.getStackInSlot(x)));
                    }
                    break;
                }
                case CREATIVE_DUPLICATE: {
                    if (!player.capabilities.isCreativeMode || hasItemInHand) break;
                    player.inventory.setItemStack(is == null ? null : is.copy());
                    break;
                }
                default: {
                    return;
                }
            }
            this.updateHeld(player);
        }
    }

    private void regenList(NBTTagCompound data) {
        IGridNode agn;
        this.byId.clear();
        this.diList.clear();
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityInterface dual;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileInterface.class)) {
                ih = (IInterfaceHost)gn.getMachine();
                dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
            }
            for (IGridNode gn : this.grid.getMachines(PartInterface.class)) {
                ih = (IInterfaceHost)gn.getMachine();
                dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
            }
        }
        data.setBoolean("clear", true);
        for (Map.Entry<IInterfaceHost, InvTracker> en : this.diList.entrySet()) {
            InvTracker inv = en.getValue();
            this.byId.put(inv.which, inv);
            this.addItems(data, inv, 0, inv.server.getSizeInventory());
        }
    }

    private boolean isDifferent(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return false;
        }
        if (a == null || b == null) {
            return true;
        }
        return !ItemStack.areItemStacksEqual((ItemStack)a, (ItemStack)b);
    }

    private void addItems(NBTTagCompound data, InvTracker inv, int offset, int length) {
        String name = '=' + Long.toString(inv.which, 36);
        NBTTagCompound tag = data.getCompoundTag(name);
        if (tag.hasNoTags()) {
            tag.setLong("sortBy", inv.sortBy);
            tag.setString("un", inv.unlocalizedName);
        }
        for (int x = 0; x < length; ++x) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            ItemStack is = inv.server.getStackInSlot(x + offset);
            inv.client.setInventorySlotContents(x + offset, is == null ? null : is.copy());
            if (is != null) {
                is.writeToNBT(itemNBT);
            }
            tag.setTag(Integer.toString(x + offset), (NBTBase)itemNBT);
        }
        data.setTag(name, (NBTBase)tag);
    }

    static /* synthetic */ long access$508() {
        return autoBase++;
    }

    private static class PatternInvSlot
    extends WrapperInvSlot {
        public PatternInvSlot(IInventory inv) {
            super(inv);
        }

        @Override
        public boolean isItemValid(ItemStack itemstack) {
            return itemstack != null && itemstack.getItem() instanceof ItemEncodedPattern;
        }
    }

    private static class InvTracker {
        private final long sortBy;
        private final long which = ContainerInterfaceTerminal.access$508();
        private final String unlocalizedName;
        private final IInventory client;
        private final IInventory server;

        public InvTracker(DualityInterface dual, IInventory patterns, String unlocalizedName) {
            this.server = patterns;
            this.client = new AppEngInternalInventory(null, this.server.getSizeInventory());
            this.unlocalizedName = unlocalizedName;
            this.sortBy = dual.getSortValue();
        }
    }
}

