/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.guisync;

import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketProgressBar;
import appeng.core.sync.packets.PacketValueConfig;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;

public class SyncData {
    private final AEBaseContainer source;
    private final Field field;
    private final int channel;
    private Object clientVersion = null;

    public SyncData(AEBaseContainer container, Field field, GuiSync annotation) {
        this.source = container;
        this.field = field;
        this.channel = annotation.value();
    }

    public int getChannel() {
        return this.channel;
    }

    public void tick(ICrafting c) {
        try {
            Object val = this.field.get((Object)this.source);
            if (val != null && this.clientVersion == null) {
                this.send(c, val);
            } else if (!val.equals(this.clientVersion)) {
                this.send(c, val);
            }
        }
        catch (IllegalArgumentException e) {
            AELog.debug(e);
        }
        catch (IllegalAccessException e) {
            AELog.debug(e);
        }
        catch (IOException e) {
            AELog.debug(e);
        }
    }

    private void send(ICrafting o, Object val) throws IOException {
        if (val instanceof String) {
            if (o instanceof EntityPlayerMP) {
                NetworkHandler.instance.sendTo(new PacketValueConfig("SyncDat." + this.channel, (String)val), (EntityPlayerMP)o);
            }
        } else if (this.field.getType().isEnum()) {
            o.sendProgressBarUpdate((Container)this.source, this.channel, ((Enum)val).ordinal());
        } else if (val instanceof Long || val.getClass() == Long.TYPE) {
            NetworkHandler.instance.sendTo(new PacketProgressBar(this.channel, (Long)val), (EntityPlayerMP)o);
        } else if (val instanceof Boolean || val.getClass() == Boolean.TYPE) {
            o.sendProgressBarUpdate((Container)this.source, this.channel, (Boolean)val != false ? 1 : 0);
        } else {
            o.sendProgressBarUpdate((Container)this.source, this.channel, ((Integer)val).intValue());
        }
        this.clientVersion = val;
    }

    public void update(Object val) {
        try {
            Object oldValue = this.field.get((Object)this.source);
            if (val instanceof String) {
                this.updateString(oldValue, (String)val);
            } else {
                this.updateValue(oldValue, (Long)val);
            }
        }
        catch (IllegalArgumentException e) {
            AELog.debug(e);
        }
        catch (IllegalAccessException e) {
            AELog.debug(e);
        }
    }

    private void updateString(Object oldValue, String val) {
        try {
            this.field.set((Object)this.source, val);
        }
        catch (IllegalArgumentException e) {
            AELog.debug(e);
        }
        catch (IllegalAccessException e) {
            AELog.debug(e);
        }
    }

    private void updateValue(Object oldValue, long val) {
        try {
            if (this.field.getType().isEnum()) {
                EnumSet<Enum> valList = EnumSet.allOf(this.field.getType());
                for (Enum e : valList) {
                    if ((long)e.ordinal() != val) continue;
                    this.field.set((Object)this.source, e);
                    break;
                }
            } else if (this.field.getType().equals(Integer.TYPE)) {
                this.field.set((Object)this.source, (int)val);
            } else if (this.field.getType().equals(Long.TYPE)) {
                this.field.set((Object)this.source, val);
            } else if (this.field.getType().equals(Boolean.TYPE)) {
                this.field.set((Object)this.source, val == 1L);
            } else if (this.field.getType().equals(Integer.class)) {
                this.field.set((Object)this.source, (int)val);
            } else if (this.field.getType().equals(Long.class)) {
                this.field.set((Object)this.source, val);
            } else if (this.field.getType().equals(Boolean.class)) {
                this.field.set((Object)this.source, val == 1L);
            }
            this.source.onUpdate(this.field.getName(), oldValue, this.field.get((Object)this.source));
        }
        catch (IllegalArgumentException e) {
            AELog.debug(e);
        }
        catch (IllegalAccessException e) {
            AELog.debug(e);
        }
    }
}

