/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.texture;

import javax.annotation.Nonnull;
import net.minecraft.util.IIcon;

public class FlippableIcon
implements IIcon {
    private IIcon original;
    private boolean flip_u;
    private boolean flip_v;

    public FlippableIcon(IIcon o) {
        if (o == null) {
            throw new IllegalArgumentException("Cannot create a wrapper icon with a null icon.");
        }
        this.setOriginal(o);
        this.setFlipU(false);
        this.setFlipV(false);
    }

    public int getIconWidth() {
        return this.getOriginal().getIconWidth();
    }

    public int getIconHeight() {
        return this.getOriginal().getIconHeight();
    }

    public float getMinU() {
        if (this.isFlipU()) {
            return this.getOriginal().getMaxU();
        }
        return this.getOriginal().getMinU();
    }

    public float getMaxU() {
        if (this.isFlipU()) {
            return this.getOriginal().getMinU();
        }
        return this.getOriginal().getMaxU();
    }

    public float getInterpolatedU(double px) {
        if (this.isFlipU()) {
            return this.getOriginal().getInterpolatedU(16.0 - px);
        }
        return this.getOriginal().getInterpolatedU(px);
    }

    public float getMinV() {
        if (this.isFlipV()) {
            return this.getOriginal().getMaxV();
        }
        return this.getOriginal().getMinV();
    }

    public float getMaxV() {
        if (this.isFlipV()) {
            return this.getOriginal().getMinV();
        }
        return this.getOriginal().getMaxV();
    }

    public float getInterpolatedV(double px) {
        if (this.isFlipV()) {
            return this.getOriginal().getInterpolatedV(16.0 - px);
        }
        return this.getOriginal().getInterpolatedV(px);
    }

    public String getIconName() {
        return this.getOriginal().getIconName();
    }

    public IIcon getOriginal() {
        return this.original;
    }

    public void setFlip(boolean u, boolean v) {
        this.setFlipU(u);
        this.setFlipV(v);
    }

    public int setFlip(int orientation) {
        this.setFlipU((orientation & 8) == 8);
        this.setFlipV((orientation & 0x10) == 16);
        return orientation & 7;
    }

    boolean isFlipU() {
        return this.flip_u;
    }

    void setFlipU(boolean flipU) {
        this.flip_u = flipU;
    }

    boolean isFlipV() {
        return this.flip_v;
    }

    void setFlipV(boolean flipV) {
        this.flip_v = flipV;
    }

    public void setOriginal(@Nonnull IIcon original) {
        this.original = original;
    }
}

