/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.api.util.AEColor;
import appeng.block.misc.BlockSecurity;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.ExtraBlockTextures;
import appeng.tile.misc.TileSecurity;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RendererSecurity
extends BaseBlockRender<BlockSecurity, TileSecurity> {
    public RendererSecurity() {
        super(false, 0.0);
    }

    @Override
    public void renderInventory(BlockSecurity block, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        renderer.overrideBlockTexture = ExtraBlockTextures.getMissing();
        this.renderInvBlock(EnumSet.of(ForgeDirection.SOUTH), block, is, Tessellator.instance, 0, renderer);
        renderer.overrideBlockTexture = ExtraBlockTextures.MEChest.getIcon();
        this.renderInvBlock(EnumSet.of(ForgeDirection.UP), block, is, Tessellator.instance, this.adjustBrightness(AEColor.Transparent.whiteVariant, 0.7), renderer);
        renderer.overrideBlockTexture = null;
        super.renderInventory(block, is, renderer, type, obj);
    }

    @Override
    public boolean renderInWorld(BlockSecurity imb, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        TileSecurity sp = (TileSecurity)imb.getTileEntity(world, x, y, z);
        renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        ForgeDirection up = sp.getUp();
        this.preRenderInWorld(imb, world, x, y, z, renderer);
        boolean result = renderer.renderStandardBlock((Block)imb, x, y, z);
        int b = world.getLightBrightnessForSkyBlocks(x + up.offsetX, y + up.offsetY, z + up.offsetZ, 0);
        if (sp.isActive()) {
            b = 0xF000F0;
        }
        Tessellator.instance.setBrightness(b);
        Tessellator.instance.setColorOpaque_I(0xFFFFFF);
        renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        Tessellator.instance.setColorOpaque_I(sp.getColor().whiteVariant);
        IIcon ico = sp.isActive() ? ExtraBlockTextures.BlockMESecurityOn_Light.getIcon() : ExtraBlockTextures.MEChest.getIcon();
        this.renderFace(x, y, z, imb, ico, renderer, up);
        if (sp.isActive()) {
            Tessellator.instance.setColorOpaque_I(sp.getColor().mediumVariant);
            ico = sp.isActive() ? ExtraBlockTextures.BlockMESecurityOn_Medium.getIcon() : ExtraBlockTextures.MEChest.getIcon();
            this.renderFace(x, y, z, imb, ico, renderer, up);
            Tessellator.instance.setColorOpaque_I(sp.getColor().blackVariant);
            ico = sp.isActive() ? ExtraBlockTextures.BlockMESecurityOn_Dark.getIcon() : ExtraBlockTextures.MEChest.getIcon();
            this.renderFace(x, y, z, imb, ico, renderer, up);
        }
        renderer.overrideBlockTexture = null;
        this.postRenderInWorld(renderer);
        return result;
    }
}

