/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.core.AELog;
import appeng.tile.AEBaseTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TESRWrapper
extends TileEntitySpecialRenderer {
    private final RenderBlocks renderBlocksInstance = new RenderBlocks();
    private final BaseBlockRender blkRender;
    private final double maxDistance;

    public TESRWrapper(BaseBlockRender render) {
        this.blkRender = render;
        this.maxDistance = this.blkRender.getTesrRenderDistance();
    }

    public final void renderTileEntityAt(TileEntity te, double x, double y, double z, float f) {
        Block b;
        if (te instanceof AEBaseTile && (b = te.getBlockType()) instanceof AEBaseBlock && ((AEBaseTile)te).requiresTESR()) {
            if (Math.abs(x) > this.maxDistance || Math.abs(y) > this.maxDistance || Math.abs(z) > this.maxDistance) {
                return;
            }
            Tessellator tess = Tessellator.instance;
            try {
                GL11.glPushMatrix();
                this.renderBlocksInstance.blockAccess = te.getWorldObj();
                this.blkRender.renderTile((AEBaseBlock)b, (AEBaseTile)te, tess, x, y, z, f, this.renderBlocksInstance);
                GL11.glPopMatrix();
            }
            catch (Throwable t) {
                AELog.error("Hi, Looks like there was a crash while rendering something...", new Object[0]);
                t.printStackTrace();
                AELog.error("MC will now crash ( probably )!", new Object[0]);
                throw new IllegalStateException(t);
            }
        }
    }
}

