/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.solids;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseBlock;
import appeng.core.features.AEFeature;
import appeng.core.worlddata.WorldData;
import appeng.helpers.LocationRotation;
import appeng.helpers.NullRotation;
import appeng.util.Platform;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class BlockSkyStone
extends AEBaseBlock
implements IOrientableBlock {
    private static final float BLOCK_RESISTANCE = 150.0f;
    private static final double BREAK_SPEAK_SCALAR = 0.1;
    private static final double BREAK_SPEAK_THRESHOLD = 7.0;
    @SideOnly(value=Side.CLIENT)
    private IIcon block;
    @SideOnly(value=Side.CLIENT)
    private IIcon brick;
    @SideOnly(value=Side.CLIENT)
    private IIcon smallBrick;

    public BlockSkyStone() {
        super(Material.rock);
        this.setHardness(50.0f);
        this.hasSubtypes = true;
        this.blockResistance = 150.0f;
        this.setHarvestLevel("pickaxe", 3, 0);
        this.setFeature(EnumSet.of(AEFeature.Core));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void breakFaster(PlayerEvent.BreakSpeed event) {
        if (event.block == this && event.entityPlayer != null) {
            ItemStack is = event.entityPlayer.inventory.getCurrentItem();
            int level = -1;
            if (is != null && is.getItem() != null) {
                level = is.getItem().getHarvestLevel(is, "pickaxe");
            }
            if (event.metadata > 0 || level >= 3 || (double)event.originalSpeed > 7.0) {
                event.newSpeed = (float)((double)event.newSpeed / 0.1);
            }
        }
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ItemStack is = super.getPickBlock(target, world, x, y, z, player);
        is.setItemDamage(world.getBlockMetadata(x, y, z));
        return is;
    }

    public void onBlockAdded(World w, int x, int y, int z) {
        super.onBlockAdded(w, x, y, z);
        if (Platform.isServer()) {
            WorldData.instance().compassData().service().updateArea(w, x, y, z);
        }
    }

    @Override
    public boolean usesMetadata() {
        return false;
    }

    @Override
    public IOrientable getOrientable(IBlockAccess w, int x, int y, int z) {
        if (w.getBlockMetadata(x, y, z) == 0) {
            return new LocationRotation(w, x, y, z);
        }
        return new NullRotation();
    }

    @Override
    public String getUnlocalizedName(ItemStack is) {
        if (is.getItemDamage() == 1) {
            return this.getUnlocalizedName() + ".Block";
        }
        if (is.getItemDamage() == 2) {
            return this.getUnlocalizedName() + ".Brick";
        }
        if (is.getItemDamage() == 3) {
            return this.getUnlocalizedName() + ".SmallBrick";
        }
        return this.getUnlocalizedName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister ir) {
        super.registerBlockIcons(ir);
        this.block = ir.registerIcon(this.getTextureName() + ".Block");
        this.brick = ir.registerIcon(this.getTextureName() + ".Brick");
        this.smallBrick = ir.registerIcon(this.getTextureName() + ".SmallBrick");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int direction, int metadata) {
        if (metadata == 1) {
            return this.block;
        }
        if (metadata == 2) {
            return this.brick;
        }
        if (metadata == 3) {
            return this.smallBrick;
        }
        return super.getIcon(direction, metadata);
    }

    @Override
    public void setRenderStateByMeta(int metadata) {
        this.getRendererInstance().setTemporaryRenderIcon(this.getIcon(0, metadata));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
        super.getCheckedSubBlocks(item, tabs, itemStacks);
        itemStacks.add(new ItemStack(item, 1, 1));
        itemStacks.add(new ItemStack(item, 1, 2));
        itemStacks.add(new ItemStack(item, 1, 3));
    }

    public void breakBlock(World w, int x, int y, int z, Block b, int metadata) {
        super.breakBlock(w, x, y, z, b, metadata);
        if (Platform.isServer()) {
            WorldData.instance().compassData().service().updateArea(w, x, y, z);
        }
    }
}

