/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 AlgorithmX2
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

package appeng.api.definitions;


import appeng.api.util.AEColoredItemDefinition;


/**
 * A list of all items in AE
 */
public interface IItems
{
	IItemDefinition certusQuartzAxe();

	IItemDefinition certusQuartzHoe();

	IItemDefinition certusQuartzShovel();

	IItemDefinition certusQuartzPick();

	IItemDefinition certusQuartzSword();

	IItemDefinition certusQuartzWrench();

	IItemDefinition certusQuartzKnife();

	IItemDefinition netherQuartzAxe();

	IItemDefinition netherQuartzHoe();

	IItemDefinition netherQuartzShovel();

	IItemDefinition netherQuartzPick();

	IItemDefinition netherQuartzSword();

	IItemDefinition netherQuartzWrench();

	IItemDefinition netherQuartzKnife();

	IItemDefinition entropyManipulator();

	IItemDefinition wirelessTerminal();

	IItemDefinition biometricCard();

	IItemDefinition chargedStaff();

	IItemDefinition massCannon();

	IItemDefinition memoryCard();

	IItemDefinition networkTool();

	IItemDefinition portableCell();

	IItemDefinition cellCreative();

	IItemDefinition viewCell();

	IItemDefinition cell1k();

	IItemDefinition cell4k();

	IItemDefinition cell16k();

	IItemDefinition cell64k();

	IItemDefinition spatialCell2();

	IItemDefinition spatialCell16();

	IItemDefinition spatialCell128();

	IItemDefinition facade();

	IItemDefinition crystalSeed();

	// rv1
	IItemDefinition encodedPattern();

	IItemDefinition colorApplicator();

	AEColoredItemDefinition coloredPaintBall();

	AEColoredItemDefinition coloredLumenPaintBall();
}
