/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.misc;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Upgrades;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.ITileDefinition;
import appeng.api.features.IInscriberRecipe;
import appeng.api.features.InscriberProcessType;
import appeng.api.implementations.IUpgradeableHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.core.features.registries.entries.InscriberRecipe;
import appeng.core.settings.TickRates;
import appeng.me.GridAccessException;
import appeng.parts.automation.DefinitionUpgradeInventory;
import appeng.parts.automation.UpgradeInventory;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.WrapperInventoryRange;
import appeng.util.item.AEItemStack;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileInscriber
extends AENetworkPowerTile
implements IGridTickable,
IUpgradeableHost,
IConfigManagerHost {
    public final int maxProcessingTime = 100;
    final int[] top = new int[]{0};
    final int[] bottom = new int[]{1};
    final int[] sides = new int[]{2, 3};
    final AppEngInternalInventory inv = new AppEngInternalInventory(this, 4);
    private final IConfigManager settings;
    private final UpgradeInventory upgrades;
    public int processingTime = 0;
    public boolean smash;
    public int finalStep;
    public long clientStart;

    public TileInscriber() {
        this.gridProxy.setValidSides(EnumSet.noneOf(ForgeDirection.class));
        this.internalMaxPower = 1500.0;
        this.gridProxy.setIdlePowerUsage(0.0);
        this.settings = new ConfigManager(this);
        ITileDefinition inscriberDefinition = AEApi.instance().definitions().blocks().inscriber();
        this.upgrades = new DefinitionUpgradeInventory(inscriberDefinition, this, this.getUpgradeSlots());
    }

    protected int getUpgradeSlots() {
        return 3;
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_TileInscriber(NBTTagCompound data) {
        this.inv.writeToNBT(data, "inscriberInv");
        this.upgrades.writeToNBT(data, "upgrades");
        this.settings.writeToNBT(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_TileInscriber(NBTTagCompound data) {
        this.inv.readFromNBT(data, "inscriberInv");
        this.upgrades.readFromNBT(data, "upgrades");
        this.settings.readFromNBT(data);
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream_TileInscriber(ByteBuf data) throws IOException {
        boolean newSmash;
        byte slot = data.readByte();
        boolean oldSmash = this.smash;
        boolean bl = newSmash = (slot & 0x40) == 64;
        if (oldSmash != newSmash && newSmash) {
            this.smash = true;
            this.clientStart = System.currentTimeMillis();
        }
        for (int num = 0; num < this.inv.func_70302_i_(); ++num) {
            if ((slot & 1 << num) > 0) {
                this.inv.func_70299_a(num, AEItemStack.loadItemStackFromPacket(data).getItemStack());
                continue;
            }
            this.inv.func_70299_a(num, null);
        }
        return false;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream_TileInscriber(ByteBuf data) throws IOException {
        int num;
        int slot = this.smash ? 64 : 0;
        for (num = 0; num < this.inv.func_70302_i_(); ++num) {
            if (this.inv.func_70301_a(num) == null) continue;
            slot |= 1 << num;
        }
        data.writeByte(slot);
        for (num = 0; num < this.inv.func_70302_i_(); ++num) {
            if ((slot & 1 << num) <= 0) continue;
            AEItemStack st = AEItemStack.create(this.inv.func_70301_a(num));
            st.writeToPacket(data);
        }
    }

    @Override
    public void setOrientation(ForgeDirection inForward, ForgeDirection inUp) {
        super.setOrientation(inForward, inUp);
        this.gridProxy.setValidSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
        this.setPowerSides(EnumSet.complementOf(EnumSet.of(this.getForward())));
    }

    @Override
    public void getDrops(World w, int x, int y, int z, ArrayList<ItemStack> drops) {
        super.getDrops(w, x, y, z, drops);
        for (int h = 0; h < this.upgrades.func_70302_i_(); ++h) {
            ItemStack is = this.upgrades.func_70301_a(h);
            if (is == null) continue;
            drops.add(is);
        }
    }

    @Override
    public boolean requiresTESR() {
        return true;
    }

    @Override
    public IInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (this.smash) {
            return false;
        }
        if (i == 0 || i == 1) {
            if (AEApi.instance().definitions().materials().namePress().isSameAs(itemstack)) {
                return true;
            }
            for (ItemStack optionals : AEApi.instance().registries().inscriber().getOptionals()) {
                if (!Platform.isSameItemPrecise(optionals, itemstack)) continue;
                return true;
            }
        }
        return i == 2;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        try {
            if (mc != InvOperation.markDirty) {
                if (slot != 3) {
                    this.processingTime = 0;
                }
                if (!this.smash) {
                    this.markForUpdate();
                }
                this.gridProxy.getTick().wakeDevice(this.gridProxy.getNode());
            }
        }
        catch (GridAccessException e) {
            // empty catch block
        }
    }

    @Override
    public boolean func_102008_b(int slotIndex, ItemStack extractedItem, int side) {
        if (this.smash) {
            return false;
        }
        return slotIndex == 0 || slotIndex == 1 || slotIndex == 3;
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection d) {
        if (d == ForgeDirection.UP) {
            return this.top;
        }
        if (d == ForgeDirection.DOWN) {
            return this.bottom;
        }
        return this.sides;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Inscriber.min, TickRates.Inscriber.max, !this.hasWork(), false);
    }

    private boolean hasWork() {
        if (this.getTask() != null) {
            return true;
        }
        this.processingTime = 0;
        return this.smash;
    }

    @Nullable
    public IInscriberRecipe getTask() {
        ItemStack plateA = this.func_70301_a(0);
        ItemStack plateB = this.func_70301_a(1);
        ItemStack renamedItem = this.func_70301_a(2);
        if (plateA != null && plateA.field_77994_a > 1) {
            return null;
        }
        if (plateB != null && plateB.field_77994_a > 1) {
            return null;
        }
        if (renamedItem != null && renamedItem.field_77994_a > 1) {
            return null;
        }
        IItemDefinition namePress = AEApi.instance().definitions().materials().namePress();
        boolean isNameA = namePress.isSameAs(plateA);
        boolean isNameB = namePress.isSameAs(plateB);
        if ((isNameA || isNameB) && (isNameA || plateA == null) && (isNameB || plateB == null) && renamedItem != null) {
            NBTTagCompound tag;
            String name = "";
            if (plateA != null) {
                tag = Platform.openNbtData(plateA);
                name = name + tag.func_74779_i("InscribeName");
            }
            if (plateB != null) {
                tag = Platform.openNbtData(plateB);
                if (name.length() > 0) {
                    name = name + " ";
                }
                name = name + tag.func_74779_i("InscribeName");
            }
            ItemStack startingItem = renamedItem.func_77946_l();
            renamedItem = renamedItem.func_77946_l();
            NBTTagCompound tag2 = Platform.openNbtData(renamedItem);
            NBTTagCompound display = tag2.func_74775_l("display");
            tag2.func_74782_a("display", (NBTBase)display);
            if (name.length() > 0) {
                display.func_74778_a("Name", name);
            } else {
                display.func_82580_o("Name");
            }
            ArrayList inputs = Lists.newArrayList((Object[])new ItemStack[]{startingItem});
            InscriberProcessType type = InscriberProcessType.Inscribe;
            return new InscriberRecipe(inputs, renamedItem, plateA, plateB, type);
        }
        for (IInscriberRecipe recipe : AEApi.instance().registries().inscriber().getRecipes()) {
            boolean matchB;
            boolean matchA;
            boolean bl = plateA == null && !recipe.getTopOptional().isPresent() || Platform.isSameItemPrecise(plateA, (ItemStack)recipe.getTopOptional().orNull()) && (plateB == null && !recipe.getBottomOptional().isPresent()) | Platform.isSameItemPrecise(plateB, (ItemStack)recipe.getBottomOptional().orNull()) ? true : (matchA = false);
            boolean bl2 = plateB == null && !recipe.getTopOptional().isPresent() || Platform.isSameItemPrecise(plateB, (ItemStack)recipe.getTopOptional().orNull()) && (plateA == null && !recipe.getBottomOptional().isPresent()) | Platform.isSameItemPrecise(plateA, (ItemStack)recipe.getBottomOptional().orNull()) ? true : (matchB = false);
            if (!matchA && !matchB) continue;
            for (ItemStack option : recipe.getInputs()) {
                if (!Platform.isSameItemPrecise(option, this.func_70301_a(2))) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.smash) {
            ++this.finalStep;
            if (this.finalStep == 8) {
                IInscriberRecipe out = this.getTask();
                if (out != null) {
                    ItemStack outputCopy = out.getOutput().func_77946_l();
                    InventoryAdaptor ad = InventoryAdaptor.getAdaptor(new WrapperInventoryRange(this.inv, 3, 1, true), ForgeDirection.UNKNOWN);
                    if (ad.addItems(outputCopy) == null) {
                        this.processingTime = 0;
                        if (out.getProcessType() == InscriberProcessType.Press) {
                            this.func_70299_a(0, null);
                            this.func_70299_a(1, null);
                        }
                        this.func_70299_a(2, null);
                    }
                }
                this.func_70296_d();
            } else if (this.finalStep == 16) {
                this.finalStep = 0;
                this.smash = false;
                this.markForUpdate();
            }
        } else {
            try {
                IEnergyGrid eg = this.gridProxy.getEnergy();
                IEnergySource src = this;
                int speedFactor = 1 + this.upgrades.getInstalledUpgrades(Upgrades.SPEED);
                int powerConsumption = 10 * speedFactor;
                double powerThreshold = (double)powerConsumption - 0.01;
                double powerReq = this.extractAEPower(powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                if (powerReq <= powerThreshold) {
                    src = eg;
                    powerReq = eg.extractAEPower((double)powerConsumption, Actionable.SIMULATE, PowerMultiplier.CONFIG);
                }
                if (powerReq > powerThreshold) {
                    src.extractAEPower(powerConsumption, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.processingTime = this.processingTime == 0 ? (this.processingTime += speedFactor) : (this.processingTime += TicksSinceLastCall * speedFactor);
                }
            }
            catch (GridAccessException e) {
                // empty catch block
            }
            if (this.processingTime > this.maxProcessingTime) {
                this.processingTime = this.maxProcessingTime;
                IInscriberRecipe out = this.getTask();
                if (out != null) {
                    ItemStack outputCopy = out.getOutput().func_77946_l();
                    InventoryAdaptor ad = InventoryAdaptor.getAdaptor(new WrapperInventoryRange(this.inv, 3, 1, true), ForgeDirection.UNKNOWN);
                    if (ad.simulateAdd(outputCopy) == null) {
                        this.smash = true;
                        this.finalStep = 0;
                        this.markForUpdate();
                    }
                }
            }
        }
        return this.hasWork() ? TickRateModulation.URGENT : TickRateModulation.SLEEP;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.settings;
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("inv")) {
            return this.inv;
        }
        if (name.equals("upgrades")) {
            return this.upgrades;
        }
        return null;
    }

    @Override
    public int getInstalledUpgrades(Upgrades u) {
        return this.upgrades.getInstalledUpgrades(u);
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
    }
}

