/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.implementations.items.IGrowableCrystal;
import appeng.api.implementations.tiles.ICrystalGrowthAccelerator;
import appeng.client.EffectType;
import appeng.core.AEConfig;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.util.Platform;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public final class EntityGrowingCrystal
extends EntityItem {
    private int progress_1000 = 0;

    public EntityGrowingCrystal(World w) {
        super(w);
    }

    public EntityGrowingCrystal(World w, double x, double y, double z, ItemStack is) {
        super(w, x, y, z, is);
    }

    public void func_70071_h_() {
        ItemStack is;
        Item gc;
        super.func_70071_h_();
        if (!AEConfig.instance.isFeatureEnabled(AEFeature.inWorldPurification)) {
            return;
        }
        if (this.field_70292_b > 600) {
            this.field_70292_b = 100;
        }
        if ((gc = (is = this.func_92059_d()).func_77973_b()) instanceof IGrowableCrystal) {
            int j = MathHelper.func_76128_c((double)this.field_70165_t);
            int i = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            Block blk = this.field_70170_p.func_147439_a(j, i, k);
            Material mat = blk.func_149688_o();
            IGrowableCrystal cry = (IGrowableCrystal)is.func_77973_b();
            float multiplier = cry.getMultiplier(blk, mat);
            int speed = (int)Math.max(1.0f, (float)this.getSpeed(j, i, k) * multiplier);
            boolean isClient = Platform.isClient();
            this.progress_1000 = mat.func_76224_d() ? (isClient ? ++this.progress_1000 : (this.progress_1000 += speed)) : 0;
            if (isClient) {
                int len = 40;
                if (speed > 2) {
                    len = 20;
                }
                if (speed > 90) {
                    len = 15;
                }
                if (speed > 150) {
                    len = 10;
                }
                if (speed > 240) {
                    len = 7;
                }
                if (speed > 360) {
                    len = 3;
                }
                if (speed > 500) {
                    len = 1;
                }
                if (this.progress_1000 >= len) {
                    this.progress_1000 = 0;
                    CommonHelper.proxy.spawnEffect(EffectType.Vibrant, this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v, null);
                }
            } else if (this.progress_1000 > 1000) {
                this.progress_1000 -= 1000;
                this.func_92058_a(cry.triggerGrowth(is));
            }
        }
    }

    private int getSpeed(int x, int y, int z) {
        int per = 80;
        float mul = 0.3f;
        int qty = 0;
        if (this.isAccelerated(x + 1, y, z)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x, y + 1, z)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x, y, z + 1)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x - 1, y, z)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x, y - 1, z)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        if (this.isAccelerated(x, y, z - 1)) {
            qty = (int)((float)qty + (80.0f + (float)qty * 0.3f));
        }
        return qty;
    }

    private boolean isAccelerated(int x, int y, int z) {
        TileEntity te = this.field_70170_p.func_147438_o(x, y, z);
        return te instanceof ICrystalGrowthAccelerator && ((ICrystalGrowthAccelerator)te).isPowered();
    }
}

