/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.me.GridAccessException;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PartP2PRedstone
extends PartP2PTunnel<PartP2PRedstone> {
    int power;
    boolean recursive = false;

    public PartP2PRedstone(ItemStack is) {
        super(is);
    }

    @MENetworkEventSubscribe
    public void changeStateA(MENetworkBootingStatusChange bs) {
        this.setNetworkReady();
    }

    public void setNetworkReady() {
        PartP2PRedstone in;
        if (this.output && (in = (PartP2PRedstone)this.getInput()) != null) {
            this.putInput(in.power);
        }
    }

    protected void putInput(Object o) {
        int newPower;
        if (this.recursive) {
            return;
        }
        this.recursive = true;
        if (this.output && this.proxy.isActive() && this.power != (newPower = ((Integer)o).intValue())) {
            this.power = newPower;
            this.notifyNeighbors();
        }
        this.recursive = false;
    }

    public void notifyNeighbors() {
        World worldObj = this.tile.func_145831_w();
        int xCoord = this.tile.field_145851_c;
        int yCoord = this.tile.field_145848_d;
        int zCoord = this.tile.field_145849_e;
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord, yCoord, zCoord);
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord - 1, yCoord, zCoord);
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord, yCoord - 1, zCoord);
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord, yCoord, zCoord - 1);
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord, yCoord, zCoord + 1);
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord, yCoord + 1, zCoord);
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord + 1, yCoord, zCoord);
    }

    @MENetworkEventSubscribe
    public void changeStateB(MENetworkChannelsChanged bs) {
        this.setNetworkReady();
    }

    @MENetworkEventSubscribe
    public void changeStateC(MENetworkPowerStatusChange bs) {
        this.setNetworkReady();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Blocks.field_150451_bX.func_149733_h(0);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.power = tag.func_74762_e("power");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("power", this.power);
    }

    @Override
    public void onTunnelNetworkChange() {
        this.setNetworkReady();
    }

    public float getPowerDrainPerTick() {
        return 0.5f;
    }

    @Override
    public void onNeighborChanged() {
        if (!this.output) {
            int x = this.tile.field_145851_c + this.side.offsetX;
            int y = this.tile.field_145848_d + this.side.offsetY;
            int z = this.tile.field_145849_e + this.side.offsetZ;
            Block b = this.tile.func_145831_w().func_147439_a(x, y, z);
            if (b != null && !this.output) {
                int srcSide = this.side.ordinal();
                if (b instanceof BlockRedstoneWire) {
                    srcSide = 1;
                }
                this.power = b.func_149748_c((IBlockAccess)this.tile.func_145831_w(), x, y, z, srcSide);
                this.power = Math.max(this.power, b.func_149709_b((IBlockAccess)this.tile.func_145831_w(), x, y, z, srcSide));
                this.sendToOutput(this.power);
            } else {
                this.sendToOutput(0);
            }
        }
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public int isProvidingStrongPower() {
        return this.output ? this.power : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.output ? this.power : 0;
    }

    private void sendToOutput(int power) {
        try {
            for (PartP2PRedstone rs : this.getOutputs()) {
                rs.putInput(power);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }
}

