/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.util.DimensionalCoord;
import appeng.api.util.WorldCoord;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.MBCalculator;
import appeng.me.cluster.implementations.SpatialPylonCluster;
import appeng.tile.spatial.TileSpatialPylon;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class SpatialPylonCalculator
extends MBCalculator {
    private final TileSpatialPylon tqb;

    public SpatialPylonCalculator(IAEMultiBlock t) {
        super(t);
        this.tqb = (TileSpatialPylon)t;
    }

    @Override
    public boolean checkMultiblockScale(WorldCoord min, WorldCoord max) {
        return min.x == max.x && min.y == max.y && min.z != max.z || min.x == max.x && min.y != max.y && min.z == max.z || min.x != max.x && min.y == max.y && min.z == max.z;
    }

    @Override
    public IAECluster createCluster(World w, WorldCoord min, WorldCoord max) {
        return new SpatialPylonCluster(new DimensionalCoord(w, min.x, min.y, min.z), new DimensionalCoord(w, max.x, max.y, max.z));
    }

    @Override
    public boolean verifyInternalStructure(World w, WorldCoord min, WorldCoord max) {
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    IAEMultiBlock te = (IAEMultiBlock)w.func_147438_o(x, y, z);
                    if (te.isValid()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void disconnect() {
        this.tqb.disconnect(true);
    }

    @Override
    public void updateTiles(IAECluster cl, World w, WorldCoord min, WorldCoord max) {
        SpatialPylonCluster c = (SpatialPylonCluster)cl;
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    TileSpatialPylon te = (TileSpatialPylon)w.func_147438_o(x, y, z);
                    te.updateStatus(c);
                    c.line.add(te);
                }
            }
        }
    }

    @Override
    public boolean isValidTile(TileEntity te) {
        return te instanceof TileSpatialPylon;
    }
}

