/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class WrapperInventoryRange
implements IInventory {
    private final IInventory src;
    protected boolean ignoreValidItems = false;
    int[] slots;

    public WrapperInventoryRange(IInventory a, int[] s, boolean ignoreValid) {
        this.src = a;
        this.slots = s;
        if (this.slots == null) {
            this.slots = new int[0];
        }
        this.ignoreValidItems = ignoreValid;
    }

    public WrapperInventoryRange(IInventory a, int _min, int _size, boolean ignoreValid) {
        this.src = a;
        this.slots = new int[_size];
        for (int x = 0; x < _size; ++x) {
            this.slots[x] = _min + x;
        }
        this.ignoreValidItems = ignoreValid;
    }

    public static String concatLines(int[] s, String separator) {
        if (s.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (int value : s) {
                if (sb.length() > 0) {
                    sb.append(separator);
                }
                sb.append(value);
            }
            return sb.toString();
        }
        return "";
    }

    public int getSizeInventory() {
        return this.slots.length;
    }

    public ItemStack getStackInSlot(int var1) {
        return this.src.getStackInSlot(this.slots[var1]);
    }

    public ItemStack decrStackSize(int var1, int var2) {
        return this.src.decrStackSize(this.slots[var1], var2);
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return this.src.getStackInSlotOnClosing(this.slots[var1]);
    }

    public void setInventorySlotContents(int var1, ItemStack var2) {
        this.src.setInventorySlotContents(this.slots[var1], var2);
    }

    public String getInventoryName() {
        return this.src.getInventoryName();
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return this.src.getInventoryStackLimit();
    }

    public void markDirty() {
        this.src.markDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return this.src.isUseableByPlayer(var1);
    }

    public void openInventory() {
        this.src.openInventory();
    }

    public void closeInventory() {
        this.src.closeInventory();
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        if (this.ignoreValidItems) {
            return true;
        }
        return this.src.isItemValidForSlot(this.slots[i], itemstack);
    }
}

