/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RecipeError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IIngredient;
import appeng.recipes.RecipeHandler;
import appeng.recipes.handlers.IWebsiteSerializer;
import appeng.util.Platform;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class Pulverizer
implements ICraftHandler,
IWebsiteSerializer {
    IIngredient pro_input;
    IIngredient[] pro_output;

    @Override
    public void setup(List<List<IIngredient>> input, List<List<IIngredient>> output) throws RecipeError {
        if (input.size() == 1 && output.size() == 1) {
            int outs = output.get(0).size();
            if (input.get(0).size() == 1 && outs == 1) {
                this.pro_input = input.get(0).get(0);
                this.pro_output = output.get(0).toArray(new IIngredient[outs]);
                return;
            }
        }
        throw new RecipeError("Grind must have a single input, and single output.");
    }

    @Override
    public void register() throws RegistrationError, MissingIngredientError {
        NBTTagCompound toSend = new NBTTagCompound();
        toSend.setInteger("energy", 800);
        toSend.setTag("primaryOutput", (NBTBase)new NBTTagCompound());
        this.pro_output[0].getItemStack().writeToNBT(toSend.getCompoundTag("primaryOutput"));
        for (ItemStack is : this.pro_input.getItemStackSet()) {
            toSend.setTag("input", (NBTBase)new NBTTagCompound());
            is.writeToNBT(toSend.getCompoundTag("input"));
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"PulverizerRecipe", (NBTTagCompound)toSend);
        }
    }

    @Override
    public String getPattern(RecipeHandler h) {
        return null;
    }

    @Override
    public boolean canCraft(ItemStack output) throws RegistrationError, MissingIngredientError {
        return Platform.isSameItemPrecise(this.pro_output[0].getItemStack(), output);
    }
}

