/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Upgrades;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.me.GridAccessException;
import appeng.parts.automation.PartUpgradeable;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class PartSharedItemBus
extends PartUpgradeable
implements IGridTickable {
    final AppEngInternalAEInventory config = new AppEngInternalAEInventory(this, 9);
    int adaptorHash = 0;
    InventoryAdaptor adaptor;
    boolean lastRedstone = false;

    public PartSharedItemBus(ItemStack is) {
        super(is);
    }

    protected int availableSlots() {
        return Math.min(1 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 4, this.config.getSizeInventory());
    }

    @Override
    public void upgradesChanged() {
        this.updateState();
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.config.readFromNBT(extra, "config");
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.config.writeToNBT(extra, "config");
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.config;
        }
        return super.getInventoryByName(name);
    }

    private void updateState() {
        try {
            if (!this.isSleeping()) {
                this.proxy.getTick().wakeDevice(this.proxy.getNode());
            } else {
                this.proxy.getTick().sleepDevice(this.proxy.getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    InventoryAdaptor getHandler() {
        TileEntity self = this.getHost().getTile();
        TileEntity target = this.getTileEntity(self, self.xCoord + this.side.offsetX, self.yCoord + this.side.offsetY, self.zCoord + this.side.offsetZ);
        int newAdaptorHash = Platform.generateTileHash(target);
        if (this.adaptorHash == newAdaptorHash && newAdaptorHash != 0) {
            return this.adaptor;
        }
        this.adaptorHash = newAdaptorHash;
        this.adaptor = InventoryAdaptor.getAdaptor(target, this.side.getOpposite());
        return this.adaptor;
    }

    private TileEntity getTileEntity(TileEntity self, int x, int y, int z) {
        World w = self.getWorldObj();
        if (w.getChunkProvider().chunkExists(x >> 4, z >> 4)) {
            return w.getTileEntity(x, y, z);
        }
        return null;
    }

    @Override
    public void onNeighborChanged() {
        this.updateState();
        if (this.lastRedstone != this.host.hasRedstone(this.side)) {
            boolean bl = this.lastRedstone = !this.lastRedstone;
            if (this.lastRedstone && this.getRSMode() == RedstoneMode.SIGNAL_PULSE) {
                this.doBusWork();
            }
        }
    }

    abstract TickRateModulation doBusWork();
}

