/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMatterCannon;
import appeng.hooks.DispenserMatterCannon;
import appeng.hooks.TickHandler;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.items.misc.ItemPaintBall;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.me.storage.CellInventoryHandler;
import appeng.tile.misc.TilePaint;
import appeng.util.Platform;
import com.google.common.base.Optional;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ToolMassCannon
extends AEBasePoweredItem
implements IStorageCell {
    public ToolMassCannon() {
        super(AEConfig.instance.matterCannonBattery, (Optional<String>)Optional.absent());
        this.setFeature(EnumSet.of(AEFeature.MatterCannon, AEFeature.PoweredTools));
    }

    @Override
    public void postInit() {
        super.postInit();
        BlockDispenser.dispenseBehaviorRegistry.putObject((Object)this, (Object)new DispenserMatterCannon());
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        ICellInventory cd;
        super.addCheckedInformation(stack, player, lines, displayMoreInfo);
        IMEInventoryHandler cdi = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.ITEMS);
        if (cdi instanceof CellInventoryHandler && (cd = ((ICellInventoryHandler)cdi).getCellInv()) != null) {
            lines.add(cd.getUsedBytes() + " " + GuiText.Of.getLocal() + ' ' + cd.getTotalBytes() + ' ' + GuiText.BytesUsed.getLocal());
            lines.add(cd.getStoredItemTypes() + " " + GuiText.Of.getLocal() + ' ' + cd.getTotalItemTypes() + ' ' + GuiText.Types.getLocal());
        }
    }

    public ItemStack onItemRightClick(ItemStack item, World w, EntityPlayer p) {
        if (this.getAECurrentPower(item) > 1600.0) {
            IMEInventoryHandler inv;
            int shots = 1;
            CellUpgrades cu = (CellUpgrades)this.getUpgradesInventory(item);
            if (cu != null) {
                shots += cu.getInstalledUpgrades(Upgrades.SPEED);
            }
            if ((inv = AEApi.instance().registries().cell().getCellInventory(item, null, StorageChannel.ITEMS)) != null) {
                IItemList<IAEItemStack> itemList = inv.getAvailableItems(AEApi.instance().storage().createItemList());
                IAEItemStack aeAmmo = itemList.getFirstItem();
                if (aeAmmo instanceof IAEItemStack) {
                    shots = Math.min(shots, (int)aeAmmo.getStackSize());
                    for (int sh = 0; sh < shots; ++sh) {
                        this.extractAEPower(item, 1600.0);
                        if (Platform.isClient()) {
                            return item;
                        }
                        aeAmmo.setStackSize(1L);
                        ItemStack ammo = aeAmmo.getItemStack();
                        if (ammo == null) {
                            return item;
                        }
                        ammo.stackSize = 1;
                        if ((aeAmmo = inv.extractItems(aeAmmo, Actionable.MODULATE, new PlayerSource(p, null))) == null) {
                            return item;
                        }
                        float f = 1.0f;
                        float f1 = p.prevRotationPitch + (p.rotationPitch - p.prevRotationPitch) * f;
                        float f2 = p.prevRotationYaw + (p.rotationYaw - p.prevRotationYaw) * f;
                        double d0 = p.prevPosX + (p.posX - p.prevPosX) * (double)f;
                        double d1 = p.prevPosY + (p.posY - p.prevPosY) * (double)f + 1.62 - (double)p.yOffset;
                        double d2 = p.prevPosZ + (p.posZ - p.prevPosZ) * (double)f;
                        Vec3 vec3 = Vec3.createVectorHelper((double)d0, (double)d1, (double)d2);
                        float f3 = MathHelper.cos((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
                        float f4 = MathHelper.sin((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
                        float f5 = -MathHelper.cos((float)(-f1 * ((float)Math.PI / 180)));
                        float f6 = MathHelper.sin((float)(-f1 * ((float)Math.PI / 180)));
                        float f7 = f4 * f5;
                        float f8 = f3 * f5;
                        double d3 = 32.0;
                        Vec3 vec31 = vec3.addVector((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
                        Vec3 direction = Vec3.createVectorHelper((double)((double)f7 * d3), (double)((double)f6 * d3), (double)((double)f8 * d3));
                        direction.normalize();
                        float penetration = AEApi.instance().registries().matterCannon().getPenetration(ammo);
                        if (penetration <= 0.0f) {
                            ItemStack type = aeAmmo.getItemStack();
                            if (type.getItem() instanceof ItemPaintBall) {
                                this.shootPaintBalls(type, w, p, vec3, vec31, direction, d0, d1, d2);
                            }
                            return item;
                        }
                        this.standardAmmo(penetration, w, p, vec3, vec31, direction, d0, d1, d2);
                    }
                } else {
                    if (Platform.isServer()) {
                        p.addChatMessage(PlayerMessages.AmmoDepleted.get());
                    }
                    return item;
                }
            }
        }
        return item;
    }

    private void shootPaintBalls(ItemStack type, World w, EntityPlayer p, Vec3 vec3, Vec3 vec31, Vec3 direction, double d0, double d1, double d2) {
        AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)Math.min(vec3.xCoord, vec31.xCoord), (double)Math.min(vec3.yCoord, vec31.yCoord), (double)Math.min(vec3.zCoord, vec31.zCoord), (double)Math.max(vec3.xCoord, vec31.xCoord), (double)Math.max(vec3.yCoord, vec31.yCoord), (double)Math.max(vec3.zCoord, vec31.zCoord)).expand(16.0, 16.0, 16.0);
        Entity entity = null;
        List list = w.getEntitiesWithinAABBExcludingEntity((Entity)p, bb);
        double closest = 9999999.0;
        for (int l = 0; l < list.size(); ++l) {
            double nd;
            float f1;
            AxisAlignedBB boundingBox;
            MovingObjectPosition movingObjectPosition;
            Entity entity1 = (Entity)list.get(l);
            if (entity1.isDead || entity1 == p || entity1 instanceof EntityItem || !entity1.isEntityAlive() || entity1.riddenByEntity == p || (movingObjectPosition = (boundingBox = entity1.boundingBox.expand((double)(f1 = 0.3f), (double)f1, (double)f1)).calculateIntercept(vec3, vec31)) == null || !((nd = vec3.squareDistanceTo(movingObjectPosition.hitVec)) < closest)) continue;
            entity = entity1;
            closest = nd;
        }
        MovingObjectPosition pos = w.rayTraceBlocks(vec3, vec31, false);
        Vec3 vec = Vec3.createVectorHelper((double)d0, (double)d1, (double)d2);
        if (entity != null && pos != null && pos.hitVec.squareDistanceTo(vec) > closest) {
            pos = new MovingObjectPosition(entity);
        } else if (entity != null && pos == null) {
            pos = new MovingObjectPosition(entity);
        }
        try {
            CommonHelper.proxy.sendToAllNearExcept(null, d0, d1, d2, 128.0, w, new PacketMatterCannon(d0, d1, d2, (float)direction.xCoord, (float)direction.yCoord, (float)direction.zCoord, (byte)(pos == null ? 32.0 : pos.hitVec.squareDistanceTo(vec) + 1.0)));
        }
        catch (Exception err) {
            AELog.error(err);
        }
        if (pos != null && type != null && type.getItem() instanceof ItemPaintBall) {
            ItemPaintBall ipb = (ItemPaintBall)type.getItem();
            AEColor col = ipb.getColor(type);
            if (pos.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
                int id = pos.entityHit.getEntityId();
                TickHandler.PlayerColor marker = new TickHandler.PlayerColor(id, col, 600);
                TickHandler.INSTANCE.getPlayerColors().put(id, marker);
                if (pos.entityHit instanceof EntitySheep) {
                    EntitySheep sh = (EntitySheep)pos.entityHit;
                    sh.setFleeceColor(col.ordinal());
                }
                pos.entityHit.attackEntityFrom(DamageSource.causePlayerDamage((EntityPlayer)p), 0.0f);
                NetworkHandler.instance.sendToAll(marker.getPacket());
            } else if (pos.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
                TileEntity te;
                ForgeDirection side = ForgeDirection.getOrientation((int)pos.sideHit);
                int x = pos.blockX + side.offsetX;
                int y = pos.blockY + side.offsetY;
                int z = pos.blockZ + side.offsetZ;
                if (!Platform.hasPermissions(new DimensionalCoord(w, x, y, z), p)) {
                    return;
                }
                Block whatsThere = w.getBlock(x, y, z);
                if (whatsThere.isReplaceable((IBlockAccess)w, x, y, z) && w.isAirBlock(x, y, z)) {
                    for (Block paintBlock : AEApi.instance().definitions().blocks().paint().maybeBlock().asSet()) {
                        w.setBlock(x, y, z, paintBlock, 0, 3);
                    }
                }
                if ((te = w.getTileEntity(x, y, z)) instanceof TilePaint) {
                    pos.hitVec.xCoord -= (double)x;
                    pos.hitVec.yCoord -= (double)y;
                    pos.hitVec.zCoord -= (double)z;
                    ((TilePaint)te).addBlot(type, side.getOpposite(), pos.hitVec);
                }
            }
        }
    }

    private void standardAmmo(float penetration, World w, EntityPlayer p, Vec3 vec3, Vec3 vec31, Vec3 direction, double d0, double d1, double d2) {
        boolean hasDestroyedSomething = true;
        while (penetration > 0.0f && hasDestroyedSomething) {
            hasDestroyedSomething = false;
            AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)Math.min(vec3.xCoord, vec31.xCoord), (double)Math.min(vec3.yCoord, vec31.yCoord), (double)Math.min(vec3.zCoord, vec31.zCoord), (double)Math.max(vec3.xCoord, vec31.xCoord), (double)Math.max(vec3.yCoord, vec31.yCoord), (double)Math.max(vec3.zCoord, vec31.zCoord)).expand(16.0, 16.0, 16.0);
            Entity entity = null;
            List list = w.getEntitiesWithinAABBExcludingEntity((Entity)p, bb);
            double closest = 9999999.0;
            for (int l = 0; l < list.size(); ++l) {
                double nd;
                float f1;
                AxisAlignedBB boundingBox;
                MovingObjectPosition movingObjectPosition;
                Entity entity1 = (Entity)list.get(l);
                if (entity1.isDead || entity1 == p || entity1 instanceof EntityItem || !entity1.isEntityAlive() || entity1.riddenByEntity == p || (movingObjectPosition = (boundingBox = entity1.boundingBox.expand((double)(f1 = 0.3f), (double)f1, (double)f1)).calculateIntercept(vec3, vec31)) == null || !((nd = vec3.squareDistanceTo(movingObjectPosition.hitVec)) < closest)) continue;
                entity = entity1;
                closest = nd;
            }
            Vec3 vec = Vec3.createVectorHelper((double)d0, (double)d1, (double)d2);
            MovingObjectPosition pos = w.rayTraceBlocks(vec3, vec31, true);
            if (entity != null && pos != null && pos.hitVec.squareDistanceTo(vec) > closest) {
                pos = new MovingObjectPosition(entity);
            } else if (entity != null && pos == null) {
                pos = new MovingObjectPosition(entity);
            }
            try {
                CommonHelper.proxy.sendToAllNearExcept(null, d0, d1, d2, 128.0, w, new PacketMatterCannon(d0, d1, d2, (float)direction.xCoord, (float)direction.yCoord, (float)direction.zCoord, (byte)(pos == null ? 32.0 : pos.hitVec.squareDistanceTo(vec) + 1.0)));
            }
            catch (Exception err) {
                AELog.error(err);
            }
            if (pos == null) continue;
            DamageSource dmgSrc = DamageSource.causePlayerDamage((EntityPlayer)p);
            dmgSrc.damageType = "masscannon";
            if (pos.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY) {
                int dmg = (int)Math.ceil(penetration / 20.0f);
                if (pos.entityHit instanceof EntityLivingBase) {
                    EntityLivingBase el = (EntityLivingBase)pos.entityHit;
                    penetration -= (float)dmg;
                    el.knockBack((Entity)p, 0.0f, -direction.xCoord, -direction.zCoord);
                    el.attackEntityFrom(dmgSrc, (float)dmg);
                    if (el.isEntityAlive()) continue;
                    hasDestroyedSomething = true;
                    continue;
                }
                if (pos.entityHit instanceof EntityItem) {
                    hasDestroyedSomething = true;
                    pos.entityHit.setDead();
                    continue;
                }
                if (!pos.entityHit.attackEntityFrom(dmgSrc, (float)dmg)) continue;
                hasDestroyedSomething = true;
                continue;
            }
            if (pos.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) continue;
            if (!AEConfig.instance.isFeatureEnabled(AEFeature.MassCannonBlockDamage)) {
                penetration = 0.0f;
                continue;
            }
            Block b = w.getBlock(pos.blockX, pos.blockY, pos.blockZ);
            float hardness = b.getBlockHardness(w, pos.blockX, pos.blockY, pos.blockZ) * 9.0f;
            if (!((double)hardness >= 0.0) || !(penetration > hardness) || !Platform.hasPermissions(new DimensionalCoord(w, pos.blockX, pos.blockY, pos.blockZ), p)) continue;
            hasDestroyedSomething = true;
            penetration -= hardness;
            penetration = (float)((double)penetration * 0.6);
            w.func_147480_a(pos.blockX, pos.blockY, pos.blockZ, true);
        }
    }

    @Override
    public boolean isEditable(ItemStack is) {
        return true;
    }

    @Override
    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 4);
    }

    @Override
    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    @Override
    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData(is).getString("FuzzyMode");
        try {
            return FuzzyMode.valueOf(fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    @Override
    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData(is).setString("FuzzyMode", fzMode.name());
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return 512;
    }

    @Override
    public int BytePerType(ItemStack cell) {
        return 8;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return 8;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 1;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        float pen = AEApi.instance().registries().matterCannon().getPenetration(requestedAddition.getItemStack());
        if (pen > 0.0f) {
            return false;
        }
        return !(requestedAddition.getItem() instanceof ItemPaintBall);
    }

    @Override
    public boolean storableInStorageCell() {
        return true;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain() {
        return 0.5;
    }
}

