/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.config.SecurityPermissions;
import appeng.api.features.IPlayerRegistry;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.networking.security.ISecurityRegistry;
import appeng.client.render.items.ToolBiometricCardRender;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import com.mojang.authlib.GameProfile;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class ToolBiometricCard
extends AEBaseItem
implements IBiometricCard {
    public ToolBiometricCard() {
        this.setFeature(EnumSet.of(AEFeature.Security));
        this.setMaxStackSize(1);
        if (Platform.isClient()) {
            MinecraftForgeClient.registerItemRenderer((Item)this, (IItemRenderer)new ToolBiometricCardRender());
        }
    }

    public ItemStack onItemRightClick(ItemStack is, World w, EntityPlayer p) {
        if (p.isSneaking()) {
            this.encode(is, p);
            p.swingItem();
            return is;
        }
        return is;
    }

    public boolean itemInteractionForEntity(ItemStack is, EntityPlayer par2EntityPlayer, EntityLivingBase target) {
        if (target instanceof EntityPlayer && !par2EntityPlayer.isSneaking()) {
            if (par2EntityPlayer.capabilities.isCreativeMode) {
                is = par2EntityPlayer.getCurrentEquippedItem();
            }
            this.encode(is, (EntityPlayer)target);
            par2EntityPlayer.swingItem();
            return true;
        }
        return false;
    }

    public String getItemStackDisplayName(ItemStack is) {
        GameProfile username = this.getProfile(is);
        return username != null ? super.getItemStackDisplayName(is) + " - " + username.getName() : super.getItemStackDisplayName(is);
    }

    private void encode(ItemStack is, EntityPlayer p) {
        GameProfile username = this.getProfile(is);
        if (username != null && username.equals((Object)p.getGameProfile())) {
            this.setProfile(is, null);
        } else {
            this.setProfile(is, p.getGameProfile());
        }
    }

    @Override
    public void setProfile(ItemStack itemStack, GameProfile profile) {
        NBTTagCompound tag = Platform.openNbtData(itemStack);
        if (profile != null) {
            NBTTagCompound pNBT = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)pNBT, (GameProfile)profile);
            tag.setTag("profile", (NBTBase)pNBT);
        } else {
            tag.removeTag("profile");
        }
    }

    @Override
    public GameProfile getProfile(ItemStack is) {
        NBTTagCompound tag = Platform.openNbtData(is);
        if (tag.hasKey("profile")) {
            return NBTUtil.func_152459_a((NBTTagCompound)tag.getCompoundTag("profile"));
        }
        return null;
    }

    @Override
    public EnumSet<SecurityPermissions> getPermissions(ItemStack is) {
        NBTTagCompound tag = Platform.openNbtData(is);
        EnumSet<SecurityPermissions> result = EnumSet.noneOf(SecurityPermissions.class);
        for (SecurityPermissions sp : SecurityPermissions.values()) {
            if (!tag.getBoolean(sp.name())) continue;
            result.add(sp);
        }
        return result;
    }

    @Override
    public boolean hasPermission(ItemStack is, SecurityPermissions permission) {
        NBTTagCompound tag = Platform.openNbtData(is);
        return tag.getBoolean(permission.name());
    }

    @Override
    public void removePermission(ItemStack itemStack, SecurityPermissions permission) {
        NBTTagCompound tag = Platform.openNbtData(itemStack);
        if (tag.hasKey(permission.name())) {
            tag.removeTag(permission.name());
        }
    }

    @Override
    public void addPermission(ItemStack itemStack, SecurityPermissions permission) {
        NBTTagCompound tag = Platform.openNbtData(itemStack);
        tag.setBoolean(permission.name(), true);
    }

    @Override
    public void registerPermissions(ISecurityRegistry register, IPlayerRegistry pr, ItemStack is) {
        register.addPlayer(pr.getID(this.getProfile(is)), this.getPermissions(is));
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        EnumSet<SecurityPermissions> perms = this.getPermissions(stack);
        if (perms.isEmpty()) {
            lines.add(GuiText.NoPermissions.getLocal());
        } else {
            String msg = null;
            for (SecurityPermissions sp : perms) {
                if (msg == null) {
                    msg = Platform.gui_localize(sp.getUnlocalizedName());
                    continue;
                }
                msg = msg + ", " + Platform.gui_localize(sp.getUnlocalizedName());
            }
            lines.add(msg);
        }
    }
}

